/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.soap.SOAPException;

class FactoryFinder {
    FactoryFinder() {
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws SOAPException {
        try {
            Class spiClass = FactoryFinder.safeLoadClass(className, classLoader);
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new SOAPException("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new SOAPException("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    static Object find(String factoryId) throws SOAPException {
        return FactoryFinder.find(factoryId, null, false);
    }

    static Object find(String factoryId, String fallbackClassName) throws SOAPException {
        return FactoryFinder.find(factoryId, fallbackClassName, true);
    }

    static Object find(String factoryId, String defaultClassName, boolean tryFallback) throws SOAPException {
        ClassLoader classLoader;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception x) {
            throw new SOAPException(x.toString(), x);
        }
        try {
            String systemProp = System.getProperty(factoryId);
            if (systemProp != null) {
                return FactoryFinder.newInstance(systemProp, classLoader);
            }
        }
        catch (SecurityException systemProp) {
            // empty catch block
        }
        try {
            String javah = System.getProperty("java.home");
            String configFile = javah + File.separator + "lib" + File.separator + "jaxm.properties";
            File f = new File(configFile);
            if (f.exists()) {
                Properties props = new Properties();
                props.load(new FileInputStream(f));
                String factoryClassName = props.getProperty(factoryId);
                return FactoryFinder.newInstance(factoryClassName, classLoader);
            }
        }
        catch (Exception javah) {
            // empty catch block
        }
        String serviceId = "META-INF/services/" + factoryId;
        try {
            InputStream is = null;
            is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId);
            if (is != null) {
                BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String factoryClassName = rd.readLine();
                rd.close();
                if (factoryClassName != null && !"".equals(factoryClassName)) {
                    return FactoryFinder.newInstance(factoryClassName, classLoader);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!tryFallback) {
            return null;
        }
        if (defaultClassName == null) {
            throw new SOAPException("Provider for " + factoryId + " cannot be found", null);
        }
        return FactoryFinder.newInstance(defaultClassName, classLoader);
    }

    private static Class safeLoadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            int i;
            SecurityManager s = System.getSecurityManager();
            if (s != null && (i = className.lastIndexOf(46)) != -1) {
                s.checkPackageAccess(className.substring(0, i));
            }
            if (classLoader == null) {
                return Class.forName(className);
            }
            return classLoader.loadClass(className);
        }
        catch (SecurityException se) {
            if (FactoryFinder.isDefaultImplementation(className)) {
                return Class.forName(className);
            }
            throw se;
        }
    }

    private static boolean isDefaultImplementation(String className) {
        return "com.sun.xml.internal.messaging.saaj.soap.ver1_1.SOAPMessageFactory1_1Impl".equals(className) || "com.sun.xml.internal.messaging.saaj.soap.ver1_1.SOAPFactory1_1Impl".equals(className) || "com.sun.xml.internal.messaging.saaj.client.p2p.HttpSOAPConnectionFactory".equals(className) || "com.sun.xml.internal.messaging.saaj.soap.SAAJMetaFactoryImpl".equals(className);
    }
}

