/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pkcs.jcajce;

import java.io.OutputStream;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.jcajce.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.JcaJceHelper;
import org.bouncycastle.jcajce.NamedJcaJceHelper;
import org.bouncycastle.jcajce.ProviderJcaJceHelper;
import org.bouncycastle.operator.DefaultSecretKeySizeProvider;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.operator.SecretKeySizeProvider;

public class JcePKCSPBEOutputEncryptorBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private ASN1ObjectIdentifier algorithm;
    private ASN1ObjectIdentifier keyEncAlgorithm;
    private SecureRandom random;
    private SecretKeySizeProvider keySizeProvider = DefaultSecretKeySizeProvider.INSTANCE;

    public JcePKCSPBEOutputEncryptorBuilder(ASN1ObjectIdentifier algorithm) {
        if (this.isPKCS12(algorithm)) {
            this.algorithm = algorithm;
            this.keyEncAlgorithm = algorithm;
        } else {
            this.algorithm = PKCSObjectIdentifiers.id_PBES2;
            this.keyEncAlgorithm = algorithm;
        }
    }

    public JcePKCSPBEOutputEncryptorBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCSPBEOutputEncryptorBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JcePKCSPBEOutputEncryptorBuilder setKeySizeProvider(SecretKeySizeProvider keySizeProvider) {
        this.keySizeProvider = keySizeProvider;
        return this;
    }

    public OutputEncryptor build(final char[] password) throws OperatorCreationException {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byte[] salt = new byte[20];
        int iterationCount = 1024;
        this.random.nextBytes(salt);
        try {
            AlgorithmIdentifier encryptionAlg;
            Cipher cipher;
            if (this.algorithm.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                PBEKeySpec pbeSpec = new PBEKeySpec(password);
                SecretKeyFactory keyFact = this.helper.createSecretKeyFactory(this.algorithm.getId());
                PBEParameterSpec defParams = new PBEParameterSpec(salt, 1024);
                SecretKey key = keyFact.generateSecret(pbeSpec);
                cipher = this.helper.createCipher(this.algorithm.getId());
                cipher.init(1, (Key)key, defParams);
                encryptionAlg = new AlgorithmIdentifier(this.algorithm, (ASN1Encodable)new PKCS12PBEParams(salt, 1024));
            } else if (this.algorithm.equals((Object)PKCSObjectIdentifiers.id_PBES2)) {
                SecretKeyFactory keyFact = this.helper.createSecretKeyFactory(PKCSObjectIdentifiers.id_PBKDF2.getId());
                SecretKey key = keyFact.generateSecret(new PBEKeySpec(password, salt, 1024, this.keySizeProvider.getKeySize(new AlgorithmIdentifier(this.keyEncAlgorithm))));
                cipher = this.helper.createCipher(this.keyEncAlgorithm.getId());
                cipher.init(1, (Key)key, this.random);
                PBES2Parameters algParams = new PBES2Parameters(new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, (ASN1Encodable)new PBKDF2Params(salt, 1024)), new EncryptionScheme(this.keyEncAlgorithm, (ASN1Encodable)ASN1Primitive.fromByteArray((byte[])cipher.getParameters().getEncoded())));
                encryptionAlg = new AlgorithmIdentifier(this.algorithm, (ASN1Encodable)algParams);
            } else {
                throw new OperatorCreationException("unrecognised algorithm");
            }
            return new OutputEncryptor(){

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return encryptionAlg;
                }

                public OutputStream getOutputStream(OutputStream out) {
                    return new CipherOutputStream(out, cipher);
                }

                public GenericKey getKey() {
                    if (JcePKCSPBEOutputEncryptorBuilder.this.isPKCS12(encryptionAlg.getAlgorithm())) {
                        return new GenericKey(encryptionAlg, PBEParametersGenerator.PKCS5PasswordToBytes((char[])password));
                    }
                    return new GenericKey(encryptionAlg, PBEParametersGenerator.PKCS12PasswordToBytes((char[])password));
                }
            };
        }
        catch (Exception e) {
            throw new OperatorCreationException("unable to create OutputEncryptor: " + e.getMessage(), e);
        }
    }

    private boolean isPKCS12(ASN1ObjectIdentifier algorithm) {
        return algorithm.on(PKCSObjectIdentifiers.pkcs_12PbeIds) || algorithm.on(BCObjectIdentifiers.bc_pbe_sha1_pkcs12) || algorithm.on(BCObjectIdentifiers.bc_pbe_sha256_pkcs12);
    }
}

