/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Map;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialDatalink;
import javax.sql.rowset.serial.SerialException;
import javax.sql.rowset.serial.SerialJavaObject;
import javax.sql.rowset.serial.SerialStruct;

public class SerialArray
implements Array,
Serializable,
Cloneable {
    private Object[] elements;
    private int baseType;
    private String baseTypeName;
    private int len;
    static final long serialVersionUID = -8466174297270688520L;

    public SerialArray(Array array, Map<String, Class<?>> map) throws SerialException, SQLException {
        if (array == null || map == null) {
            throw new SQLException("Cannot instantiate a SerialArray object with null parameters");
        }
        this.elements = (Object[])array.getArray();
        if (this.elements == null) {
            throw new SQLException("Invalid Array object. Calls to Array.getArray() return null value which cannot be serialized");
        }
        this.elements = (Object[])array.getArray(map);
        this.baseType = array.getBaseType();
        this.baseTypeName = array.getBaseTypeName();
        this.len = this.elements.length;
        switch (this.baseType) {
            case 2002: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialStruct((Struct)this.elements[i], map);
                }
                break;
            }
            case 2003: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialArray((Array)this.elements[i], map);
                }
                break;
            }
            case 2004: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialBlob((Blob)this.elements[i]);
                }
                break;
            }
            case 2005: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialClob((Clob)this.elements[i]);
                }
                break;
            }
            case 70: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialDatalink((URL)this.elements[i]);
                }
                break;
            }
            case 2000: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialJavaObject(this.elements[i]);
                }
                break;
            }
        }
    }

    @Override
    public void free() throws SQLException {
        if (this.elements != null) {
            this.elements = null;
            this.baseTypeName = null;
        }
    }

    public SerialArray(Array array) throws SerialException, SQLException {
        if (array == null) {
            throw new SQLException("Cannot instantiate a SerialArray object with a null Array object");
        }
        this.elements = (Object[])array.getArray();
        if (this.elements == null) {
            throw new SQLException("Invalid Array object. Calls to Array.getArray() return null value which cannot be serialized");
        }
        this.baseType = array.getBaseType();
        this.baseTypeName = array.getBaseTypeName();
        this.len = this.elements.length;
        switch (this.baseType) {
            case 2004: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialBlob((Blob)this.elements[i]);
                }
                break;
            }
            case 2005: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialClob((Clob)this.elements[i]);
                }
                break;
            }
            case 70: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialDatalink((URL)this.elements[i]);
                }
                break;
            }
            case 2000: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialJavaObject(this.elements[i]);
                }
                break;
            }
        }
    }

    @Override
    public Object getArray() throws SerialException {
        this.isValid();
        Object[] dst = new Object[this.len];
        System.arraycopy(this.elements, 0, dst, 0, this.len);
        return dst;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SerialException {
        this.isValid();
        Object[] dst = new Object[this.len];
        System.arraycopy(this.elements, 0, dst, 0, this.len);
        return dst;
    }

    @Override
    public Object getArray(long index, int count) throws SerialException {
        this.isValid();
        Object[] dst = new Object[count];
        System.arraycopy(this.elements, (int)index, dst, 0, count);
        return dst;
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SerialException {
        this.isValid();
        Object[] dst = new Object[count];
        System.arraycopy(this.elements, (int)index, dst, 0, count);
        return dst;
    }

    @Override
    public int getBaseType() throws SerialException {
        this.isValid();
        return this.baseType;
    }

    @Override
    public String getBaseTypeName() throws SerialException {
        this.isValid();
        return this.baseTypeName;
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SerialException {
        SerialException se = new SerialException();
        se.initCause(new UnsupportedOperationException());
        throw se;
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SerialException {
        SerialException se = new SerialException();
        se.initCause(new UnsupportedOperationException());
        throw se;
    }

    @Override
    public ResultSet getResultSet() throws SerialException {
        SerialException se = new SerialException();
        se.initCause(new UnsupportedOperationException());
        throw se;
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SerialException {
        SerialException se = new SerialException();
        se.initCause(new UnsupportedOperationException());
        throw se;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SerialArray) {
            SerialArray sa = (SerialArray)obj;
            return this.baseType == sa.baseType && this.baseTypeName.equals(sa.baseTypeName) && Arrays.equals(this.elements, sa.elements);
        }
        return false;
    }

    public int hashCode() {
        return (((31 + Arrays.hashCode(this.elements)) * 31 + this.len) * 31 + this.baseType) * 31 + this.baseTypeName.hashCode();
    }

    public Object clone() {
        try {
            SerialArray sa = (SerialArray)super.clone();
            sa.elements = this.elements != null ? Arrays.copyOf(this.elements, this.len) : null;
            return sa;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = s.readFields();
        Object[] tmp = (Object[])fields.get("elements", null);
        if (tmp == null) {
            throw new InvalidObjectException("elements is null and should not be!");
        }
        this.elements = (Object[])tmp.clone();
        this.len = fields.get("len", 0);
        if (this.elements.length != this.len) {
            throw new InvalidObjectException("elements is not the expected size");
        }
        this.baseType = fields.get("baseType", 0);
        this.baseTypeName = (String)fields.get("baseTypeName", null);
    }

    private void writeObject(ObjectOutputStream s) throws IOException, ClassNotFoundException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("elements", this.elements);
        fields.put("len", this.len);
        fields.put("baseType", this.baseType);
        fields.put("baseTypeName", this.baseTypeName);
        s.writeFields();
    }

    private void isValid() throws SerialException {
        if (this.elements == null) {
            throw new SerialException("Error: You cannot call a method on a SerialArray instance once free() has been called.");
        }
    }
}

