/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsName;
import java.io.UnsupportedEncodingException;
import javax.naming.InvalidNameException;

public class ResourceRecord {
    static final int TYPE_A = 1;
    static final int TYPE_NS = 2;
    static final int TYPE_CNAME = 5;
    static final int TYPE_SOA = 6;
    static final int TYPE_PTR = 12;
    static final int TYPE_HINFO = 13;
    static final int TYPE_MX = 15;
    static final int TYPE_TXT = 16;
    static final int TYPE_AAAA = 28;
    static final int TYPE_SRV = 33;
    static final int TYPE_NAPTR = 35;
    static final int QTYPE_AXFR = 252;
    static final int QTYPE_STAR = 255;
    static final String[] rrTypeNames = new String[]{null, "A", "NS", null, null, "CNAME", "SOA", null, null, null, null, null, "PTR", "HINFO", null, "MX", "TXT", null, null, null, null, null, null, null, null, null, null, null, "AAAA", null, null, null, null, "SRV", null, "NAPTR"};
    static final int CLASS_INTERNET = 1;
    static final int CLASS_HESIOD = 2;
    static final int QCLASS_STAR = 255;
    static final String[] rrClassNames = new String[]{null, "IN", null, null, "HS"};
    byte[] msg;
    int msgLen;
    boolean qSection;
    int offset;
    int rrlen;
    DnsName name;
    int rrtype;
    String rrtypeName;
    int rrclass;
    String rrclassName;
    int ttl = 0;
    int rdlen = 0;
    Object rdata = null;

    ResourceRecord(byte[] msg, int msgLen, int offset, boolean qSection, boolean decodeRdata) throws InvalidNameException {
        this.msg = msg;
        this.msgLen = msgLen;
        this.offset = offset;
        this.qSection = qSection;
        this.decode(decodeRdata);
    }

    public String toString() {
        String text = this.name + " " + this.rrclassName + " " + this.rrtypeName;
        if (!this.qSection) {
            text = text + " " + this.ttl + " " + (this.rdata != null ? this.rdata : "[n/a]");
        }
        return text;
    }

    public DnsName getName() {
        return this.name;
    }

    public int size() {
        return this.rrlen;
    }

    public int getType() {
        return this.rrtype;
    }

    public int getRrclass() {
        return this.rrclass;
    }

    public Object getRdata() {
        return this.rdata;
    }

    public static String getTypeName(int rrtype) {
        return ResourceRecord.valueToName(rrtype, rrTypeNames);
    }

    public static int getType(String typeName) {
        return ResourceRecord.nameToValue(typeName, rrTypeNames);
    }

    public static String getRrclassName(int rrclass) {
        return ResourceRecord.valueToName(rrclass, rrClassNames);
    }

    public static int getRrclass(String className) {
        return ResourceRecord.nameToValue(className, rrClassNames);
    }

    private static String valueToName(int val, String[] names) {
        String name = null;
        if (val > 0 && val < names.length) {
            name = names[val];
        } else if (val == 255) {
            name = "*";
        }
        if (name == null) {
            name = Integer.toString(val);
        }
        return name;
    }

    private static int nameToValue(String name, String[] names) {
        if (name.equals("")) {
            return -1;
        }
        if (name.equals("*")) {
            return 255;
        }
        if (Character.isDigit(name.charAt(0))) {
            try {
                return Integer.parseInt(name);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (int i = 1; i < names.length; ++i) {
            if (names[i] == null || !name.equalsIgnoreCase(names[i])) continue;
            return i;
        }
        return -1;
    }

    public static int compareSerialNumbers(long s1, long s2) {
        long diff = s2 - s1;
        if (diff == 0L) {
            return 0;
        }
        if (diff > 0L && diff <= Integer.MAX_VALUE || diff < 0L && -diff > Integer.MAX_VALUE) {
            return -1;
        }
        return 1;
    }

    private void decode(boolean decodeRdata) throws InvalidNameException {
        int pos = this.offset;
        this.name = new DnsName();
        pos = this.decodeName(pos, this.name);
        this.rrtype = this.getUShort(pos);
        String string = this.rrtypeName = this.rrtype < rrTypeNames.length ? rrTypeNames[this.rrtype] : null;
        if (this.rrtypeName == null) {
            this.rrtypeName = Integer.toString(this.rrtype);
        }
        this.rrclass = this.getUShort(pos += 2);
        String string2 = this.rrclassName = this.rrclass < rrClassNames.length ? rrClassNames[this.rrclass] : null;
        if (this.rrclassName == null) {
            this.rrclassName = Integer.toString(this.rrclass);
        }
        pos += 2;
        if (!this.qSection) {
            this.ttl = this.getInt(pos);
            this.rdlen = this.getUShort(pos += 4);
            Object object = this.rdata = decodeRdata || this.rrtype == 6 ? this.decodeRdata(pos += 2) : null;
            if (this.rdata instanceof DnsName) {
                this.rdata = this.rdata.toString();
            }
            pos += this.rdlen;
        }
        this.rrlen = pos - this.offset;
        this.msg = null;
    }

    private int getUByte(int pos) {
        return this.msg[pos] & 0xFF;
    }

    private int getUShort(int pos) {
        return (this.msg[pos] & 0xFF) << 8 | this.msg[pos + 1] & 0xFF;
    }

    private int getInt(int pos) {
        return this.getUShort(pos) << 16 | this.getUShort(pos + 2);
    }

    private long getUInt(int pos) {
        return (long)this.getInt(pos) & 0xFFFFFFFFL;
    }

    private DnsName decodeName(int pos) throws InvalidNameException {
        DnsName n = new DnsName();
        this.decodeName(pos, n);
        return n;
    }

    private int decodeName(int pos, DnsName n) throws InvalidNameException {
        if (this.msg[pos] == 0) {
            n.add(0, "");
            return pos + 1;
        }
        if ((this.msg[pos] & 0xC0) != 0) {
            this.decodeName(this.getUShort(pos) & 0x3FFF, n);
            return pos + 2;
        }
        byte len = this.msg[pos++];
        try {
            n.add(0, new String(this.msg, pos, (int)len, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.decodeName(pos + len, n);
    }

    private Object decodeRdata(int pos) throws InvalidNameException {
        if (this.rrclass == 1) {
            switch (this.rrtype) {
                case 1: {
                    return this.decodeA(pos);
                }
                case 28: {
                    return this.decodeAAAA(pos);
                }
                case 2: 
                case 5: 
                case 12: {
                    return this.decodeName(pos);
                }
                case 15: {
                    return this.decodeMx(pos);
                }
                case 6: {
                    return this.decodeSoa(pos);
                }
                case 33: {
                    return this.decodeSrv(pos);
                }
                case 35: {
                    return this.decodeNaptr(pos);
                }
                case 16: {
                    return this.decodeTxt(pos);
                }
                case 13: {
                    return this.decodeHinfo(pos);
                }
            }
        }
        byte[] rd = new byte[this.rdlen];
        System.arraycopy(this.msg, pos, rd, 0, this.rdlen);
        return rd;
    }

    private String decodeMx(int pos) throws InvalidNameException {
        int preference = this.getUShort(pos);
        DnsName name = this.decodeName(pos += 2);
        return preference + " " + name;
    }

    private String decodeSoa(int pos) throws InvalidNameException {
        DnsName mname = new DnsName();
        pos = this.decodeName(pos, mname);
        DnsName rname = new DnsName();
        pos = this.decodeName(pos, rname);
        long serial = this.getUInt(pos);
        long refresh = this.getUInt(pos += 4);
        long retry = this.getUInt(pos += 4);
        long expire = this.getUInt(pos += 4);
        long minimum = this.getUInt(pos += 4);
        pos += 4;
        return mname + " " + rname + " " + serial + " " + refresh + " " + retry + " " + expire + " " + minimum;
    }

    private String decodeSrv(int pos) throws InvalidNameException {
        int priority = this.getUShort(pos);
        int weight = this.getUShort(pos += 2);
        int port = this.getUShort(pos += 2);
        DnsName target = this.decodeName(pos += 2);
        return priority + " " + weight + " " + port + " " + target;
    }

    private String decodeNaptr(int pos) throws InvalidNameException {
        int order = this.getUShort(pos);
        int preference = this.getUShort(pos += 2);
        pos += 2;
        StringBuffer flags = new StringBuffer();
        pos += this.decodeCharString(pos, flags);
        StringBuffer services = new StringBuffer();
        pos += this.decodeCharString(pos, services);
        StringBuffer regexp = new StringBuffer(this.rdlen);
        pos += this.decodeCharString(pos, regexp);
        DnsName replacement = this.decodeName(pos);
        return order + " " + preference + " " + flags + " " + services + " " + regexp + " " + replacement;
    }

    private String decodeTxt(int pos) {
        StringBuffer buf = new StringBuffer(this.rdlen);
        int end = pos + this.rdlen;
        while (pos < end) {
            if ((pos += this.decodeCharString(pos, buf)) >= end) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    private String decodeHinfo(int pos) {
        StringBuffer buf = new StringBuffer(this.rdlen);
        pos += this.decodeCharString(pos, buf);
        buf.append(' ');
        pos += this.decodeCharString(pos, buf);
        return buf.toString();
    }

    private int decodeCharString(int pos, StringBuffer buf) {
        int len;
        int start = buf.length();
        boolean quoted = (len = this.getUByte(pos++)) == 0;
        for (int i = 0; i < len; ++i) {
            int c;
            quoted |= (c = this.getUByte(pos++)) == 32;
            if (c == 92 || c == 34) {
                quoted = true;
                buf.append('\\');
            }
            buf.append((char)c);
        }
        if (quoted) {
            buf.insert(start, '\"');
            buf.append('\"');
        }
        return len + 1;
    }

    private String decodeA(int pos) {
        return (this.msg[pos] & 0xFF) + "." + (this.msg[pos + 1] & 0xFF) + "." + (this.msg[pos + 2] & 0xFF) + "." + (this.msg[pos + 3] & 0xFF);
    }

    private String decodeAAAA(int pos) {
        int[] addr6 = new int[8];
        for (int i = 0; i < 8; ++i) {
            addr6[i] = this.getUShort(pos);
            pos += 2;
        }
        int curBase = -1;
        int curLen = 0;
        int bestBase = -1;
        int bestLen = 0;
        for (int i = 0; i < 8; ++i) {
            if (addr6[i] == 0) {
                if (curBase == -1) {
                    curBase = i;
                    curLen = 1;
                    continue;
                }
                if (++curLen < 2 || curLen <= bestLen) continue;
                bestBase = curBase;
                bestLen = curLen;
                continue;
            }
            curBase = -1;
        }
        if (bestBase == 0) {
            if (bestLen == 6 || bestLen == 7 && addr6[7] > 1) {
                return "::" + this.decodeA(pos - 4);
            }
            if (bestLen == 5 && addr6[5] == 65535) {
                return "::ffff:" + this.decodeA(pos - 4);
            }
        }
        boolean compress = bestBase != -1;
        StringBuffer buf = new StringBuffer(40);
        if (bestBase == 0) {
            buf.append(':');
        }
        for (int i = 0; i < 8; ++i) {
            if (!compress || i < bestBase || i >= bestBase + bestLen) {
                buf.append(Integer.toHexString(addr6[i]));
                if (i >= 7) continue;
                buf.append(':');
                continue;
            }
            if (!compress || i != bestBase) continue;
            buf.append(':');
        }
        return buf.toString();
    }
}

