/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.util.KerberosFlags;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

public class KDCOptions
extends KerberosFlags {
    private static final int KDC_OPT_PROXIABLE = 0x10000000;
    private static final int KDC_OPT_RENEWABLE_OK = 16;
    private static final int KDC_OPT_FORWARDABLE = 0x40000000;
    public static final int RESERVED = 0;
    public static final int FORWARDABLE = 1;
    public static final int FORWARDED = 2;
    public static final int PROXIABLE = 3;
    public static final int PROXY = 4;
    public static final int ALLOW_POSTDATE = 5;
    public static final int POSTDATED = 6;
    public static final int UNUSED7 = 7;
    public static final int RENEWABLE = 8;
    public static final int UNUSED9 = 9;
    public static final int UNUSED10 = 10;
    public static final int UNUSED11 = 11;
    public static final int CNAME_IN_ADDL_TKT = 14;
    public static final int RENEWABLE_OK = 27;
    public static final int ENC_TKT_IN_SKEY = 28;
    public static final int RENEW = 30;
    public static final int VALIDATE = 31;
    private static final String[] names = new String[]{"RESERVED", "FORWARDABLE", "FORWARDED", "PROXIABLE", "PROXY", "ALLOW_POSTDATE", "POSTDATED", "UNUSED7", "RENEWABLE", "UNUSED9", "UNUSED10", "UNUSED11", null, null, "CNAME_IN_ADDL_TKT", null, null, null, null, null, null, null, null, null, null, null, null, "RENEWABLE_OK", "ENC_TKT_IN_SKEY", null, "RENEW", "VALIDATE"};
    private boolean DEBUG = Krb5.DEBUG;

    public static KDCOptions with(int ... flags) {
        KDCOptions options = new KDCOptions();
        for (int flag : flags) {
            options.set(flag, true);
        }
        return options;
    }

    public KDCOptions() {
        super(32);
        this.setDefault();
    }

    public KDCOptions(int size, byte[] data) throws Asn1Exception {
        super(size, data);
        if (size > data.length * 8 || size > 32) {
            throw new Asn1Exception(502);
        }
    }

    public KDCOptions(boolean[] data) throws Asn1Exception {
        super(data);
        if (data.length > 32) {
            throw new Asn1Exception(502);
        }
    }

    public KDCOptions(DerValue encoding) throws Asn1Exception, IOException {
        this(encoding.getUnalignedBitString(true).toBooleanArray());
    }

    public KDCOptions(byte[] options) {
        super(options.length * 8, options);
    }

    public static KDCOptions parse(DerInputStream data, byte explicitTag, boolean optional) throws Asn1Exception, IOException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        return new KDCOptions(subDer);
    }

    @Override
    public void set(int option, boolean value) throws ArrayIndexOutOfBoundsException {
        super.set(option, value);
    }

    @Override
    public boolean get(int option) throws ArrayIndexOutOfBoundsException {
        return super.get(option);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("KDCOptions: ");
        for (int i = 0; i < 32; ++i) {
            if (!this.get(i)) continue;
            if (names[i] != null) {
                sb.append(names[i]).append(",");
                continue;
            }
            sb.append(i).append(",");
        }
        return sb.toString();
    }

    private void setDefault() {
        block11: {
            try {
                Config config = Config.getInstance();
                int options = config.getIntValue("libdefaults", "kdc_default_options");
                if ((options & 0x10) == 16) {
                    this.set(27, true);
                } else if (config.getBooleanValue("libdefaults", "renewable")) {
                    this.set(27, true);
                }
                if ((options & 0x10000000) == 0x10000000) {
                    this.set(3, true);
                } else if (config.getBooleanValue("libdefaults", "proxiable")) {
                    this.set(3, true);
                }
                if ((options & 0x40000000) == 0x40000000) {
                    this.set(1, true);
                } else if (config.getBooleanValue("libdefaults", "forwardable")) {
                    this.set(1, true);
                }
            }
            catch (KrbException e) {
                if (!this.DEBUG) break block11;
                System.out.println("Exception in getting default values for KDC Options from the configuration ");
                e.printStackTrace();
            }
        }
    }
}

