/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.registry;

import java.io.FilePermission;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.misc.URLClassPath;
import sun.rmi.server.LoaderHandler;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.server.UnicastServerRef2;
import sun.rmi.transport.LiveRef;

public class RegistryImpl
extends RemoteServer
implements Registry {
    private static final long serialVersionUID = 4666870661827494597L;
    private Hashtable<String, Remote> bindings = new Hashtable(101);
    private static Hashtable<InetAddress, InetAddress> allowedAccessCache = new Hashtable(3);
    private static RegistryImpl registry;
    private static ObjID id;
    private static ResourceBundle resources;

    public RegistryImpl(final int port, final RMIClientSocketFactory csf, final RMIServerSocketFactory ssf) throws RemoteException {
        if (port == 1099 && System.getSecurityManager() != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws RemoteException {
                        LiveRef lref = new LiveRef(id, port, csf, ssf);
                        RegistryImpl.this.setup(new UnicastServerRef2(lref));
                        return null;
                    }
                }, null, new SocketPermission("localhost:" + port, "listen,accept"));
            }
            catch (PrivilegedActionException pae) {
                throw (RemoteException)pae.getException();
            }
        } else {
            LiveRef lref = new LiveRef(id, port, csf, ssf);
            this.setup(new UnicastServerRef2(lref));
        }
    }

    public RegistryImpl(final int port) throws RemoteException {
        if (port == 1099 && System.getSecurityManager() != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws RemoteException {
                        LiveRef lref = new LiveRef(id, port);
                        RegistryImpl.this.setup(new UnicastServerRef(lref));
                        return null;
                    }
                }, null, new SocketPermission("localhost:" + port, "listen,accept"));
            }
            catch (PrivilegedActionException pae) {
                throw (RemoteException)pae.getException();
            }
        } else {
            LiveRef lref = new LiveRef(id, port);
            this.setup(new UnicastServerRef(lref));
        }
    }

    private void setup(UnicastServerRef uref) throws RemoteException {
        this.ref = uref;
        uref.exportObject(this, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Remote lookup(String name) throws RemoteException, NotBoundException {
        Hashtable<String, Remote> hashtable = this.bindings;
        synchronized (hashtable) {
            Remote obj = this.bindings.get(name);
            if (obj == null) {
                throw new NotBoundException(name);
            }
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(String name, Remote obj) throws RemoteException, AlreadyBoundException, AccessException {
        RegistryImpl.checkAccess("Registry.bind");
        Hashtable<String, Remote> hashtable = this.bindings;
        synchronized (hashtable) {
            Remote curr = this.bindings.get(name);
            if (curr != null) {
                throw new AlreadyBoundException(name);
            }
            this.bindings.put(name, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(String name) throws RemoteException, NotBoundException, AccessException {
        RegistryImpl.checkAccess("Registry.unbind");
        Hashtable<String, Remote> hashtable = this.bindings;
        synchronized (hashtable) {
            Remote obj = this.bindings.get(name);
            if (obj == null) {
                throw new NotBoundException(name);
            }
            this.bindings.remove(name);
        }
    }

    @Override
    public void rebind(String name, Remote obj) throws RemoteException, AccessException {
        RegistryImpl.checkAccess("Registry.rebind");
        this.bindings.put(name, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] list() throws RemoteException {
        String[] names;
        Hashtable<String, Remote> hashtable = this.bindings;
        synchronized (hashtable) {
            int i = this.bindings.size();
            names = new String[i];
            Enumeration<String> enum_ = this.bindings.keys();
            while (--i >= 0) {
                names[i] = enum_.nextElement();
            }
        }
        return names;
    }

    public static void checkAccess(String op) throws AccessException {
        block8: {
            try {
                InetAddress clientHost;
                final String clientHostName = RegistryImpl.getClientHost();
                try {
                    clientHost = AccessController.doPrivileged(new PrivilegedExceptionAction<InetAddress>(){

                        @Override
                        public InetAddress run() throws UnknownHostException {
                            return InetAddress.getByName(clientHostName);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw (UnknownHostException)pae.getException();
                }
                if (allowedAccessCache.get(clientHost) != null) break block8;
                if (clientHost.isAnyLocalAddress()) {
                    throw new AccessException("Registry." + op + " disallowed; origin unknown");
                }
                try {
                    final InetAddress finalClientHost = clientHost;
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws IOException {
                            new ServerSocket(0, 10, finalClientHost).close();
                            allowedAccessCache.put(finalClientHost, finalClientHost);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw new AccessException("Registry." + op + " disallowed; origin " + clientHost + " is non-local host");
                }
            }
            catch (ServerNotActiveException clientHostName) {
            }
            catch (UnknownHostException ex) {
                throw new AccessException("Registry." + op + " disallowed; origin is unknown host");
            }
        }
    }

    public static ObjID getID() {
        return id;
    }

    private static String getTextResource(String key) {
        if (resources == null) {
            try {
                resources = ResourceBundle.getBundle("sun.rmi.registry.resources.rmiregistry");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (resources == null) {
                return "[missing resource file: " + key + "]";
            }
        }
        String val = null;
        try {
            val = resources.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (val == null) {
            return "[missing resource: " + key + "]";
        }
        return val;
    }

    public static void main(String[] args) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            String envcp = System.getProperty("env.class.path");
            if (envcp == null) {
                envcp = ".";
            }
            URL[] urls = URLClassPath.pathToURLs(envcp);
            URLClassLoader cl = new URLClassLoader(urls);
            LoaderHandler.registerCodebaseLoader(cl);
            Thread.currentThread().setContextClassLoader(cl);
            final int regPort = args.length >= 1 ? Integer.parseInt(args[0]) : 1099;
            try {
                registry = AccessController.doPrivileged(new PrivilegedExceptionAction<RegistryImpl>(){

                    @Override
                    public RegistryImpl run() throws RemoteException {
                        return new RegistryImpl(regPort);
                    }
                }, RegistryImpl.getAccessControlContext(regPort));
            }
            catch (PrivilegedActionException ex) {
                throw (RemoteException)ex.getException();
            }
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(Long.MAX_VALUE);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (NumberFormatException e) {
            System.err.println(MessageFormat.format(RegistryImpl.getTextResource("rmiregistry.port.badnumber"), args[0]));
            System.err.println(MessageFormat.format(RegistryImpl.getTextResource("rmiregistry.usage"), "rmiregistry"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    private static AccessControlContext getAccessControlContext(int port) {
        PermissionCollection perms = AccessController.doPrivileged(new PrivilegedAction<PermissionCollection>(){

            @Override
            public PermissionCollection run() {
                CodeSource codesource = new CodeSource(null, (Certificate[])null);
                Policy p = Policy.getPolicy();
                if (p != null) {
                    return p.getPermissions(codesource);
                }
                return new Permissions();
            }
        });
        perms.add(new SocketPermission("*", "connect,accept"));
        perms.add(new SocketPermission("localhost:" + port, "listen,accept"));
        perms.add(new RuntimePermission("accessClassInPackage.sun.jvmstat.*"));
        perms.add(new RuntimePermission("accessClassInPackage.sun.jvm.hotspot.*"));
        perms.add(new FilePermission("<<ALL FILES>>", "read"));
        ProtectionDomain pd = new ProtectionDomain(new CodeSource(null, (Certificate[])null), perms);
        return new AccessControlContext(new ProtectionDomain[]{pd});
    }

    static {
        id = new ObjID(0);
        resources = null;
    }
}

