/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Closeable;
import java.io.IOException;
import java.net.AbstractPlainDatagramSocketImpl;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.DatagramSocketImplFactory;
import java.net.DefaultDatagramSocketImplFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class DatagramSocket
implements Closeable {
    private boolean created = false;
    private boolean bound = false;
    private boolean closed = false;
    private Object closeLock = new Object();
    DatagramSocketImpl impl;
    boolean oldImpl = false;
    private boolean explicitFilter = false;
    private int bytesLeftToFilter;
    static final int ST_NOT_CONNECTED = 0;
    static final int ST_CONNECTED = 1;
    static final int ST_CONNECTED_NO_IMPL = 2;
    int connectState = 0;
    InetAddress connectedAddress = null;
    int connectedPort = -1;
    static Class<?> implClass = null;
    static DatagramSocketImplFactory factory;

    private synchronized void connectInternal(InetAddress address, int port) throws SocketException {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("connect: " + port);
        }
        if (address == null) {
            throw new IllegalArgumentException("connect: null address");
        }
        this.checkAddress(address, "connect");
        if (this.isClosed()) {
            return;
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            if (address.isMulticastAddress()) {
                security.checkMulticast(address);
            } else {
                security.checkConnect(address.getHostAddress(), port);
                security.checkAccept(address.getHostAddress(), port);
            }
        }
        if (!this.isBound()) {
            this.bind(new InetSocketAddress(0));
        }
        if (this.oldImpl || this.impl instanceof AbstractPlainDatagramSocketImpl && ((AbstractPlainDatagramSocketImpl)this.impl).nativeConnectDisabled()) {
            this.connectState = 2;
        } else {
            try {
                this.getImpl().connect(address, port);
                this.connectState = 1;
                int avail = this.getImpl().dataAvailable();
                if (avail == -1) {
                    throw new SocketException();
                }
                boolean bl = this.explicitFilter = avail > 0;
                if (this.explicitFilter) {
                    this.bytesLeftToFilter = this.getReceiveBufferSize();
                }
            }
            catch (SocketException se) {
                this.connectState = 2;
            }
        }
        this.connectedAddress = address;
        this.connectedPort = port;
    }

    public DatagramSocket() throws SocketException {
        this(new InetSocketAddress(0));
    }

    protected DatagramSocket(DatagramSocketImpl impl) {
        if (impl == null) {
            throw new NullPointerException();
        }
        this.impl = impl;
        this.checkOldImpl();
    }

    public DatagramSocket(SocketAddress bindaddr) throws SocketException {
        this.createImpl();
        if (bindaddr != null) {
            try {
                this.bind(bindaddr);
            }
            finally {
                if (!this.isBound()) {
                    this.close();
                }
            }
        }
    }

    public DatagramSocket(int port) throws SocketException {
        this(port, null);
    }

    public DatagramSocket(int port, InetAddress laddr) throws SocketException {
        this(new InetSocketAddress(laddr, port));
    }

    private void checkOldImpl() {
        if (this.impl == null) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws NoSuchMethodException {
                    Class[] cl = new Class[]{DatagramPacket.class};
                    DatagramSocket.this.impl.getClass().getDeclaredMethod("peekData", cl);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.oldImpl = true;
        }
    }

    void createImpl() throws SocketException {
        if (this.impl == null) {
            if (factory != null) {
                this.impl = factory.createDatagramSocketImpl();
                this.checkOldImpl();
            } else {
                boolean isMulticast = this instanceof MulticastSocket;
                this.impl = DefaultDatagramSocketImplFactory.createDatagramSocketImpl(isMulticast);
                this.checkOldImpl();
            }
        }
        this.impl.create();
        this.impl.setDatagramSocket(this);
        this.created = true;
    }

    DatagramSocketImpl getImpl() throws SocketException {
        if (!this.created) {
            this.createImpl();
        }
        return this.impl;
    }

    public synchronized void bind(SocketAddress addr) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("already bound");
        }
        if (addr == null) {
            addr = new InetSocketAddress(0);
        }
        if (!(addr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type!");
        }
        InetSocketAddress epoint = (InetSocketAddress)addr;
        if (epoint.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        InetAddress iaddr = epoint.getAddress();
        int port = epoint.getPort();
        this.checkAddress(iaddr, "bind");
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkListen(port);
        }
        try {
            this.getImpl().bind(port, iaddr);
        }
        catch (SocketException e) {
            this.getImpl().close();
            throw e;
        }
        this.bound = true;
    }

    void checkAddress(InetAddress addr, String op) {
        if (addr == null) {
            return;
        }
        if (!(addr instanceof Inet4Address) && !(addr instanceof Inet6Address)) {
            throw new IllegalArgumentException(op + ": invalid address type");
        }
    }

    public void connect(InetAddress address, int port) {
        try {
            this.connectInternal(address, port);
        }
        catch (SocketException se) {
            throw new Error("connect failed", se);
        }
    }

    public void connect(SocketAddress addr) throws SocketException {
        if (addr == null) {
            throw new IllegalArgumentException("Address can't be null");
        }
        if (!(addr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress epoint = (InetSocketAddress)addr;
        if (epoint.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        this.connectInternal(epoint.getAddress(), epoint.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        DatagramSocket datagramSocket = this;
        synchronized (datagramSocket) {
            if (this.isClosed()) {
                return;
            }
            if (this.connectState == 1) {
                this.impl.disconnect();
            }
            this.connectedAddress = null;
            this.connectedPort = -1;
            this.connectState = 0;
            this.explicitFilter = false;
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    public boolean isConnected() {
        return this.connectState != 0;
    }

    public InetAddress getInetAddress() {
        return this.connectedAddress;
    }

    public int getPort() {
        return this.connectedPort;
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    public SocketAddress getLocalSocketAddress() {
        if (this.isClosed()) {
            return null;
        }
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(DatagramPacket p) throws IOException {
        InetAddress packetAddress = null;
        DatagramPacket datagramPacket = p;
        synchronized (datagramPacket) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            this.checkAddress(p.getAddress(), "send");
            if (this.connectState == 0) {
                SecurityManager security = System.getSecurityManager();
                if (security != null) {
                    if (p.getAddress().isMulticastAddress()) {
                        security.checkMulticast(p.getAddress());
                    } else {
                        security.checkConnect(p.getAddress().getHostAddress(), p.getPort());
                    }
                }
            } else {
                packetAddress = p.getAddress();
                if (packetAddress == null) {
                    p.setAddress(this.connectedAddress);
                    p.setPort(this.connectedPort);
                } else if (!packetAddress.equals(this.connectedAddress) || p.getPort() != this.connectedPort) {
                    throw new IllegalArgumentException("connected address and packet address differ");
                }
            }
            if (!this.isBound()) {
                this.bind(new InetSocketAddress(0));
            }
            this.getImpl().send(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void receive(DatagramPacket p) throws IOException {
        DatagramPacket datagramPacket = p;
        synchronized (datagramPacket) {
            SecurityManager security;
            if (!this.isBound()) {
                this.bind(new InetSocketAddress(0));
            }
            if (this.connectState == 0 && (security = System.getSecurityManager()) != null) {
                while (true) {
                    String peekAd = null;
                    int peekPort = 0;
                    if (!this.oldImpl) {
                        DatagramPacket peekPacket = new DatagramPacket(new byte[1], 1);
                        peekPort = this.getImpl().peekData(peekPacket);
                        peekAd = peekPacket.getAddress().getHostAddress();
                    } else {
                        InetAddress adr = new InetAddress();
                        peekPort = this.getImpl().peek(adr);
                        peekAd = adr.getHostAddress();
                    }
                    try {
                        security.checkAccept(peekAd, peekPort);
                    }
                    catch (SecurityException se) {
                        DatagramPacket tmp = new DatagramPacket(new byte[1], 1);
                        this.getImpl().receive(tmp);
                        continue;
                    }
                    break;
                }
            }
            DatagramPacket tmp = null;
            if (this.connectState == 2 || this.explicitFilter) {
                boolean stop = false;
                while (!stop) {
                    InetAddress peekAddress = null;
                    int peekPort = -1;
                    if (!this.oldImpl) {
                        DatagramPacket peekPacket = new DatagramPacket(new byte[1], 1);
                        peekPort = this.getImpl().peekData(peekPacket);
                        peekAddress = peekPacket.getAddress();
                    } else {
                        peekAddress = new InetAddress();
                        peekPort = this.getImpl().peek(peekAddress);
                    }
                    if (!this.connectedAddress.equals(peekAddress) || this.connectedPort != peekPort) {
                        tmp = new DatagramPacket(new byte[1024], 1024);
                        this.getImpl().receive(tmp);
                        if (!this.explicitFilter || !this.checkFiltering(tmp)) continue;
                        stop = true;
                        continue;
                    }
                    stop = true;
                }
            }
            this.getImpl().receive(p);
            if (this.explicitFilter && tmp == null) {
                this.checkFiltering(p);
            }
        }
    }

    private boolean checkFiltering(DatagramPacket p) throws SocketException {
        this.bytesLeftToFilter -= p.getLength();
        if (this.bytesLeftToFilter <= 0 || this.getImpl().dataAvailable() <= 0) {
            this.explicitFilter = false;
            return true;
        }
        return false;
    }

    public InetAddress getLocalAddress() {
        if (this.isClosed()) {
            return null;
        }
        InetAddress in = null;
        try {
            SecurityManager s;
            in = (InetAddress)this.getImpl().getOption(15);
            if (in.isAnyLocalAddress()) {
                in = InetAddress.anyLocalAddress();
            }
            if ((s = System.getSecurityManager()) != null) {
                s.checkConnect(in.getHostAddress(), -1);
            }
        }
        catch (Exception e) {
            in = InetAddress.anyLocalAddress();
        }
        return in;
    }

    public int getLocalPort() {
        if (this.isClosed()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4102, new Integer(timeout));
    }

    public synchronized int getSoTimeout() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.getImpl() == null) {
            return 0;
        }
        Object o = this.getImpl().getOption(4102);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    public synchronized void setSendBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("negative send size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4097, new Integer(size));
    }

    public synchronized int getSendBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int result = 0;
        Object o = this.getImpl().getOption(4097);
        if (o instanceof Integer) {
            result = (Integer)o;
        }
        return result;
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("invalid receive size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4098, new Integer(size));
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int result = 0;
        Object o = this.getImpl().getOption(4098);
        if (o instanceof Integer) {
            result = (Integer)o;
        }
        return result;
    }

    public synchronized void setReuseAddress(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.oldImpl) {
            this.getImpl().setOption(4, new Integer(on ? -1 : 0));
        } else {
            this.getImpl().setOption(4, (Object)on);
        }
    }

    public synchronized boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object o = this.getImpl().getOption(4);
        return (Boolean)o;
    }

    public synchronized void setBroadcast(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(32, (Object)on);
    }

    public synchronized boolean getBroadcast() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(32);
    }

    public synchronized void setTrafficClass(int tc) throws SocketException {
        block4: {
            if (tc < 0 || tc > 255) {
                throw new IllegalArgumentException("tc is not in range 0 -- 255");
            }
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            try {
                this.getImpl().setOption(3, (Object)tc);
            }
            catch (SocketException se) {
                if (this.isConnected()) break block4;
                throw se;
            }
        }
    }

    public synchronized int getTrafficClass() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Integer)this.getImpl().getOption(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            this.impl.close();
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed;
        }
    }

    public DatagramChannel getChannel() {
        return null;
    }

    public static synchronized void setDatagramSocketImplFactory(DatagramSocketImplFactory fac) throws IOException {
        if (factory != null) {
            throw new SocketException("factory already defined");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        factory = fac;
    }
}

