/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools.policytool;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.security.InvalidParameterException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import sun.security.provider.PolicyParser;
import sun.security.tools.policytool.AWTPerm;
import sun.security.tools.policytool.AddEntryDoneButtonListener;
import sun.security.tools.policytool.AddPermButtonListener;
import sun.security.tools.policytool.AddPrinButtonListener;
import sun.security.tools.policytool.AllPerm;
import sun.security.tools.policytool.AudioPerm;
import sun.security.tools.policytool.AuthPerm;
import sun.security.tools.policytool.CancelButtonListener;
import sun.security.tools.policytool.ChangeKeyStoreOKButtonListener;
import sun.security.tools.policytool.ChildWindowListener;
import sun.security.tools.policytool.ConfirmRemovePolicyEntryOKButtonListener;
import sun.security.tools.policytool.DelegationPerm;
import sun.security.tools.policytool.EditPermButtonListener;
import sun.security.tools.policytool.EditPrinButtonListener;
import sun.security.tools.policytool.FilePerm;
import sun.security.tools.policytool.InqSecContextPerm;
import sun.security.tools.policytool.KrbPrin;
import sun.security.tools.policytool.LogPerm;
import sun.security.tools.policytool.MBeanPerm;
import sun.security.tools.policytool.MBeanSvrPerm;
import sun.security.tools.policytool.MBeanTrustPerm;
import sun.security.tools.policytool.MgmtPerm;
import sun.security.tools.policytool.NetPerm;
import sun.security.tools.policytool.NewPolicyPermOKButtonListener;
import sun.security.tools.policytool.NewPolicyPrinOKButtonListener;
import sun.security.tools.policytool.NoDisplayException;
import sun.security.tools.policytool.Perm;
import sun.security.tools.policytool.PermissionActionsMenuListener;
import sun.security.tools.policytool.PermissionMenuListener;
import sun.security.tools.policytool.PermissionNameMenuListener;
import sun.security.tools.policytool.PolicyEntry;
import sun.security.tools.policytool.PolicyListListener;
import sun.security.tools.policytool.PolicyTool;
import sun.security.tools.policytool.Prin;
import sun.security.tools.policytool.PrincipalTypeMenuListener;
import sun.security.tools.policytool.PrivCredPerm;
import sun.security.tools.policytool.PropPerm;
import sun.security.tools.policytool.ReflectPerm;
import sun.security.tools.policytool.RemovePermButtonListener;
import sun.security.tools.policytool.RemovePrinButtonListener;
import sun.security.tools.policytool.RuntimePerm;
import sun.security.tools.policytool.SQLPerm;
import sun.security.tools.policytool.SSLPerm;
import sun.security.tools.policytool.SecurityPerm;
import sun.security.tools.policytool.SerialPerm;
import sun.security.tools.policytool.ServicePerm;
import sun.security.tools.policytool.SocketPerm;
import sun.security.tools.policytool.SubjDelegPerm;
import sun.security.tools.policytool.TaggedList;
import sun.security.tools.policytool.ToolWindow;
import sun.security.tools.policytool.URLPerm;
import sun.security.tools.policytool.UserSaveNoButtonListener;
import sun.security.tools.policytool.UserSaveYesButtonListener;
import sun.security.tools.policytool.X500Prin;

class ToolDialog
extends JDialog {
    private static final long serialVersionUID = -372244357011301190L;
    static final KeyStroke escKey = KeyStroke.getKeyStroke(27, 0);
    public static final int NOACTION = 0;
    public static final int QUIT = 1;
    public static final int NEW = 2;
    public static final int OPEN = 3;
    public static final String ALL_PERM_CLASS = "java.security.AllPermission";
    public static final String FILE_PERM_CLASS = "java.io.FilePermission";
    public static final String X500_PRIN_CLASS = "javax.security.auth.x500.X500Principal";
    public static final String PERM = PolicyTool.getMessage("Permission.");
    public static final String PRIN_TYPE = PolicyTool.getMessage("Principal.Type.");
    public static final String PRIN_NAME = PolicyTool.getMessage("Principal.Name.");
    public static final String PERM_NAME = PolicyTool.getMessage("Target.Name.");
    public static final String PERM_ACTIONS = PolicyTool.getMessage("Actions.");
    public static final int PE_CODEBASE_LABEL = 0;
    public static final int PE_CODEBASE_TEXTFIELD = 1;
    public static final int PE_SIGNEDBY_LABEL = 2;
    public static final int PE_SIGNEDBY_TEXTFIELD = 3;
    public static final int PE_PANEL0 = 4;
    public static final int PE_ADD_PRIN_BUTTON = 0;
    public static final int PE_EDIT_PRIN_BUTTON = 1;
    public static final int PE_REMOVE_PRIN_BUTTON = 2;
    public static final int PE_PRIN_LABEL = 5;
    public static final int PE_PRIN_LIST = 6;
    public static final int PE_PANEL1 = 7;
    public static final int PE_ADD_PERM_BUTTON = 0;
    public static final int PE_EDIT_PERM_BUTTON = 1;
    public static final int PE_REMOVE_PERM_BUTTON = 2;
    public static final int PE_PERM_LIST = 8;
    public static final int PE_PANEL2 = 9;
    public static final int PE_CANCEL_BUTTON = 1;
    public static final int PE_DONE_BUTTON = 0;
    public static final int PRD_DESC_LABEL = 0;
    public static final int PRD_PRIN_CHOICE = 1;
    public static final int PRD_PRIN_TEXTFIELD = 2;
    public static final int PRD_NAME_LABEL = 3;
    public static final int PRD_NAME_TEXTFIELD = 4;
    public static final int PRD_CANCEL_BUTTON = 6;
    public static final int PRD_OK_BUTTON = 5;
    public static final int PD_DESC_LABEL = 0;
    public static final int PD_PERM_CHOICE = 1;
    public static final int PD_PERM_TEXTFIELD = 2;
    public static final int PD_NAME_CHOICE = 3;
    public static final int PD_NAME_TEXTFIELD = 4;
    public static final int PD_ACTIONS_CHOICE = 5;
    public static final int PD_ACTIONS_TEXTFIELD = 6;
    public static final int PD_SIGNEDBY_LABEL = 7;
    public static final int PD_SIGNEDBY_TEXTFIELD = 8;
    public static final int PD_CANCEL_BUTTON = 10;
    public static final int PD_OK_BUTTON = 9;
    public static final int EDIT_KEYSTORE = 0;
    public static final int KSD_NAME_LABEL = 0;
    public static final int KSD_NAME_TEXTFIELD = 1;
    public static final int KSD_TYPE_LABEL = 2;
    public static final int KSD_TYPE_TEXTFIELD = 3;
    public static final int KSD_PROVIDER_LABEL = 4;
    public static final int KSD_PROVIDER_TEXTFIELD = 5;
    public static final int KSD_PWD_URL_LABEL = 6;
    public static final int KSD_PWD_URL_TEXTFIELD = 7;
    public static final int KSD_CANCEL_BUTTON = 9;
    public static final int KSD_OK_BUTTON = 8;
    public static final int USC_LABEL = 0;
    public static final int USC_PANEL = 1;
    public static final int USC_YES_BUTTON = 0;
    public static final int USC_NO_BUTTON = 1;
    public static final int USC_CANCEL_BUTTON = 2;
    public static final int CRPE_LABEL1 = 0;
    public static final int CRPE_LABEL2 = 1;
    public static final int CRPE_PANEL = 2;
    public static final int CRPE_PANEL_OK = 0;
    public static final int CRPE_PANEL_CANCEL = 1;
    private static final int PERMISSION = 0;
    private static final int PERMISSION_NAME = 1;
    private static final int PERMISSION_ACTIONS = 2;
    private static final int PERMISSION_SIGNEDBY = 3;
    private static final int PRINCIPAL_TYPE = 4;
    private static final int PRINCIPAL_NAME = 5;
    static final int TEXTFIELD_HEIGHT = new JComboBox<E>().getPreferredSize().height;
    public static ArrayList<Perm> PERM_ARRAY = new ArrayList();
    public static ArrayList<Prin> PRIN_ARRAY;
    PolicyTool tool;
    ToolWindow tw;

    ToolDialog(String title, PolicyTool tool, ToolWindow tw, boolean modal) {
        super((Frame)tw, modal);
        this.setTitle(title);
        this.tool = tool;
        this.tw = tw;
        this.addWindowListener(new ChildWindowListener(this));
        ((JPanel)this.getContentPane()).setBorder(new EmptyBorder(6, 6, 6, 6));
    }

    @Override
    public Component getComponent(int n) {
        Component c = this.getContentPane().getComponent(n);
        if (c instanceof JScrollPane) {
            c = ((JScrollPane)c).getViewport().getView();
        }
        return c;
    }

    static Perm getPerm(String clazz, boolean fullClassName) {
        for (int i = 0; i < PERM_ARRAY.size(); ++i) {
            Perm next = PERM_ARRAY.get(i);
            if (!(fullClassName ? next.FULL_CLASS.equals(clazz) : next.CLASS.equals(clazz))) continue;
            return next;
        }
        return null;
    }

    static Prin getPrin(String clazz, boolean fullClassName) {
        for (int i = 0; i < PRIN_ARRAY.size(); ++i) {
            Prin next = PRIN_ARRAY.get(i);
            if (!(fullClassName ? next.FULL_CLASS.equals(clazz) : next.CLASS.equals(clazz))) continue;
            return next;
        }
        return null;
    }

    void displayPolicyEntryDialog(boolean edit) {
        int listIndex = 0;
        PolicyEntry[] entries = null;
        TaggedList prinList = new TaggedList(3, false);
        prinList.getAccessibleContext().setAccessibleName(PolicyTool.getMessage("Principal.List"));
        prinList.addMouseListener(new EditPrinButtonListener(this.tool, this.tw, this, edit));
        TaggedList permList = new TaggedList(10, false);
        permList.getAccessibleContext().setAccessibleName(PolicyTool.getMessage("Permission.List"));
        permList.addMouseListener(new EditPermButtonListener(this.tool, this.tw, this, edit));
        Point location = this.tw.getLocationOnScreen();
        this.setLayout(new GridBagLayout());
        this.setResizable(true);
        if (edit) {
            entries = this.tool.getEntry();
            JList policyList = (JList)this.tw.getComponent(3);
            listIndex = policyList.getSelectedIndex();
            LinkedList<PolicyParser.PrincipalEntry> principals = entries[listIndex].getGrantEntry().principals;
            for (int i = 0; i < principals.size(); ++i) {
                Object prinString = null;
                PolicyParser.PrincipalEntry nextPrin = principals.get(i);
                prinList.addTaggedItem(ToolDialog.PrincipalEntryToUserFriendlyString(nextPrin), nextPrin);
            }
            Vector<PolicyParser.PermissionEntry> permissions = entries[listIndex].getGrantEntry().permissionEntries;
            for (int i = 0; i < permissions.size(); ++i) {
                Object permString = null;
                PolicyParser.PermissionEntry nextPerm = permissions.elementAt(i);
                permList.addTaggedItem(ToolDialog.PermissionEntryToUserFriendlyString(nextPerm), nextPerm);
            }
        }
        JLabel label = new JLabel();
        this.tw.addNewComponent(this, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.R_PADDING);
        JTextField tf = edit ? new JTextField(entries[listIndex].getGrantEntry().codeBase) : new JTextField();
        ToolWindow.configureLabelFor(label, tf, "CodeBase.");
        tf.setPreferredSize(new Dimension(tf.getPreferredSize().width, TEXTFIELD_HEIGHT));
        tf.getAccessibleContext().setAccessibleName(PolicyTool.getMessage("Code.Base"));
        this.tw.addNewComponent(this, tf, 1, 1, 0, 1, 1, 1.0, 0.0, 1);
        label = new JLabel();
        this.tw.addNewComponent(this, label, 2, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.R_PADDING);
        tf = edit ? new JTextField(entries[listIndex].getGrantEntry().signedBy) : new JTextField();
        ToolWindow.configureLabelFor(label, tf, "SignedBy.");
        tf.setPreferredSize(new Dimension(tf.getPreferredSize().width, TEXTFIELD_HEIGHT));
        tf.getAccessibleContext().setAccessibleName(PolicyTool.getMessage("Signed.By."));
        this.tw.addNewComponent(this, tf, 3, 1, 1, 1, 1, 1.0, 0.0, 1);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JButton button = new JButton();
        ToolWindow.configureButton(button, "Add.Principal");
        button.addActionListener(new AddPrinButtonListener(this.tool, this.tw, this, edit));
        this.tw.addNewComponent(panel, button, 0, 0, 0, 1, 1, 100.0, 0.0, 2);
        button = new JButton();
        ToolWindow.configureButton(button, "Edit.Principal");
        button.addActionListener(new EditPrinButtonListener(this.tool, this.tw, this, edit));
        this.tw.addNewComponent(panel, button, 1, 1, 0, 1, 1, 100.0, 0.0, 2);
        button = new JButton();
        ToolWindow.configureButton(button, "Remove.Principal");
        button.addActionListener(new RemovePrinButtonListener(this.tool, this.tw, this, edit));
        this.tw.addNewComponent(panel, button, 2, 2, 0, 1, 1, 100.0, 0.0, 2);
        this.tw.addNewComponent(this, panel, 4, 1, 2, 1, 1, 0.0, 0.0, 2, ToolWindow.LITE_BOTTOM_PADDING);
        label = new JLabel();
        this.tw.addNewComponent(this, label, 5, 0, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.R_BOTTOM_PADDING);
        JScrollPane scrollPane = new JScrollPane(prinList);
        ToolWindow.configureLabelFor(label, scrollPane, "Principals.");
        this.tw.addNewComponent(this, scrollPane, 6, 1, 3, 3, 1, 0.0, prinList.getVisibleRowCount(), 1, ToolWindow.BOTTOM_PADDING);
        panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        button = new JButton();
        ToolWindow.configureButton(button, ".Add.Permission");
        button.addActionListener(new AddPermButtonListener(this.tool, this.tw, this, edit));
        this.tw.addNewComponent(panel, button, 0, 0, 0, 1, 1, 100.0, 0.0, 2);
        button = new JButton();
        ToolWindow.configureButton(button, ".Edit.Permission");
        button.addActionListener(new EditPermButtonListener(this.tool, this.tw, this, edit));
        this.tw.addNewComponent(panel, button, 1, 1, 0, 1, 1, 100.0, 0.0, 2);
        button = new JButton();
        ToolWindow.configureButton(button, "Remove.Permission");
        button.addActionListener(new RemovePermButtonListener(this.tool, this.tw, this, edit));
        this.tw.addNewComponent(panel, button, 2, 2, 0, 1, 1, 100.0, 0.0, 2);
        this.tw.addNewComponent(this, panel, 7, 0, 4, 2, 1, 0.0, 0.0, 2, ToolWindow.LITE_BOTTOM_PADDING);
        scrollPane = new JScrollPane(permList);
        this.tw.addNewComponent(this, scrollPane, 8, 0, 5, 3, 1, 0.0, permList.getVisibleRowCount(), 1, ToolWindow.BOTTOM_PADDING);
        panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JButton okButton = new JButton(PolicyTool.getMessage("Done"));
        okButton.addActionListener(new AddEntryDoneButtonListener(this.tool, this.tw, this, edit));
        this.tw.addNewComponent(panel, okButton, 0, 0, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        JButton cancelButton = new JButton(PolicyTool.getMessage("Cancel"));
        CancelButtonListener cancelListener = new CancelButtonListener(this);
        cancelButton.addActionListener(cancelListener);
        this.tw.addNewComponent(panel, cancelButton, 1, 1, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(this, panel, 9, 0, 6, 2, 1, 0.0, 0.0, 3);
        this.getRootPane().setDefaultButton(okButton);
        this.getRootPane().registerKeyboardAction(cancelListener, escKey, 2);
        this.pack();
        this.setLocationRelativeTo(this.tw);
        this.setVisible(true);
    }

    PolicyEntry getPolicyEntryFromDialog() throws InvalidParameterException, MalformedURLException, NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, CertificateException, IOException, Exception {
        JTextField tf = (JTextField)this.getComponent(1);
        String codebase = null;
        if (!tf.getText().trim().equals("")) {
            codebase = new String(tf.getText().trim());
        }
        tf = (JTextField)this.getComponent(3);
        String signedby = null;
        if (!tf.getText().trim().equals("")) {
            signedby = new String(tf.getText().trim());
        }
        PolicyParser.GrantEntry ge = new PolicyParser.GrantEntry(signedby, codebase);
        LinkedList<PolicyParser.PrincipalEntry> prins = new LinkedList<PolicyParser.PrincipalEntry>();
        TaggedList prinList = (TaggedList)this.getComponent(6);
        for (int i = 0; i < prinList.getModel().getSize(); ++i) {
            prins.add((PolicyParser.PrincipalEntry)prinList.getObject(i));
        }
        ge.principals = prins;
        Vector<PolicyParser.PermissionEntry> perms = new Vector<PolicyParser.PermissionEntry>();
        TaggedList permList = (TaggedList)this.getComponent(8);
        for (int i = 0; i < permList.getModel().getSize(); ++i) {
            perms.addElement((PolicyParser.PermissionEntry)permList.getObject(i));
        }
        ge.permissionEntries = perms;
        PolicyEntry entry = new PolicyEntry(this.tool, ge);
        return entry;
    }

    void keyStoreDialog(int mode) {
        Point location = this.tw.getLocationOnScreen();
        this.setLayout(new GridBagLayout());
        if (mode == 0) {
            JLabel label = new JLabel();
            this.tw.addNewComponent(this, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.R_BOTTOM_PADDING);
            JTextField tf = new JTextField(this.tool.getKeyStoreName(), 30);
            ToolWindow.configureLabelFor(label, tf, "KeyStore.URL.");
            tf.setPreferredSize(new Dimension(tf.getPreferredSize().width, TEXTFIELD_HEIGHT));
            tf.getAccessibleContext().setAccessibleName(PolicyTool.getMessage("KeyStore.U.R.L."));
            this.tw.addNewComponent(this, tf, 1, 1, 0, 1, 1, 1.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            label = new JLabel();
            this.tw.addNewComponent(this, label, 2, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.R_BOTTOM_PADDING);
            tf = new JTextField(this.tool.getKeyStoreType(), 30);
            ToolWindow.configureLabelFor(label, tf, "KeyStore.Type.");
            tf.setPreferredSize(new Dimension(tf.getPreferredSize().width, TEXTFIELD_HEIGHT));
            tf.getAccessibleContext().setAccessibleName(PolicyTool.getMessage("KeyStore.Type."));
            this.tw.addNewComponent(this, tf, 3, 1, 1, 1, 1, 1.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            label = new JLabel();
            this.tw.addNewComponent(this, label, 4, 0, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.R_BOTTOM_PADDING);
            tf = new JTextField(this.tool.getKeyStoreProvider(), 30);
            ToolWindow.configureLabelFor(label, tf, "KeyStore.Provider.");
            tf.setPreferredSize(new Dimension(tf.getPreferredSize().width, TEXTFIELD_HEIGHT));
            tf.getAccessibleContext().setAccessibleName(PolicyTool.getMessage("KeyStore.Provider."));
            this.tw.addNewComponent(this, tf, 5, 1, 2, 1, 1, 1.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            label = new JLabel();
            this.tw.addNewComponent(this, label, 6, 0, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.R_BOTTOM_PADDING);
            tf = new JTextField(this.tool.getKeyStorePwdURL(), 30);
            ToolWindow.configureLabelFor(label, tf, "KeyStore.Password.URL.");
            tf.setPreferredSize(new Dimension(tf.getPreferredSize().width, TEXTFIELD_HEIGHT));
            tf.getAccessibleContext().setAccessibleName(PolicyTool.getMessage("KeyStore.Password.U.R.L."));
            this.tw.addNewComponent(this, tf, 7, 1, 3, 1, 1, 1.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            JButton okButton = new JButton(PolicyTool.getMessage("OK"));
            okButton.addActionListener(new ChangeKeyStoreOKButtonListener(this.tool, this.tw, this));
            this.tw.addNewComponent(this, okButton, 8, 0, 4, 1, 1, 0.0, 0.0, 3);
            JButton cancelButton = new JButton(PolicyTool.getMessage("Cancel"));
            CancelButtonListener cancelListener = new CancelButtonListener(this);
            cancelButton.addActionListener(cancelListener);
            this.tw.addNewComponent(this, cancelButton, 9, 1, 4, 1, 1, 0.0, 0.0, 3);
            this.getRootPane().setDefaultButton(okButton);
            this.getRootPane().registerKeyboardAction(cancelListener, escKey, 2);
        }
        this.pack();
        this.setLocationRelativeTo(this.tw);
        this.setVisible(true);
    }

    void displayPrincipalDialog(boolean editPolicyEntry, boolean edit) {
        PolicyParser.PrincipalEntry editMe = null;
        TaggedList prinList = (TaggedList)this.getComponent(6);
        int prinIndex = prinList.getSelectedIndex();
        if (edit) {
            editMe = (PolicyParser.PrincipalEntry)prinList.getObject(prinIndex);
        }
        ToolDialog newTD = new ToolDialog(PolicyTool.getMessage("Principals"), this.tool, this.tw, true);
        newTD.addWindowListener(new ChildWindowListener(newTD));
        Point location = this.getLocationOnScreen();
        newTD.setLayout(new GridBagLayout());
        newTD.setResizable(true);
        JLabel label = edit ? new JLabel(PolicyTool.getMessage(".Edit.Principal.")) : new JLabel(PolicyTool.getMessage(".Add.New.Principal."));
        this.tw.addNewComponent(newTD, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.TOP_BOTTOM_PADDING);
        JComboBox<String> choice = new JComboBox<String>();
        choice.addItem(PRIN_TYPE);
        choice.getAccessibleContext().setAccessibleName(PRIN_TYPE);
        for (int i = 0; i < PRIN_ARRAY.size(); ++i) {
            Prin next = PRIN_ARRAY.get(i);
            choice.addItem(next.CLASS);
        }
        if (edit) {
            if ("WILDCARD_PRINCIPAL_CLASS".equals(editMe.getPrincipalClass())) {
                choice.setSelectedItem(PRIN_TYPE);
            } else {
                Prin inputPrin = ToolDialog.getPrin(editMe.getPrincipalClass(), true);
                if (inputPrin != null) {
                    choice.setSelectedItem(inputPrin.CLASS);
                }
            }
        }
        choice.addItemListener(new PrincipalTypeMenuListener(newTD));
        this.tw.addNewComponent(newTD, choice, 1, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        JTextField tf = edit ? new JTextField(editMe.getDisplayClass(), 30) : new JTextField(30);
        tf.setPreferredSize(new Dimension(tf.getPreferredSize().width, TEXTFIELD_HEIGHT));
        tf.getAccessibleContext().setAccessibleName(PRIN_TYPE);
        this.tw.addNewComponent(newTD, tf, 2, 1, 1, 1, 1, 1.0, 0.0, 1, ToolWindow.LR_PADDING);
        label = new JLabel(PRIN_NAME);
        tf = edit ? new JTextField(editMe.getDisplayName(), 40) : new JTextField(40);
        tf.setPreferredSize(new Dimension(tf.getPreferredSize().width, TEXTFIELD_HEIGHT));
        tf.getAccessibleContext().setAccessibleName(PRIN_NAME);
        this.tw.addNewComponent(newTD, label, 3, 0, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(newTD, tf, 4, 1, 2, 1, 1, 1.0, 0.0, 1, ToolWindow.LR_PADDING);
        JButton okButton = new JButton(PolicyTool.getMessage("OK"));
        okButton.addActionListener(new NewPolicyPrinOKButtonListener(this.tool, this.tw, this, newTD, edit));
        this.tw.addNewComponent(newTD, okButton, 5, 0, 3, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        JButton cancelButton = new JButton(PolicyTool.getMessage("Cancel"));
        CancelButtonListener cancelListener = new CancelButtonListener(newTD);
        cancelButton.addActionListener(cancelListener);
        this.tw.addNewComponent(newTD, cancelButton, 6, 1, 3, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        newTD.getRootPane().setDefaultButton(okButton);
        newTD.getRootPane().registerKeyboardAction(cancelListener, escKey, 2);
        newTD.pack();
        newTD.setLocationRelativeTo(this.tw);
        newTD.setVisible(true);
    }

    void displayPermissionDialog(boolean editPolicyEntry, boolean edit) {
        Perm inputPerm;
        PolicyParser.PermissionEntry editMe = null;
        TaggedList permList = (TaggedList)this.getComponent(8);
        int permIndex = permList.getSelectedIndex();
        if (edit) {
            editMe = (PolicyParser.PermissionEntry)permList.getObject(permIndex);
        }
        ToolDialog newTD = new ToolDialog(PolicyTool.getMessage("Permissions"), this.tool, this.tw, true);
        newTD.addWindowListener(new ChildWindowListener(newTD));
        Point location = this.getLocationOnScreen();
        newTD.setLayout(new GridBagLayout());
        newTD.setResizable(true);
        JLabel label = edit ? new JLabel(PolicyTool.getMessage(".Edit.Permission.")) : new JLabel(PolicyTool.getMessage(".Add.New.Permission."));
        this.tw.addNewComponent(newTD, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.TOP_BOTTOM_PADDING);
        JComboBox<String> choice = new JComboBox<String>();
        choice.addItem(PERM);
        choice.getAccessibleContext().setAccessibleName(PERM);
        for (int i = 0; i < PERM_ARRAY.size(); ++i) {
            Perm next = PERM_ARRAY.get(i);
            choice.addItem(next.CLASS);
        }
        this.tw.addNewComponent(newTD, choice, 1, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_BOTTOM_PADDING);
        JTextField tf = edit ? new JTextField(editMe.permission, 30) : new JTextField(30);
        tf.setPreferredSize(new Dimension(tf.getPreferredSize().width, TEXTFIELD_HEIGHT));
        tf.getAccessibleContext().setAccessibleName(PERM);
        if (edit && (inputPerm = ToolDialog.getPerm(editMe.permission, true)) != null) {
            choice.setSelectedItem(inputPerm.CLASS);
        }
        this.tw.addNewComponent(newTD, tf, 2, 1, 1, 1, 1, 1.0, 0.0, 1, ToolWindow.LR_BOTTOM_PADDING);
        choice.addItemListener(new PermissionMenuListener(newTD));
        choice = new JComboBox();
        choice.addItem(PERM_NAME);
        choice.getAccessibleContext().setAccessibleName(PERM_NAME);
        tf = edit ? new JTextField(editMe.name, 40) : new JTextField(40);
        tf.setPreferredSize(new Dimension(tf.getPreferredSize().width, TEXTFIELD_HEIGHT));
        tf.getAccessibleContext().setAccessibleName(PERM_NAME);
        if (edit) {
            this.setPermissionNames(ToolDialog.getPerm(editMe.permission, true), choice, tf);
        }
        this.tw.addNewComponent(newTD, choice, 3, 0, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_BOTTOM_PADDING);
        this.tw.addNewComponent(newTD, tf, 4, 1, 2, 1, 1, 1.0, 0.0, 1, ToolWindow.LR_BOTTOM_PADDING);
        choice.addItemListener(new PermissionNameMenuListener(newTD));
        choice = new JComboBox();
        choice.addItem(PERM_ACTIONS);
        choice.getAccessibleContext().setAccessibleName(PERM_ACTIONS);
        tf = edit ? new JTextField(editMe.action, 40) : new JTextField(40);
        tf.setPreferredSize(new Dimension(tf.getPreferredSize().width, TEXTFIELD_HEIGHT));
        tf.getAccessibleContext().setAccessibleName(PERM_ACTIONS);
        if (edit) {
            this.setPermissionActions(ToolDialog.getPerm(editMe.permission, true), choice, tf);
        }
        this.tw.addNewComponent(newTD, choice, 5, 0, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_BOTTOM_PADDING);
        this.tw.addNewComponent(newTD, tf, 6, 1, 3, 1, 1, 1.0, 0.0, 1, ToolWindow.LR_BOTTOM_PADDING);
        choice.addItemListener(new PermissionActionsMenuListener(newTD));
        label = new JLabel(PolicyTool.getMessage("Signed.By."));
        this.tw.addNewComponent(newTD, label, 7, 0, 4, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_BOTTOM_PADDING);
        tf = edit ? new JTextField(editMe.signedBy, 40) : new JTextField(40);
        tf.setPreferredSize(new Dimension(tf.getPreferredSize().width, TEXTFIELD_HEIGHT));
        tf.getAccessibleContext().setAccessibleName(PolicyTool.getMessage("Signed.By."));
        this.tw.addNewComponent(newTD, tf, 8, 1, 4, 1, 1, 1.0, 0.0, 1, ToolWindow.LR_BOTTOM_PADDING);
        JButton okButton = new JButton(PolicyTool.getMessage("OK"));
        okButton.addActionListener(new NewPolicyPermOKButtonListener(this.tool, this.tw, this, newTD, edit));
        this.tw.addNewComponent(newTD, okButton, 9, 0, 5, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        JButton cancelButton = new JButton(PolicyTool.getMessage("Cancel"));
        CancelButtonListener cancelListener = new CancelButtonListener(newTD);
        cancelButton.addActionListener(cancelListener);
        this.tw.addNewComponent(newTD, cancelButton, 10, 1, 5, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        newTD.getRootPane().setDefaultButton(okButton);
        newTD.getRootPane().registerKeyboardAction(cancelListener, escKey, 2);
        newTD.pack();
        newTD.setLocationRelativeTo(this.tw);
        newTD.setVisible(true);
    }

    PolicyParser.PrincipalEntry getPrinFromDialog() throws Exception {
        JTextField tf = (JTextField)this.getComponent(2);
        String pclass = new String(tf.getText().trim());
        tf = (JTextField)this.getComponent(4);
        String pname = new String(tf.getText().trim());
        if (pclass.equals("*")) {
            pclass = "WILDCARD_PRINCIPAL_CLASS";
        }
        if (pname.equals("*")) {
            pname = "WILDCARD_PRINCIPAL_NAME";
        }
        Object pppe = null;
        if (pclass.equals("WILDCARD_PRINCIPAL_CLASS") && !pname.equals("WILDCARD_PRINCIPAL_NAME")) {
            throw new Exception(PolicyTool.getMessage("Cannot.Specify.Principal.with.a.Wildcard.Class.without.a.Wildcard.Name"));
        }
        if (pname.equals("")) {
            throw new Exception(PolicyTool.getMessage("Cannot.Specify.Principal.without.a.Name"));
        }
        if (pclass.equals("")) {
            pclass = "PolicyParser.REPLACE_NAME";
            this.tool.warnings.addElement("Warning: Principal name '" + pname + "' specified without a Principal class.\n\t'" + pname + "' will be interpreted as a key store alias.\n\tThe final principal class will be " + X500_PRIN_CLASS + ".\n\tThe final principal name will be determined by the following:\n\n\tIf the key store entry identified by '" + pname + "'\n\tis a key entry, then the principal name will be\n\tthe subject distinguished name from the first\n\tcertificate in the entry's certificate chain.\n\n\tIf the key store entry identified by '" + pname + "'\n\tis a trusted certificate entry, then the\n\tprincipal name will be the subject distinguished\n\tname from the trusted public key certificate.");
            this.tw.displayStatusDialog(this, "'" + pname + "' will be interpreted as a key store alias.  View Warning Log for details.");
        }
        return new PolicyParser.PrincipalEntry(pclass, pname);
    }

    PolicyParser.PermissionEntry getPermFromDialog() {
        char result;
        JTextField tf = (JTextField)this.getComponent(2);
        String permission = new String(tf.getText().trim());
        tf = (JTextField)this.getComponent(4);
        String name = null;
        if (!tf.getText().trim().equals("")) {
            name = new String(tf.getText().trim());
        }
        if (permission.equals("") || !permission.equals(ALL_PERM_CLASS) && name == null) {
            throw new InvalidParameterException(PolicyTool.getMessage("Permission.and.Target.Name.must.have.a.value"));
        }
        if (permission.equals(FILE_PERM_CLASS) && name.lastIndexOf("\\\\") > 0 && (result = this.tw.displayYesNoDialog(this, PolicyTool.getMessage("Warning"), PolicyTool.getMessage("Warning.File.name.may.include.escaped.backslash.characters.It.is.not.necessary.to.escape.backslash.characters.the.tool.escapes"), PolicyTool.getMessage("Retain"), PolicyTool.getMessage("Edit"))) != 'Y') {
            throw new NoDisplayException();
        }
        tf = (JTextField)this.getComponent(6);
        String actions2 = null;
        if (!tf.getText().trim().equals("")) {
            actions2 = new String(tf.getText().trim());
        }
        tf = (JTextField)this.getComponent(8);
        String signedBy = null;
        if (!tf.getText().trim().equals("")) {
            signedBy = new String(tf.getText().trim());
        }
        PolicyParser.PermissionEntry pppe = new PolicyParser.PermissionEntry(permission, name, actions2);
        pppe.signedBy = signedBy;
        if (signedBy != null) {
            String[] signers = this.tool.parseSigners(pppe.signedBy);
            for (int i = 0; i < signers.length; ++i) {
                try {
                    PublicKey pubKey = this.tool.getPublicKeyAlias(signers[i]);
                    if (pubKey != null) continue;
                    MessageFormat form = new MessageFormat(PolicyTool.getMessage("Warning.A.public.key.for.alias.signers.i.does.not.exist.Make.sure.a.KeyStore.is.properly.configured."));
                    Object[] source = new Object[]{signers[i]};
                    this.tool.warnings.addElement(form.format(source));
                    this.tw.displayStatusDialog(this, form.format(source));
                    continue;
                }
                catch (Exception e) {
                    this.tw.displayErrorDialog((Window)this, e);
                }
            }
        }
        return pppe;
    }

    void displayConfirmRemovePolicyEntry() {
        JList list = (JList)this.tw.getComponent(3);
        int index = list.getSelectedIndex();
        PolicyEntry[] entries = this.tool.getEntry();
        Point location = this.tw.getLocationOnScreen();
        this.setLayout(new GridBagLayout());
        JLabel label = new JLabel(PolicyTool.getMessage("Remove.this.Policy.Entry."));
        this.tw.addNewComponent(this, label, 0, 0, 0, 2, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        label = new JLabel(entries[index].codebaseToString());
        this.tw.addNewComponent(this, label, 1, 0, 1, 2, 1, 0.0, 0.0, 1);
        label = new JLabel(entries[index].principalsToString().trim());
        this.tw.addNewComponent(this, label, 2, 0, 2, 2, 1, 0.0, 0.0, 1);
        Vector<PolicyParser.PermissionEntry> perms = entries[index].getGrantEntry().permissionEntries;
        for (int i = 0; i < perms.size(); ++i) {
            PolicyParser.PermissionEntry nextPerm = perms.elementAt(i);
            String permString = ToolDialog.PermissionEntryToUserFriendlyString(nextPerm);
            label = new JLabel("    " + permString);
            if (i == perms.size() - 1) {
                this.tw.addNewComponent(this, label, 3 + i, 1, 3 + i, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
                continue;
            }
            this.tw.addNewComponent(this, label, 3 + i, 1, 3 + i, 1, 1, 0.0, 0.0, 1);
        }
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JButton okButton = new JButton(PolicyTool.getMessage("OK"));
        okButton.addActionListener(new ConfirmRemovePolicyEntryOKButtonListener(this.tool, this.tw, this));
        this.tw.addNewComponent(panel, okButton, 0, 0, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        JButton cancelButton = new JButton(PolicyTool.getMessage("Cancel"));
        CancelButtonListener cancelListener = new CancelButtonListener(this);
        cancelButton.addActionListener(cancelListener);
        this.tw.addNewComponent(panel, cancelButton, 1, 1, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(this, panel, 3 + perms.size(), 0, 3 + perms.size(), 2, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        this.getRootPane().setDefaultButton(okButton);
        this.getRootPane().registerKeyboardAction(cancelListener, escKey, 2);
        this.pack();
        this.setLocationRelativeTo(this.tw);
        this.setVisible(true);
    }

    void displaySaveAsDialog(int nextEvent) {
        FileDialog fd = new FileDialog((Frame)this.tw, PolicyTool.getMessage("Save.As"), 1);
        fd.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                e.getWindow().setVisible(false);
            }
        });
        fd.setVisible(true);
        if (fd.getFile() == null || fd.getFile().equals("")) {
            return;
        }
        File saveAsFile = new File(fd.getDirectory(), fd.getFile());
        String filename = saveAsFile.getPath();
        fd.dispose();
        try {
            this.tool.savePolicy(filename);
            MessageFormat form = new MessageFormat(PolicyTool.getMessage("Policy.successfully.written.to.filename"));
            Object[] source = new Object[]{filename};
            this.tw.displayStatusDialog(null, form.format(source));
            JTextField newFilename = (JTextField)this.tw.getComponent(1);
            newFilename.setText(filename);
            this.tw.setVisible(true);
            this.userSaveContinue(this.tool, this.tw, this, nextEvent);
        }
        catch (FileNotFoundException fnfe) {
            if (filename == null || filename.equals("")) {
                this.tw.displayErrorDialog(null, new FileNotFoundException(PolicyTool.getMessage("null.filename")));
            } else {
                this.tw.displayErrorDialog(null, fnfe);
            }
        }
        catch (Exception ee) {
            this.tw.displayErrorDialog(null, ee);
        }
    }

    void displayUserSave(int select) {
        if (this.tool.modified) {
            Point location = this.tw.getLocationOnScreen();
            this.setLayout(new GridBagLayout());
            JLabel label = new JLabel(PolicyTool.getMessage("Save.changes."));
            this.tw.addNewComponent(this, label, 0, 0, 0, 3, 1, 0.0, 0.0, 1, ToolWindow.L_TOP_BOTTOM_PADDING);
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            JButton yesButton = new JButton();
            ToolWindow.configureButton(yesButton, "Yes");
            yesButton.addActionListener(new UserSaveYesButtonListener(this, this.tool, this.tw, select));
            this.tw.addNewComponent(panel, yesButton, 0, 0, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_BOTTOM_PADDING);
            JButton noButton = new JButton();
            ToolWindow.configureButton(noButton, "No");
            noButton.addActionListener(new UserSaveNoButtonListener(this, this.tool, this.tw, select));
            this.tw.addNewComponent(panel, noButton, 1, 1, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_BOTTOM_PADDING);
            JButton cancelButton = new JButton();
            ToolWindow.configureButton(cancelButton, "Cancel");
            CancelButtonListener cancelListener = new CancelButtonListener(this);
            cancelButton.addActionListener(cancelListener);
            this.tw.addNewComponent(panel, cancelButton, 2, 2, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_BOTTOM_PADDING);
            this.tw.addNewComponent(this, panel, 1, 0, 1, 1, 1, 0.0, 0.0, 1);
            this.getRootPane().registerKeyboardAction(cancelListener, escKey, 2);
            this.pack();
            this.setLocationRelativeTo(this.tw);
            this.setVisible(true);
        } else {
            this.userSaveContinue(this.tool, this.tw, this, select);
        }
    }

    void userSaveContinue(PolicyTool tool, ToolWindow tw, ToolDialog us, int select) {
        switch (select) {
            case 1: {
                tw.setVisible(false);
                tw.dispose();
                System.exit(0);
            }
            case 2: {
                try {
                    tool.openPolicy(null);
                }
                catch (Exception ee) {
                    tool.modified = false;
                    tw.displayErrorDialog(null, ee);
                }
                JList list = new JList(new DefaultListModel());
                list.setVisibleRowCount(15);
                list.setSelectionMode(0);
                list.addMouseListener(new PolicyListListener(tool, tw));
                tw.replacePolicyList(list);
                JTextField newFilename = (JTextField)tw.getComponent(1);
                newFilename.setText("");
                tw.setVisible(true);
                break;
            }
            case 3: {
                FileDialog fd = new FileDialog((Frame)tw, PolicyTool.getMessage("Open"), 0);
                fd.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        e.getWindow().setVisible(false);
                    }
                });
                fd.setVisible(true);
                if (fd.getFile() == null || fd.getFile().equals("")) {
                    return;
                }
                String policyFile = new File(fd.getDirectory(), fd.getFile()).getPath();
                try {
                    tool.openPolicy(policyFile);
                    DefaultListModel<String> listModel = new DefaultListModel<String>();
                    JList list = new JList(listModel);
                    list.setVisibleRowCount(15);
                    list.setSelectionMode(0);
                    list.addMouseListener(new PolicyListListener(tool, tw));
                    PolicyEntry[] entries = tool.getEntry();
                    if (entries != null) {
                        for (int i = 0; i < entries.length; ++i) {
                            listModel.addElement(entries[i].headerToString());
                        }
                    }
                    tw.replacePolicyList(list);
                    tool.modified = false;
                    JTextField newFilename = (JTextField)tw.getComponent(1);
                    newFilename.setText(policyFile);
                    tw.setVisible(true);
                    if (!tool.newWarning) break;
                    tw.displayStatusDialog(null, PolicyTool.getMessage("Errors.have.occurred.while.opening.the.policy.configuration.View.the.Warning.Log.for.more.information."));
                    break;
                }
                catch (Exception e) {
                    JList list = new JList(new DefaultListModel());
                    list.setVisibleRowCount(15);
                    list.setSelectionMode(0);
                    list.addMouseListener(new PolicyListListener(tool, tw));
                    tw.replacePolicyList(list);
                    tool.setPolicyFileName(null);
                    tool.modified = false;
                    JTextField newFilename = (JTextField)tw.getComponent(1);
                    newFilename.setText("");
                    tw.setVisible(true);
                    MessageFormat form = new MessageFormat(PolicyTool.getMessage("Could.not.open.policy.file.policyFile.e.toString."));
                    Object[] source = new Object[]{policyFile, e.toString()};
                    tw.displayErrorDialog(null, form.format(source));
                }
            }
        }
    }

    void setPermissionNames(Perm inputPerm, JComboBox names, JTextField field) {
        names.removeAllItems();
        names.addItem(PERM_NAME);
        if (inputPerm == null) {
            field.setEditable(true);
        } else if (inputPerm.TARGETS == null) {
            field.setEditable(false);
        } else {
            field.setEditable(true);
            for (int i = 0; i < inputPerm.TARGETS.length; ++i) {
                names.addItem(inputPerm.TARGETS[i]);
            }
        }
    }

    void setPermissionActions(Perm inputPerm, JComboBox actions2, JTextField field) {
        actions2.removeAllItems();
        actions2.addItem(PERM_ACTIONS);
        if (inputPerm == null) {
            field.setEditable(true);
        } else if (inputPerm.ACTIONS == null) {
            field.setEditable(false);
        } else {
            field.setEditable(true);
            for (int i = 0; i < inputPerm.ACTIONS.length; ++i) {
                actions2.addItem(inputPerm.ACTIONS[i]);
            }
        }
    }

    static String PermissionEntryToUserFriendlyString(PolicyParser.PermissionEntry pppe) {
        String result = pppe.permission;
        if (pppe.name != null) {
            result = result + " " + pppe.name;
        }
        if (pppe.action != null) {
            result = result + ", \"" + pppe.action + "\"";
        }
        if (pppe.signedBy != null) {
            result = result + ", signedBy " + pppe.signedBy;
        }
        return result;
    }

    static String PrincipalEntryToUserFriendlyString(PolicyParser.PrincipalEntry pppe) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pppe.write(pw);
        return sw.toString();
    }

    static {
        PERM_ARRAY.add(new AllPerm());
        PERM_ARRAY.add(new AudioPerm());
        PERM_ARRAY.add(new AuthPerm());
        PERM_ARRAY.add(new AWTPerm());
        PERM_ARRAY.add(new DelegationPerm());
        PERM_ARRAY.add(new FilePerm());
        PERM_ARRAY.add(new URLPerm());
        PERM_ARRAY.add(new InqSecContextPerm());
        PERM_ARRAY.add(new LogPerm());
        PERM_ARRAY.add(new MgmtPerm());
        PERM_ARRAY.add(new MBeanPerm());
        PERM_ARRAY.add(new MBeanSvrPerm());
        PERM_ARRAY.add(new MBeanTrustPerm());
        PERM_ARRAY.add(new NetPerm());
        PERM_ARRAY.add(new PrivCredPerm());
        PERM_ARRAY.add(new PropPerm());
        PERM_ARRAY.add(new ReflectPerm());
        PERM_ARRAY.add(new RuntimePerm());
        PERM_ARRAY.add(new SecurityPerm());
        PERM_ARRAY.add(new SerialPerm());
        PERM_ARRAY.add(new ServicePerm());
        PERM_ARRAY.add(new SocketPerm());
        PERM_ARRAY.add(new SQLPerm());
        PERM_ARRAY.add(new SSLPerm());
        PERM_ARRAY.add(new SubjDelegPerm());
        PRIN_ARRAY = new ArrayList();
        PRIN_ARRAY.add(new KrbPrin());
        PRIN_ARRAY.add(new X500Prin());
    }
}

