/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.trust;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.pkipath.PlainStoreUtils;
import eu.emi.security.authn.x509.helpers.trust.TimedTrustAnchorStoreBase;
import eu.emi.security.authn.x509.helpers.trust.TrustAnchorExt;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.CertificateEncodingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;

public class DirectoryTrustAnchorStore
extends TimedTrustAnchorStoreBase {
    private final PlainStoreUtils utils;
    private final int connTimeout;
    private final String cacheDir;
    protected Set<TrustAnchorExt> anchors;
    protected Map<URL, TrustAnchorExt> locations2anchors;
    protected CertificateUtils.Encoding encoding;

    public DirectoryTrustAnchorStore(List<String> locations, String diskCache, int connectionTimeout, Timer t, long updateInterval, CertificateUtils.Encoding encoding, ObserversHandler listeners) {
        this(locations, diskCache, connectionTimeout, t, updateInterval, encoding, listeners, false);
    }

    protected DirectoryTrustAnchorStore(List<String> locations, String diskCache, int connectionTimeout, Timer t, long updateInterval, CertificateUtils.Encoding encoding, ObserversHandler observers, boolean noFirstUpdate) {
        super(t, updateInterval, observers);
        this.utils = new PlainStoreUtils(diskCache, "-cacert", locations);
        if (connectionTimeout < 0) {
            throw new IllegalArgumentException("Remote connection timeout must be a non negative number");
        }
        this.connTimeout = connectionTimeout;
        this.cacheDir = diskCache;
        this.anchors = new HashSet<TrustAnchorExt>();
        this.locations2anchors = new HashMap<URL, TrustAnchorExt>();
        this.encoding = encoding;
        if (!noFirstUpdate) {
            this.update();
            this.scheduleUpdate();
        }
    }

    protected X509Certificate loadCert(URL url) throws IOException, URISyntaxException, CertificateEncodingException {
        X509Certificate ret;
        String protocol = url.getProtocol();
        boolean local = false;
        if (protocol.equalsIgnoreCase("file")) {
            local = true;
        }
        try {
            URLConnection conn = url.openConnection();
            if (!local) {
                conn.setConnectTimeout(this.connTimeout);
                conn.setReadTimeout(this.connTimeout);
            }
            BufferedInputStream is = new BufferedInputStream(conn.getInputStream());
            ret = CertificateUtils.loadCertificate(is, this.getEncoding());
            this.observers.notifyObservers(url.toExternalForm(), "CA Certificate", StoreUpdateListener.Severity.NOTIFICATION, null);
        }
        catch (IOException e) {
            if (!local && this.cacheDir != null) {
                File input = this.utils.getCacheFile(url);
                if (input.exists()) {
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(input));
                    X509Certificate ret2 = CertificateUtils.loadCertificate(is, this.getEncoding());
                    ((InputStream)is).close();
                    this.observers.notifyObservers(url.toExternalForm(), "CA Certificate", StoreUpdateListener.Severity.WARNING, new IOException("Warning: CA certificate was not loaded from its URL, but its previous cached copy was loaded from disk file " + input.getPath(), e));
                    return ret2;
                }
                throw e;
            }
            throw e;
        }
        if (!local) {
            this.utils.saveCacheFile(ret.getEncoded(), url);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadCerts(Collection<URL> locations) {
        HashSet<TrustAnchorExt> tmpAnchors = new HashSet<TrustAnchorExt>();
        HashMap<URL, TrustAnchorExt> tmpLoc2anch = new HashMap<URL, TrustAnchorExt>();
        for (URL location : locations) {
            X509Certificate cert;
            try {
                cert = this.loadCert(location);
            }
            catch (Exception e) {
                this.observers.notifyObservers(location.toExternalForm(), "CA Certificate", StoreUpdateListener.Severity.ERROR, e);
                continue;
            }
            this.checkValidity(location.toExternalForm(), cert, false);
            TrustAnchorExt anchor = new TrustAnchorExt(cert, null);
            tmpAnchors.add(anchor);
            tmpLoc2anch.put(location, anchor);
        }
        DirectoryTrustAnchorStore directoryTrustAnchorStore = this;
        synchronized (directoryTrustAnchorStore) {
            this.anchors.addAll(tmpAnchors);
            this.locations2anchors.putAll(tmpLoc2anch);
        }
    }

    private synchronized void removeStaleCas() {
        Iterator<Map.Entry<URL, TrustAnchorExt>> itMain = this.locations2anchors.entrySet().iterator();
        while (itMain.hasNext()) {
            Map.Entry<URL, TrustAnchorExt> entry = itMain.next();
            if (this.utils.isPresent(entry.getKey())) continue;
            this.anchors.remove(entry.getValue());
            itMain.remove();
        }
    }

    @Override
    protected void update() {
        this.utils.establishWildcardsLocations();
        this.removeStaleCas();
        ArrayList<URL> resolvedLocations = new ArrayList<URL>();
        resolvedLocations.addAll(this.utils.getURLLocations());
        resolvedLocations.addAll(this.utils.getResolvedWildcards());
        this.reloadCerts(resolvedLocations);
    }

    @Override
    public synchronized Set<TrustAnchor> getTrustAnchors() {
        HashSet<TrustAnchor> ret = new HashSet<TrustAnchor>();
        ret.addAll(this.anchors);
        return ret;
    }

    @Override
    public synchronized X509Certificate[] getTrustedCertificates() {
        X509Certificate[] ret = new X509Certificate[this.anchors.size()];
        int i = 0;
        for (TrustAnchor trustAnchor : this.anchors) {
            ret[i++] = trustAnchor.getTrustedCert();
        }
        return ret;
    }

    public List<String> getLocations() {
        return this.utils.getLocations();
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public String getCacheDir() {
        return this.cacheDir;
    }

    public CertificateUtils.Encoding getEncoding() {
        return this.encoding;
    }
}

