/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.pkipath;

import eu.emi.security.authn.x509.ProxySupport;
import eu.emi.security.authn.x509.RevocationParameters;
import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.ValidationError;
import eu.emi.security.authn.x509.ValidationErrorCode;
import eu.emi.security.authn.x509.ValidationErrorListener;
import eu.emi.security.authn.x509.ValidationResult;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.crl.AbstractCRLStoreSPI;
import eu.emi.security.authn.x509.helpers.crl.SimpleCRLStore;
import eu.emi.security.authn.x509.helpers.pkipath.BCCertPathValidator;
import eu.emi.security.authn.x509.helpers.trust.TrustAnchorStore;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractValidator
implements X509CertChainValidatorExt {
    protected Set<ValidationErrorListener> listeners;
    protected final ObserversHandler observers;
    private TrustAnchorStore caStore;
    private AbstractCRLStoreSPI crlStore;
    protected BCCertPathValidator validator;
    private ProxySupport proxySupport;
    private RevocationParameters revocationMode;
    protected boolean disposed;

    public AbstractValidator(Collection<? extends StoreUpdateListener> initialListeners) {
        this.observers = new ObserversHandler(initialListeners);
        this.listeners = new LinkedHashSet<ValidationErrorListener>();
    }

    protected synchronized void init(TrustAnchorStore caStore, AbstractCRLStoreSPI crlStore, ProxySupport proxySupport, RevocationParameters revocationCheckingMode) {
        this.disposed = false;
        if (caStore != null) {
            this.caStore = caStore;
        }
        if (crlStore != null) {
            this.crlStore = crlStore;
        }
        this.validator = new BCCertPathValidator();
        this.proxySupport = proxySupport;
        this.revocationMode = revocationCheckingMode;
    }

    @Override
    public ValidationResult validate(CertPath certPath) {
        List<? extends Certificate> certs = certPath.getCertificates();
        X509Certificate[] certsA = new X509Certificate[certs.size()];
        for (int i = 0; i < certsA.length; ++i) {
            Certificate c = certs.get(i);
            if (!(c instanceof X509Certificate)) {
                throw new IllegalArgumentException("Can validate only X509Certificate chains. Found instance of: " + c.getClass().getName());
            }
            certsA[i] = (X509Certificate)c;
        }
        return this.validate(certsA);
    }

    @Override
    public ValidationResult validate(X509Certificate[] certChain) {
        return this.validate(certChain, this.caStore.getTrustAnchors());
    }

    protected ValidationResult validate(X509Certificate[] certChain, Set<TrustAnchor> anchors) {
        ValidationResult result;
        if (this.isDisposed()) {
            throw new IllegalStateException("The validator instance was disposed");
        }
        try {
            result = this.validator.validate(certChain, this.getProxySupport() == ProxySupport.ALLOW, anchors, new SimpleCRLStore(this.crlStore), this.revocationMode, this.observers);
        }
        catch (CertificateException e) {
            e.printStackTrace();
            ValidationError error = new ValidationError(certChain, -1, ValidationErrorCode.inputError, e.toString());
            result = new ValidationResult(false, Collections.singletonList(error));
        }
        if (!result.isValid()) {
            List<ValidationError> errors = result.getErrors();
            this.processErrorList(errors);
            result.setErrors(errors);
            if (result.getErrors().size() == 0 && result.getUnresolvedCriticalExtensions().size() == 0) {
                return new ValidationResult(true);
            }
        }
        return result;
    }

    protected void processErrorList(List<ValidationError> errors) {
        for (int i = 0; i < errors.size(); ++i) {
            boolean res = this.notifyListeners(errors.get(i));
            if (!res) continue;
            errors.remove(i);
            --i;
        }
    }

    @Override
    public synchronized X509Certificate[] getTrustedIssuers() {
        return this.caStore.getTrustedCertificates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean notifyListeners(ValidationError error) {
        Set<ValidationErrorListener> set = this.listeners;
        synchronized (set) {
            for (ValidationErrorListener listener : this.listeners) {
                if (!listener.onValidationError(error)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValidationListener(ValidationErrorListener listener) {
        Set<ValidationErrorListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeValidationListener(ValidationErrorListener listener) {
        Set<ValidationErrorListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public synchronized ProxySupport getProxySupport() {
        return this.proxySupport;
    }

    @Override
    public synchronized RevocationParameters getRevocationCheckingMode() {
        return this.revocationMode;
    }

    @Override
    public synchronized void dispose() {
        this.disposed = true;
        this.observers.removeAllObservers();
        this.crlStore.dispose();
        this.caStore.dispose();
    }

    protected synchronized boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void addUpdateListener(StoreUpdateListener listener) {
        this.observers.addObserver(listener);
    }

    @Override
    public void removeUpdateListener(StoreUpdateListener listener) {
        this.observers.addObserver(listener);
    }

    static {
        CertificateUtils.configureSecProvider();
    }
}

