/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ocsp;

import eu.emi.security.authn.x509.OCSPParametes;
import eu.emi.security.authn.x509.OCSPResponder;
import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.ValidationErrorCode;
import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPCachingClient;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPResult;
import eu.emi.security.authn.x509.helpers.pkipath.SimpleValidationErrorException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.ocsp.OCSPException;

public class OCSPVerifier {
    private OCSPParametes params;
    private ObserversHandler observers;
    public static String OCSP_CACHE_PFX = "ocspresp_";

    public OCSPVerifier(OCSPParametes params, ObserversHandler observers) {
        this.params = params;
        this.observers = observers;
    }

    public OCSPResult verify(X509Certificate toCheck, X509Certificate issuerCert) throws SimpleValidationErrorException {
        List<OCSPResponder> certResponders = this.getOCSPUrls(toCheck, issuerCert);
        OCSPResponder[] localResponders = this.params.getLocalResponders();
        ArrayList<OCSPResponder> allResponders = new ArrayList<OCSPResponder>();
        if (this.params.isPreferLocalResponders()) {
            Collections.addAll(allResponders, localResponders);
            allResponders.addAll(certResponders);
        } else {
            allResponders.addAll(certResponders);
            Collections.addAll(allResponders, localResponders);
        }
        if (allResponders.size() == 0) {
            throw new SimpleValidationErrorException(ValidationErrorCode.ocspNoResponder, new Object[0]);
        }
        File diskCachePath = this.params.getDiskCachePath() == null ? null : new File(this.params.getDiskCachePath());
        OCSPCachingClient client = new OCSPCachingClient(this.params.getCacheTtl(), diskCachePath, OCSP_CACHE_PFX);
        for (int i = 0; i < allResponders.size(); ++i) {
            OCSPResult status;
            block11: {
                OCSPResponder responder = (OCSPResponder)allResponders.get(i);
                if (i < allResponders.size() - 1) {
                    try {
                        status = client.queryForCertificate(responder.getAddress(), toCheck, responder.getCertificate(), null, this.params.isUseNonce(), this.params.getConntectTimeout());
                        break block11;
                    }
                    catch (Exception e) {
                        this.observers.notifyObservers(responder.getAddress().toExternalForm(), "OCSP", StoreUpdateListener.Severity.WARNING, e);
                        continue;
                    }
                }
                try {
                    status = client.queryForCertificate(responder.getAddress(), toCheck, responder.getCertificate(), null, this.params.isUseNonce(), this.params.getConntectTimeout());
                }
                catch (IOException e) {
                    this.observers.notifyObservers(responder.getAddress().toExternalForm(), "OCSP", StoreUpdateListener.Severity.WARNING, e);
                    throw new SimpleValidationErrorException(ValidationErrorCode.ocspResponderQueryError, responder.getAddress(), e.getMessage());
                }
                catch (OCSPException e) {
                    this.observers.notifyObservers(responder.getAddress().toExternalForm(), "OCSP", StoreUpdateListener.Severity.WARNING, (Exception)((Object)e));
                    throw new SimpleValidationErrorException(ValidationErrorCode.ocspResponseInvalid, responder.getAddress(), e.getMessage());
                }
                catch (Exception e) {
                    this.observers.notifyObservers(responder.getAddress().toExternalForm(), "OCSP", StoreUpdateListener.Severity.WARNING, e);
                    throw new SimpleValidationErrorException(ValidationErrorCode.ocspOtherError, responder.getAddress(), e.toString());
                }
            }
            if (status.getStatus() == OCSPResult.Status.unknown) continue;
            return status;
        }
        return new OCSPResult(OCSPResult.Status.unknown);
    }

    protected List<OCSPResponder> getOCSPUrls(X509Certificate certificate, X509Certificate issuerCert) throws SimpleValidationErrorException {
        ASN1Sequence seq;
        AuthorityInformationAccess authInfoAcc = null;
        byte[] authInfoExt = certificate.getExtensionValue(Extension.authorityInfoAccess.getId());
        if (authInfoExt != null) {
            ASN1InputStream aIn = new ASN1InputStream(authInfoExt);
            try {
                ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
                aIn.close();
                aIn = new ASN1InputStream(octs.getOctets());
                seq = ASN1Sequence.getInstance((Object)aIn.readObject());
                aIn.close();
            }
            catch (IOException e) {
                throw new SimpleValidationErrorException(ValidationErrorCode.ocspOtherError, "unknown", "Can't extract Authority Info Access extension: " + e.toString());
            }
        } else {
            return new ArrayList<OCSPResponder>();
        }
        authInfoAcc = AuthorityInformationAccess.getInstance((Object)seq);
        ArrayList<OCSPResponder> ret = new ArrayList<OCSPResponder>();
        AccessDescription[] ads = authInfoAcc.getAccessDescriptions();
        for (int i = 0; i < ads.length; ++i) {
            GeneralName name;
            if (!ads[i].getAccessMethod().equals((Object)AccessDescription.id_ad_ocsp) || (name = ads[i].getAccessLocation()).getTagNo() != 6) continue;
            String url = ((DERIA5String)name.getName()).getString();
            try {
                ret.add(new OCSPResponder(new URL(url), issuerCert));
                continue;
            }
            catch (MalformedURLException e) {
                this.observers.notifyObservers(url, "OCSP", StoreUpdateListener.Severity.ERROR, new Exception("OCSP responder address in certificate being checked is not a valid URL: " + e.getMessage(), e));
            }
        }
        return ret;
    }
}

