/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginException;
import sun.security.action.GetBooleanAction;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.krb5.ServiceCreds;
import sun.security.jgss.krb5.SubjectComber;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KerberosSecrets;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.ktab.KeyTab;

public class Krb5Util {
    static final boolean DEBUG = AccessController.doPrivileged(new GetBooleanAction("sun.security.krb5.debug"));

    private Krb5Util() {
    }

    public static KerberosTicket getTicketFromSubjectAndTgs(GSSCaller caller, String clientPrincipal, String serverPrincipal, String tgsPrincipal, AccessControlContext acc) throws LoginException, KrbException, IOException {
        Credentials tgtCreds;
        Credentials serviceCreds;
        boolean fromAcc;
        KerberosTicket tgt;
        Subject accSubj = Subject.getSubject(acc);
        KerberosTicket ticket = SubjectComber.find(accSubj, serverPrincipal, clientPrincipal, KerberosTicket.class);
        if (ticket != null) {
            return ticket;
        }
        Subject loginSubj = null;
        if (!GSSUtil.useSubjectCredsOnly(caller)) {
            try {
                loginSubj = GSSUtil.login(caller, GSSUtil.GSS_KRB5_MECH_OID);
                ticket = SubjectComber.find(loginSubj, serverPrincipal, clientPrincipal, KerberosTicket.class);
                if (ticket != null) {
                    return ticket;
                }
            }
            catch (LoginException loginException) {
                // empty catch block
            }
        }
        if ((tgt = SubjectComber.find(accSubj, tgsPrincipal, clientPrincipal, KerberosTicket.class)) == null && loginSubj != null) {
            tgt = SubjectComber.find(loginSubj, tgsPrincipal, clientPrincipal, KerberosTicket.class);
            fromAcc = false;
        } else {
            fromAcc = true;
        }
        if (tgt != null && (serviceCreds = Credentials.acquireServiceCreds(serverPrincipal, tgtCreds = Krb5Util.ticketToCreds(tgt))) != null) {
            ticket = Krb5Util.credsToTicket(serviceCreds);
            if (fromAcc && accSubj != null && !accSubj.isReadOnly()) {
                accSubj.getPrivateCredentials().add(ticket);
            }
        }
        return ticket;
    }

    static KerberosTicket getTicket(GSSCaller caller, String clientPrincipal, String serverPrincipal, AccessControlContext acc) throws LoginException {
        Subject accSubj = Subject.getSubject(acc);
        KerberosTicket ticket = SubjectComber.find(accSubj, serverPrincipal, clientPrincipal, KerberosTicket.class);
        if (ticket == null && !GSSUtil.useSubjectCredsOnly(caller)) {
            Subject subject = GSSUtil.login(caller, GSSUtil.GSS_KRB5_MECH_OID);
            ticket = SubjectComber.find(subject, serverPrincipal, clientPrincipal, KerberosTicket.class);
        }
        return ticket;
    }

    public static Subject getSubject(GSSCaller caller, AccessControlContext acc) throws LoginException {
        Subject subject = Subject.getSubject(acc);
        if (subject == null && !GSSUtil.useSubjectCredsOnly(caller)) {
            subject = GSSUtil.login(caller, GSSUtil.GSS_KRB5_MECH_OID);
        }
        return subject;
    }

    public static ServiceCreds getServiceCreds(GSSCaller caller, String serverPrincipal, AccessControlContext acc) throws LoginException {
        Subject accSubj = Subject.getSubject(acc);
        ServiceCreds sc = null;
        if (accSubj != null) {
            sc = ServiceCreds.getInstance(accSubj, serverPrincipal);
        }
        if (sc == null && !GSSUtil.useSubjectCredsOnly(caller)) {
            Subject subject = GSSUtil.login(caller, GSSUtil.GSS_KRB5_MECH_OID);
            sc = ServiceCreds.getInstance(subject, serverPrincipal);
        }
        return sc;
    }

    public static KerberosTicket credsToTicket(Credentials serviceCreds) {
        EncryptionKey sessionKey = serviceCreds.getSessionKey();
        return new KerberosTicket(serviceCreds.getEncoded(), new KerberosPrincipal(serviceCreds.getClient().getName()), new KerberosPrincipal(serviceCreds.getServer().getName(), 2), sessionKey.getBytes(), sessionKey.getEType(), serviceCreds.getFlags(), serviceCreds.getAuthTime(), serviceCreds.getStartTime(), serviceCreds.getEndTime(), serviceCreds.getRenewTill(), serviceCreds.getClientAddresses());
    }

    public static Credentials ticketToCreds(KerberosTicket kerbTicket) throws KrbException, IOException {
        return new Credentials(kerbTicket.getEncoded(), kerbTicket.getClient().getName(), kerbTicket.getServer().getName(), kerbTicket.getSessionKey().getEncoded(), kerbTicket.getSessionKeyType(), kerbTicket.getFlags(), kerbTicket.getAuthTime(), kerbTicket.getStartTime(), kerbTicket.getEndTime(), kerbTicket.getRenewTill(), kerbTicket.getClientAddresses());
    }

    public static KeyTab snapshotFromJavaxKeyTab(javax.security.auth.kerberos.KeyTab ktab) {
        return KerberosSecrets.getJavaxSecurityAuthKerberosAccess().keyTabTakeSnapshot(ktab);
    }

    public static EncryptionKey[] keysFromJavaxKeyTab(javax.security.auth.kerberos.KeyTab ktab, PrincipalName cname) {
        return Krb5Util.snapshotFromJavaxKeyTab(ktab).readServiceKeys(cname);
    }
}

