/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.Consumer;

public class PriorityQueue<E>
extends AbstractQueue<E>
implements Serializable {
    private static final long serialVersionUID = -7720805057305804111L;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    transient Object[] queue;
    private int size = 0;
    private final Comparator<? super E> comparator;
    transient int modCount = 0;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public PriorityQueue() {
        this(11, null);
    }

    public PriorityQueue(int initialCapacity) {
        this(initialCapacity, null);
    }

    public PriorityQueue(Comparator<? super E> comparator) {
        this(11, comparator);
    }

    public PriorityQueue(int initialCapacity, Comparator<? super E> comparator) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException();
        }
        this.queue = new Object[initialCapacity];
        this.comparator = comparator;
    }

    public PriorityQueue(Collection<? extends E> c) {
        if (c instanceof SortedSet) {
            SortedSet ss = (SortedSet)c;
            this.comparator = ss.comparator();
            this.initElementsFromCollection(ss);
        } else if (c instanceof PriorityQueue) {
            PriorityQueue pq = (PriorityQueue)c;
            this.comparator = pq.comparator();
            this.initFromPriorityQueue(pq);
        } else {
            this.comparator = null;
            this.initFromCollection(c);
        }
    }

    public PriorityQueue(PriorityQueue<? extends E> c) {
        this.comparator = c.comparator();
        this.initFromPriorityQueue(c);
    }

    public PriorityQueue(SortedSet<? extends E> c) {
        this.comparator = c.comparator();
        this.initElementsFromCollection(c);
    }

    private void initFromPriorityQueue(PriorityQueue<? extends E> c) {
        if (c.getClass() == PriorityQueue.class) {
            this.queue = c.toArray();
            this.size = c.size();
        } else {
            this.initFromCollection(c);
        }
    }

    private void initElementsFromCollection(Collection<? extends E> c) {
        int len;
        Object[] a = c.toArray();
        if (a.getClass() != Object[].class) {
            a = Arrays.copyOf(a, a.length, Object[].class);
        }
        if ((len = a.length) == 1 || this.comparator != null) {
            for (int i = 0; i < len; ++i) {
                if (a[i] != null) continue;
                throw new NullPointerException();
            }
        }
        this.queue = a;
        this.size = a.length;
    }

    private void initFromCollection(Collection<? extends E> c) {
        this.initElementsFromCollection(c);
        this.heapify();
    }

    private void grow(int minCapacity) {
        int oldCapacity;
        int newCapacity = oldCapacity + ((oldCapacity = this.queue.length) < 64 ? oldCapacity + 2 : oldCapacity >> 1);
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = PriorityQueue.hugeCapacity(minCapacity);
        }
        this.queue = Arrays.copyOf(this.queue, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        ++this.modCount;
        int i = this.size;
        if (i >= this.queue.length) {
            this.grow(i + 1);
        }
        this.size = i + 1;
        if (i == 0) {
            this.queue[0] = e;
        } else {
            this.siftUp(i, e);
        }
        return true;
    }

    @Override
    public E peek() {
        return (E)(this.size == 0 ? null : this.queue[0]);
    }

    private int indexOf(Object o) {
        if (o != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!o.equals(this.queue[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i == -1) {
            return false;
        }
        this.removeAt(i);
        return true;
    }

    boolean removeEq(Object o) {
        for (int i = 0; i < this.size; ++i) {
            if (o != this.queue[i]) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.queue, this.size);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size;
        if (a.length < size) {
            return Arrays.copyOf(this.queue, size, a.getClass());
        }
        System.arraycopy(this.queue, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.queue[i] = null;
        }
        this.size = 0;
    }

    @Override
    public E poll() {
        if (this.size == 0) {
            return null;
        }
        int s = --this.size;
        ++this.modCount;
        Object result = this.queue[0];
        Object x = this.queue[s];
        this.queue[s] = null;
        if (s != 0) {
            this.siftDown(0, x);
        }
        return (E)result;
    }

    private E removeAt(int i) {
        int s;
        ++this.modCount;
        if ((s = --this.size) == i) {
            this.queue[i] = null;
        } else {
            Object moved = this.queue[s];
            this.queue[s] = null;
            this.siftDown(i, moved);
            if (this.queue[i] == moved) {
                this.siftUp(i, moved);
                if (this.queue[i] != moved) {
                    return (E)moved;
                }
            }
        }
        return null;
    }

    private void siftUp(int k, E x) {
        if (this.comparator != null) {
            this.siftUpUsingComparator(k, x);
        } else {
            this.siftUpComparable(k, x);
        }
    }

    private void siftUpComparable(int k, E x) {
        int parent;
        Object e;
        Comparable key = (Comparable)x;
        while (k > 0 && key.compareTo(e = this.queue[parent = k - 1 >>> 1]) < 0) {
            this.queue[k] = e;
            k = parent;
        }
        this.queue[k] = key;
    }

    private void siftUpUsingComparator(int k, E x) {
        int parent;
        Object e;
        while (k > 0 && this.comparator.compare(x, e = this.queue[parent = k - 1 >>> 1]) < 0) {
            this.queue[k] = e;
            k = parent;
        }
        this.queue[k] = x;
    }

    private void siftDown(int k, E x) {
        if (this.comparator != null) {
            this.siftDownUsingComparator(k, x);
        } else {
            this.siftDownComparable(k, x);
        }
    }

    private void siftDownComparable(int k, E x) {
        Comparable key = (Comparable)x;
        int half = this.size >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            Object c = this.queue[child];
            int right = child + 1;
            if (right < this.size && ((Comparable)c).compareTo(this.queue[right]) > 0) {
                child = right;
                c = this.queue[child];
            }
            if (key.compareTo(c) <= 0) break;
            this.queue[k] = c;
            k = child;
        }
        this.queue[k] = key;
    }

    private void siftDownUsingComparator(int k, E x) {
        int half = this.size >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            Object c = this.queue[child];
            int right = child + 1;
            if (right < this.size && this.comparator.compare(c, this.queue[right]) > 0) {
                child = right;
                c = this.queue[child];
            }
            if (this.comparator.compare(x, c) <= 0) break;
            this.queue[k] = c;
            k = child;
        }
        this.queue[k] = x;
    }

    private void heapify() {
        for (int i = (this.size >>> 1) - 1; i >= 0; --i) {
            this.siftDown(i, this.queue[i]);
        }
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(Math.max(2, this.size + 1));
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(this.queue[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        s.readInt();
        this.queue = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.queue[i] = s.readObject();
        }
        this.heapify();
    }

    @Override
    public final Spliterator<E> spliterator() {
        return new PriorityQueueSpliterator(this, 0, -1, 0);
    }

    static final class PriorityQueueSpliterator<E>
    implements Spliterator<E> {
        private final PriorityQueue<E> pq;
        private int index;
        private int fence;
        private int expectedModCount;

        PriorityQueueSpliterator(PriorityQueue<E> pq, int origin, int fence, int expectedModCount) {
            this.pq = pq;
            this.index = origin;
            this.fence = fence;
            this.expectedModCount = expectedModCount;
        }

        private int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                this.expectedModCount = this.pq.modCount;
                hi = this.fence = ((PriorityQueue)this.pq).size;
            }
            return hi;
        }

        @Override
        public PriorityQueueSpliterator<E> trySplit() {
            PriorityQueueSpliterator<E> priorityQueueSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                priorityQueueSpliterator = null;
            } else {
                this.index = mid;
                PriorityQueueSpliterator<E> priorityQueueSpliterator2 = new PriorityQueueSpliterator<E>(this.pq, lo, this.index, this.expectedModCount);
                priorityQueueSpliterator = priorityQueueSpliterator2;
            }
            return priorityQueueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            PriorityQueue<E> q = this.pq;
            if (q != null) {
                Object[] a = q.queue;
                if (q.queue != null) {
                    int mc;
                    int hi = this.fence;
                    if (hi < 0) {
                        mc = q.modCount;
                        hi = ((PriorityQueue)q).size;
                    } else {
                        mc = this.expectedModCount;
                    }
                    int i = this.index;
                    if (i >= 0 && (this.index = hi) <= a.length) {
                        while (true) {
                            Object e;
                            if (i < hi) {
                                e = a[i];
                                if (e == null) break;
                            } else {
                                if (q.modCount != mc) break;
                                return;
                            }
                            action.accept(e);
                            ++i;
                        }
                    }
                }
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int hi = this.getFence();
            int lo = this.index;
            if (lo >= 0 && lo < hi) {
                this.index = lo + 1;
                Object e = this.pq.queue[lo];
                if (e == null) {
                    throw new ConcurrentModificationException();
                }
                action.accept(e);
                if (this.pq.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16704;
        }
    }

    private final class Itr
    implements Iterator<E> {
        private int cursor = 0;
        private int lastRet = -1;
        private ArrayDeque<E> forgetMeNot = null;
        private E lastRetElt = null;
        private int expectedModCount;

        private Itr() {
            this.expectedModCount = PriorityQueue.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < PriorityQueue.this.size || this.forgetMeNot != null && !this.forgetMeNot.isEmpty();
        }

        @Override
        public E next() {
            if (this.expectedModCount != PriorityQueue.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.cursor < PriorityQueue.this.size) {
                this.lastRet = this.cursor++;
                return PriorityQueue.this.queue[this.lastRet];
            }
            if (this.forgetMeNot != null) {
                this.lastRet = -1;
                this.lastRetElt = this.forgetMeNot.poll();
                if (this.lastRetElt != null) {
                    return this.lastRetElt;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.expectedModCount != PriorityQueue.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet != -1) {
                Object moved = PriorityQueue.this.removeAt(this.lastRet);
                this.lastRet = -1;
                if (moved == null) {
                    --this.cursor;
                } else {
                    if (this.forgetMeNot == null) {
                        this.forgetMeNot = new ArrayDeque();
                    }
                    this.forgetMeNot.add(moved);
                }
            } else if (this.lastRetElt != null) {
                PriorityQueue.this.removeEq(this.lastRetElt);
                this.lastRetElt = null;
            } else {
                throw new IllegalStateException();
            }
            this.expectedModCount = PriorityQueue.this.modCount;
        }
    }
}

