/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.clients.util;

import java.io.PrintStream;
import java.util.EnumSet;

public class MessageLogger {
    public static final EnumSet<MessageLevel> DEFAULT = EnumSet.range(MessageLevel.INFO, MessageLevel.ERROR);
    public static final EnumSet<MessageLevel> QUIET = EnumSet.of(MessageLevel.ERROR, MessageLevel.WARNING);
    public static final EnumSet<MessageLevel> VERBOSE = EnumSet.allOf(MessageLevel.class);
    private final EnumSet<MessageLevel> levelFilter;
    private final MessageLevel defaultMessageLevel;
    private final PrintStream outputStream;
    private final PrintStream errorStream;

    public MessageLogger(PrintStream out, PrintStream err, EnumSet<MessageLevel> filter, MessageLevel defaultLevel) {
        this.outputStream = out;
        this.errorStream = err;
        this.levelFilter = filter;
        this.defaultMessageLevel = defaultLevel;
    }

    public MessageLogger() {
        this(System.out, System.err, DEFAULT, MessageLevel.INFO);
    }

    public MessageLogger(EnumSet<MessageLevel> filter) {
        this(System.out, System.err, filter, MessageLevel.INFO);
    }

    public final void formatMessage(MessageLevel level, String fmt, Object ... args) {
        PrintStream s = this.streamFromLevel(level);
        if (this.levelFilter.contains((Object)level)) {
            if (args == null || args.length == 0) {
                s.println(fmt);
            } else {
                s.format(fmt, args);
            }
        }
    }

    private PrintStream streamFromLevel(MessageLevel level) {
        if (level.equals((Object)MessageLevel.ERROR) || level.equals((Object)MessageLevel.WARNING)) {
            return this.errorStream;
        }
        return this.outputStream;
    }

    private void formatMessage(MessageLevel level, String msg, Throwable t) {
        if (msg != null) {
            if (t.getMessage() != null) {
                this.formatMessage(level, "%s - %s\n", msg, t.getMessage());
            } else {
                this.formatMessage(level, "%s - %s\n", msg, t.getClass().getName());
            }
        } else if (t.getMessage() != null) {
            this.formatMessage(level, "%s\n", t.getMessage());
        } else {
            this.formatMessage(level, "%s\n", t.getClass().getName());
        }
        if (this.levelFilter.contains((Object)MessageLevel.TRACE)) {
            t.printStackTrace(this.streamFromLevel(level));
        }
    }

    public final void printMessage(MessageLevel level, String msg) {
        this.formatMessage(level, "%s\n", msg);
    }

    public final void formatMessage(String fmt, Object ... args) {
        this.formatMessage(this.defaultMessageLevel, fmt, args);
    }

    public final void printMessage(String msg) {
        this.printMessage(this.defaultMessageLevel, msg);
    }

    public final void trace(String fmt, Object ... args) {
        this.formatMessage(MessageLevel.TRACE, fmt, args);
    }

    public final void error(String msg, Throwable t) {
        this.formatMessage(MessageLevel.ERROR, msg, t);
    }

    public final void warning(String msg, Throwable t) {
        this.formatMessage(MessageLevel.WARNING, msg, t);
    }

    public final void info(String msg, Throwable t) {
        this.formatMessage(MessageLevel.INFO, msg, t);
    }

    public final void trace(String msg, Throwable t) {
        this.formatMessage(MessageLevel.TRACE, msg, t);
    }

    public final void error(String fmt, Object ... args) {
        this.formatMessage(MessageLevel.ERROR, fmt, args);
    }

    public final void warning(String fmt, Object ... args) {
        this.formatMessage(MessageLevel.WARNING, fmt, args);
    }

    public final void info(String fmt, Object ... args) {
        this.formatMessage(MessageLevel.INFO, fmt, args);
    }

    public final void error(Throwable t) {
        this.formatMessage(MessageLevel.ERROR, null, t);
    }

    public final void warning(Throwable t) {
        this.formatMessage(MessageLevel.WARNING, null, t);
    }

    public final void info(Throwable t) {
        this.formatMessage(MessageLevel.INFO, null, t);
    }

    public final void trace(Throwable t) {
        this.formatMessage(MessageLevel.TRACE, null, t);
    }

    public PrintStream getOutputStream() {
        return this.outputStream;
    }

    public PrintStream getErrorStream() {
        return this.errorStream;
    }

    public boolean isLevelEnabled(MessageLevel l) {
        return this.levelFilter.contains((Object)l);
    }

    public static enum MessageLevel {
        TRACE,
        INFO,
        WARNING,
        ERROR;

    }
}

