/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.util;

import eu.emi.security.authn.x509.CrlCheckingMode;
import eu.emi.security.authn.x509.NamespaceCheckingMode;
import eu.emi.security.authn.x509.OCSPCheckingMode;
import eu.emi.security.authn.x509.OCSPParametes;
import eu.emi.security.authn.x509.ProxySupport;
import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.ValidationErrorListener;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.impl.CRLParameters;
import eu.emi.security.authn.x509.impl.OpensslCertChainValidator;
import eu.emi.security.authn.x509.impl.RevocationParametersExt;
import eu.emi.security.authn.x509.impl.ValidatorParams;
import eu.emi.security.authn.x509.impl.ValidatorParamsExt;
import java.util.Arrays;

public class CertificateValidatorBuilder {
    public static final OpensslHashFunction DEFAULT_OPENSSL_HASH_FUNCTION = OpensslHashFunction.MD5;
    public static final CrlCheckingMode DEFAULT_CRL_CHECKS = CrlCheckingMode.IF_VALID;
    public static final OCSPCheckingMode DEFAULT_OCSP_CHECKS = OCSPCheckingMode.IGNORE;
    public static final NamespaceCheckingMode DEFAULT_NS_CHECKS = NamespaceCheckingMode.GLOBUS_EUGRIDPMA;
    public static final String DEFAULT_TRUST_ANCHORS_DIR = "/etc/grid-security/certificates";
    public static final Boolean DEFAULT_VALIDATOR_IS_LAZY = Boolean.FALSE;
    public static final long DEFAULT_TRUST_ANCHORS_UPDATE_INTERVAL = 0L;
    private String trustAnchorsDir = "/etc/grid-security/certificates";
    private ValidationErrorListener validationErrorListener = null;
    private StoreUpdateListener storeUpdateListener = null;
    private long trustAnchorsUpdateInterval = 0L;
    private boolean lazyAnchorsLoading = DEFAULT_VALIDATOR_IS_LAZY;
    private NamespaceCheckingMode namespaceChecks = DEFAULT_NS_CHECKS;
    private CrlCheckingMode crlChecks = DEFAULT_CRL_CHECKS;
    private OCSPCheckingMode ocspChecks = DEFAULT_OCSP_CHECKS;
    private OpensslHashFunction opensslHashFunction = DEFAULT_OPENSSL_HASH_FUNCTION;

    public CertificateValidatorBuilder opensslHashFunction(OpensslHashFunction f) {
        this.opensslHashFunction = f;
        return this;
    }

    public CertificateValidatorBuilder storeUpdateListener(StoreUpdateListener l) {
        this.storeUpdateListener = l;
        return this;
    }

    public CertificateValidatorBuilder trustAnchorsDir(String dir) {
        this.trustAnchorsDir = dir;
        return this;
    }

    public CertificateValidatorBuilder validationErrorListener(ValidationErrorListener l) {
        this.validationErrorListener = l;
        return this;
    }

    public CertificateValidatorBuilder trustAnchorsUpdateInterval(long interval) {
        this.trustAnchorsUpdateInterval = interval;
        return this;
    }

    public CertificateValidatorBuilder lazyAnchorsLoading(boolean lazyness) {
        this.lazyAnchorsLoading = lazyness;
        return this;
    }

    public CertificateValidatorBuilder namespaceChecks(NamespaceCheckingMode nsChecks) {
        this.namespaceChecks = nsChecks;
        return this;
    }

    public CertificateValidatorBuilder crlChecks(CrlCheckingMode crl) {
        this.crlChecks = crl;
        return this;
    }

    public CertificateValidatorBuilder ocspChecks(OCSPCheckingMode ocsp) {
        this.ocspChecks = ocsp;
        return this;
    }

    public X509CertChainValidatorExt build() {
        RevocationParametersExt revocationParameters = new RevocationParametersExt(this.crlChecks, new CRLParameters(), new OCSPParametes(this.ocspChecks));
        ValidatorParamsExt validationParams = new ValidatorParamsExt(revocationParameters, ProxySupport.ALLOW);
        if (this.storeUpdateListener != null) {
            validationParams.setInitialListeners(Arrays.asList(this.storeUpdateListener));
        }
        boolean openssl1xMode = false;
        if (this.opensslHashFunction == OpensslHashFunction.SHA1) {
            openssl1xMode = true;
        }
        OpensslCertChainValidator validator = new OpensslCertChainValidator(this.trustAnchorsDir, openssl1xMode, this.namespaceChecks, this.trustAnchorsUpdateInterval, (ValidatorParams)validationParams, this.lazyAnchorsLoading);
        if (this.validationErrorListener != null) {
            validator.addValidationListener(this.validationErrorListener);
        }
        return validator;
    }

    public static X509CertChainValidatorExt buildCertificateValidator(String trustAnchorsDir, ValidationErrorListener validationErrorListener, StoreUpdateListener storeUpdateListener, long updateInterval, NamespaceCheckingMode namespaceChecks, CrlCheckingMode crlChecks, OCSPCheckingMode ocspChecks) {
        return CertificateValidatorBuilder.buildCertificateValidator(trustAnchorsDir, validationErrorListener, storeUpdateListener, updateInterval, namespaceChecks, crlChecks, ocspChecks, true);
    }

    public static X509CertChainValidatorExt buildCertificateValidator(String trustAnchorsDir, ValidationErrorListener validationErrorListener, StoreUpdateListener storeUpdateListener, long updateInterval, NamespaceCheckingMode namespaceChecks, CrlCheckingMode crlChecks, OCSPCheckingMode ocspChecks, boolean lazy) {
        CertificateValidatorBuilder builder = new CertificateValidatorBuilder();
        return builder.trustAnchorsDir(trustAnchorsDir).validationErrorListener(validationErrorListener).storeUpdateListener(storeUpdateListener).trustAnchorsUpdateInterval(updateInterval).namespaceChecks(namespaceChecks).crlChecks(crlChecks).ocspChecks(ocspChecks).lazyAnchorsLoading(lazy).build();
    }

    public static X509CertChainValidatorExt buildCertificateValidator(String trustAnchorsDir, ValidationErrorListener validationErrorListener) {
        return CertificateValidatorBuilder.buildCertificateValidator(trustAnchorsDir, validationErrorListener, null, 0L, DEFAULT_NS_CHECKS, DEFAULT_CRL_CHECKS, DEFAULT_OCSP_CHECKS);
    }

    public static X509CertChainValidatorExt buildCertificateValidator(String trustAnchorsDir, ValidationErrorListener validationErrorListener, StoreUpdateListener storeListener) {
        return CertificateValidatorBuilder.buildCertificateValidator(trustAnchorsDir, validationErrorListener, storeListener, 0L, DEFAULT_NS_CHECKS, DEFAULT_CRL_CHECKS, DEFAULT_OCSP_CHECKS);
    }

    public static X509CertChainValidatorExt buildCertificateValidator(String trustAnchorsDir, ValidationErrorListener validationErrorListener, StoreUpdateListener storeListener, long updateInterval, boolean lazy) {
        return CertificateValidatorBuilder.buildCertificateValidator(trustAnchorsDir, validationErrorListener, storeListener, updateInterval, DEFAULT_NS_CHECKS, DEFAULT_CRL_CHECKS, DEFAULT_OCSP_CHECKS, lazy);
    }

    public static X509CertChainValidatorExt buildCertificateValidator(String trustAnchorsDir, ValidationErrorListener validationErrorListener, StoreUpdateListener storeListener, long updateInterval) {
        return CertificateValidatorBuilder.buildCertificateValidator(trustAnchorsDir, validationErrorListener, storeListener, updateInterval, DEFAULT_NS_CHECKS, DEFAULT_CRL_CHECKS, DEFAULT_OCSP_CHECKS);
    }

    public static X509CertChainValidatorExt buildCertificateValidator(String trustAnchorsDir, ValidationErrorListener validationErrorListener, long updateInterval, boolean lazy) {
        return CertificateValidatorBuilder.buildCertificateValidator(trustAnchorsDir, validationErrorListener, null, updateInterval, DEFAULT_NS_CHECKS, DEFAULT_CRL_CHECKS, DEFAULT_OCSP_CHECKS, lazy);
    }

    public static X509CertChainValidatorExt buildCertificateValidator(String trustAnchorsDir, ValidationErrorListener validationErrorListener, long updateInterval) {
        return CertificateValidatorBuilder.buildCertificateValidator(trustAnchorsDir, validationErrorListener, null, updateInterval, DEFAULT_NS_CHECKS, DEFAULT_CRL_CHECKS, DEFAULT_OCSP_CHECKS);
    }

    public static X509CertChainValidatorExt buildCertificateValidator(String trustAnchorsDir) {
        return CertificateValidatorBuilder.buildCertificateValidator(trustAnchorsDir, null, null, 0L, DEFAULT_NS_CHECKS, DEFAULT_CRL_CHECKS, DEFAULT_OCSP_CHECKS);
    }

    public static X509CertChainValidatorExt buildCertificateValidator() {
        return CertificateValidatorBuilder.buildCertificateValidator(DEFAULT_TRUST_ANCHORS_DIR, null, null, 0L, DEFAULT_NS_CHECKS, DEFAULT_CRL_CHECKS, DEFAULT_OCSP_CHECKS);
    }

    public static enum OpensslHashFunction {
        MD5,
        SHA1;

    }
}

