/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.util;

import eu.emi.security.authn.x509.ProxySupport;
import eu.emi.security.authn.x509.RevocationParameters;
import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.ValidationErrorListener;
import eu.emi.security.authn.x509.ValidationResult;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.FormatMode;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.util.CachedValidationResult;
import org.italiangrid.voms.util.FingerprintHelper;

public class CachingCertificateValidator
implements X509CertChainValidatorExt {
    protected final ConcurrentMap<String, CachedValidationResult> validationResultsCache;
    protected final X509CertChainValidatorExt validator;
    protected final long cacheEntryLifetimeMsec;

    public CachingCertificateValidator(X509CertChainValidatorExt val, long maxCacheEntryLifetime) {
        this.cacheEntryLifetimeMsec = maxCacheEntryLifetime;
        this.validator = val;
        this.validationResultsCache = new ConcurrentHashMap<String, CachedValidationResult>();
    }

    public boolean cachedValidationResultHasExpired(CachedValidationResult cvr, long referenceTime) {
        return referenceTime - cvr.getTimestamp() > this.cacheEntryLifetimeMsec;
    }

    protected ValidationResult getCachedResult(String certFingerprint) {
        CachedValidationResult cvr = (CachedValidationResult)this.validationResultsCache.get(certFingerprint);
        if (cvr == null) {
            return null;
        }
        if (!this.cachedValidationResultHasExpired(cvr, System.currentTimeMillis())) {
            return cvr.getResult();
        }
        this.validationResultsCache.remove(certFingerprint, cvr);
        return null;
    }

    private void certChainSanityChecks(X509Certificate[] certChain) {
        if (certChain == null) {
            throw new IllegalArgumentException("Cannot validate a null cert chain.");
        }
        if (certChain.length == 0) {
            throw new IllegalArgumentException("Cannot validate a cert chain of length 0.");
        }
    }

    public ValidationResult validate(X509Certificate[] certChain) {
        this.certChainSanityChecks(certChain);
        String certFingerprint = null;
        try {
            certFingerprint = FingerprintHelper.getFingerprint(certChain[certChain.length - 1]);
        }
        catch (Throwable t) {
            String errorMsg = String.format("Error computing fingerprint for certificate: %s. Cause: %s", CertificateUtils.format((X509Certificate)certChain[0], (FormatMode)FormatMode.COMPACT_ONE_LINE), t.getMessage());
            throw new VOMSError(errorMsg, t);
        }
        ValidationResult res = this.getCachedResult(certFingerprint);
        if (res == null) {
            res = this.validator.validate(certChain);
            this.validationResultsCache.putIfAbsent(certFingerprint, new CachedValidationResult(certFingerprint, res));
        }
        return res;
    }

    public void dispose() {
        this.validator.dispose();
    }

    public ProxySupport getProxySupport() {
        return this.validator.getProxySupport();
    }

    public ValidationResult validate(CertPath certPath) {
        return this.validator.validate(certPath);
    }

    public RevocationParameters getRevocationCheckingMode() {
        return this.validator.getRevocationCheckingMode();
    }

    public X509Certificate[] getTrustedIssuers() {
        return this.validator.getTrustedIssuers();
    }

    public void addValidationListener(ValidationErrorListener listener) {
        this.validator.addValidationListener(listener);
    }

    public void removeValidationListener(ValidationErrorListener listener) {
        this.validator.removeValidationListener(listener);
    }

    public void addUpdateListener(StoreUpdateListener listener) {
        this.validator.addUpdateListener(listener);
    }

    public void removeUpdateListener(StoreUpdateListener listener) {
        this.validator.removeUpdateListener(listener);
    }
}

