#Base script written by David Smith, updated by Matt Doidge
#sets up PATHS for the tarball, source from /etc/profile.d/
#tweaked for centos7
#18/5/2016

#point this at your tarball base directory (cvmfs is just being used as a lazy example)
base=/cvmfs/grid.cern.ch/centos7-ui-preview-v01

#EMI_TARBALL_BASE flag to let jobs know that this is a tarball node
#also used to locate etc/emi-version file by SAM nagios probes

export EMI_TARBALL_BASE=$base

export EMI_UI_CONF=$base

#
#export X509_CERT_DIR=${base}/etc/grid-security/certificates
#export X509_VOMS_DIR=${base}/etc/grid-security/vomsdir

#cvmfs directories
export X509_CERT_DIR=/cvmfs/grid.cern.ch/etc/grid-security/certificates
export X509_VOMS_DIR=/cvmfs/grid.cern.ch/etc/grid-security/vomsdir


#export VOMS_USERCONF=${base}/etc/vomses
#cvmfs directory
export VOMS_USERCONF=/cvmfs/grid.cern.ch/etc/grid-security/vomses


#gfal2 specific variables
export GFAL_CONFIG_DIR=$EMI_TARBALL_BASE/etc/gfal2.d/
export GFAL_PLUGIN_DIR=$EMI_TARBALL_BASE/usr/lib64/gfal2-plugins/

export GLOBUS_LOCATION=${base}/usr

# site specific (with default)
# set these too someting more appropriate to your site/region
export MYPROXY_SERVER=myproxy.cern.ch
#export LCG_GFAL_INFOSYS=lcg-bdii.cern.ch:2170
export BDII_LIST=lcg-bdii.cern.ch:2170

# not site specific; usually no change needed
#
export -n GRID_ENV_LOCATION=
export -n GLITE_ENV_SET=
export GT_PROXY_MODE=old

#note that if the "base" LD_LIBRARY_PATH isn't set elsewhere you need to
#set it here, so that it also points to the local /lib, /lib64, /usr/lib,
#/usr/lib64 directories
v="$LD_LIBRARY_PATH"
export LD_LIBRARY_PATH=${base}/lib64:${base}/lib:${base}/usr/lib64:${base}/usr/lib
#if your site uses gsi dcap you will need to add to the LD_LIBRARY_PATH :${base}/usr/lib64/dcap
if [ -n "$v" ]; then
  export LD_LIBRARY_PATH="${LD_LIBRARY_PATH}:$v"
fi
#similar to LD_LIBRARY_PATH, if the PATH is not set elsewhere the "base elements" (/bin, /sbin etc)
#will need to be set here
export PATH=${base}/bin:${base}/sbin:${base}/usr/bin:${base}/usr/sbin:$PATH

v="$MANPATH"
export MANPATH=${base}/usr/share/man
if [ -n "$v" ]; then
  export MANPATH="${MANPATH}:$v"
fi

v="$PERL5LIB"
export PERL5LIB=${base}/usr/lib64/perl5/vendor_perl:${base}/usr/lib/perl5/vendor_perl
if [ -n "$v" ]; then
  export PERL5LIB="${PERL5LIB}:$v"
fi
v="$PYTHONPATH"
export PYTHONPATH=${base}/usr/lib64/python2.7/site-packages:${base}/usr/lib/python2.7/site-packages

#python 2.7 in EL7 based releases

if [ -n "$v" ]; then
  export PYTHONPATH="${PYTHONPATH}:$v"
fi

#if java is installed on the node it's advisable to use that version instead
#it's also worth checking to see if the version of java has changed within the
#tarball, although this should be correct - as of EMI3 the "tarball" java is in the
#os-extras tarball
#edit for centos 7 - no java or SRM in this tarball (yet)
export JAVA_HOME=${base}/usr/lib/jvm/java-1.8.0-openjdk-1.8.0.102-1.b14.el7_2.x86_64/jre
export LCG_LOCATION=${base}/usr
export GLITE_LOCATION=${base}/usr
export GLITE_LOCATION_VAR=/var
#export SRM_PATH=${base}/usr/share/srm
unset v base
