/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import sun.net.util.IPAddressUtil;
import sun.security.ssl.Debug;

final class Utilities {
    Utilities() {
    }

    static List<SNIServerName> addToSNIServerNameList(List<SNIServerName> serverNames, String hostname) {
        SNIHostName sniHostName = Utilities.rawToSNIHostName(hostname);
        if (sniHostName == null) {
            return serverNames;
        }
        int size = serverNames.size();
        ArrayList<SNIServerName> sniList = size != 0 ? new ArrayList<SNIServerName>(serverNames) : new ArrayList(1);
        boolean reset = false;
        for (int i = 0; i < size; ++i) {
            SNIServerName serverName = (SNIServerName)sniList.get(i);
            if (serverName.getType() != 0) continue;
            sniList.set(i, sniHostName);
            if (Debug.isOn("ssl")) {
                System.out.println(Thread.currentThread().getName() + ", the previous server name in SNI (" + serverName + ") was replaced with (" + sniHostName + ")");
            }
            reset = true;
            break;
        }
        if (!reset) {
            sniList.add(sniHostName);
        }
        return Collections.unmodifiableList(sniList);
    }

    private static SNIHostName rawToSNIHostName(String hostname) {
        SNIHostName sniHostName;
        block3: {
            sniHostName = null;
            if (!(hostname == null || hostname.indexOf(46) <= 0 || hostname.endsWith(".") || IPAddressUtil.isIPv4LiteralAddress(hostname) || IPAddressUtil.isIPv6LiteralAddress(hostname))) {
                try {
                    sniHostName = new SNIHostName(hostname);
                }
                catch (IllegalArgumentException iae) {
                    if (!Debug.isOn("ssl")) break block3;
                    System.out.println(Thread.currentThread().getName() + ", \"" + hostname + "\" is not a legal HostName for  server name indication");
                }
            }
        }
        return sniHostName;
    }
}

