/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.security.NoSuchAlgorithmException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.DefaultSSLServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public abstract class SSLServerSocketFactory
extends ServerSocketFactory {
    private static SSLServerSocketFactory theFactory;
    private static boolean propertyChecked;

    private static void log(String msg) {
        if (SSLSocketFactory.DEBUG) {
            System.out.println(msg);
        }
    }

    protected SSLServerSocketFactory() {
    }

    public static synchronized ServerSocketFactory getDefault() {
        if (theFactory != null) {
            return theFactory;
        }
        if (!propertyChecked) {
            propertyChecked = true;
            String clsName = SSLSocketFactory.getSecurityProperty("ssl.ServerSocketFactory.provider");
            if (clsName != null) {
                SSLServerSocketFactory.log("setting up default SSLServerSocketFactory");
                try {
                    Class<?> cls;
                    block9: {
                        cls = null;
                        try {
                            cls = Class.forName(clsName);
                        }
                        catch (ClassNotFoundException e) {
                            ClassLoader cl = ClassLoader.getSystemClassLoader();
                            if (cl == null) break block9;
                            cls = cl.loadClass(clsName);
                        }
                    }
                    SSLServerSocketFactory.log("class " + clsName + " is loaded");
                    SSLServerSocketFactory fac = (SSLServerSocketFactory)cls.newInstance();
                    SSLServerSocketFactory.log("instantiated an instance of class " + clsName);
                    theFactory = fac;
                    return fac;
                }
                catch (Exception e) {
                    SSLServerSocketFactory.log("SSLServerSocketFactory instantiation failed: " + e);
                    theFactory = new DefaultSSLServerSocketFactory(e);
                    return theFactory;
                }
            }
        }
        try {
            return SSLContext.getDefault().getServerSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            return new DefaultSSLServerSocketFactory(e);
        }
    }

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();
}

