/*
 * Decompiled with CFR 0.152.
 */
package sun.net.smtp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.AccessController;
import sun.net.TransferProtocolClient;
import sun.net.smtp.SmtpPrintStream;
import sun.net.smtp.SmtpProtocolException;
import sun.security.action.GetPropertyAction;

public class SmtpClient
extends TransferProtocolClient {
    String mailhost;
    SmtpPrintStream message;

    @Override
    public void closeServer() throws IOException {
        if (this.serverIsOpen()) {
            this.closeMessage();
            this.issueCommand("QUIT\r\n", 221);
            super.closeServer();
        }
    }

    void issueCommand(String cmd, int expect) throws IOException {
        int reply;
        this.sendServer(cmd);
        while ((reply = this.readServerResponse()) != expect) {
            if (reply == 220) continue;
            throw new SmtpProtocolException(this.getResponseString());
        }
    }

    private void toCanonical(String s) throws IOException {
        if (s.startsWith("<")) {
            this.issueCommand("rcpt to: " + s + "\r\n", 250);
        } else {
            this.issueCommand("rcpt to: <" + s + ">\r\n", 250);
        }
    }

    public void to(String s) throws IOException {
        int st = 0;
        int limit = s.length();
        int lastnonsp = 0;
        int parendepth = 0;
        boolean ignore = false;
        for (int pos = 0; pos < limit; ++pos) {
            char c = s.charAt(pos);
            if (parendepth > 0) {
                if (c == '(') {
                    ++parendepth;
                } else if (c == ')') {
                    --parendepth;
                }
                if (parendepth != 0) continue;
                if (lastnonsp > st) {
                    ignore = true;
                    continue;
                }
                st = pos + 1;
                continue;
            }
            if (c == '(') {
                ++parendepth;
                continue;
            }
            if (c == '<') {
                st = lastnonsp = pos + 1;
                continue;
            }
            if (c == '>') {
                ignore = true;
                continue;
            }
            if (c == ',') {
                if (lastnonsp > st) {
                    this.toCanonical(s.substring(st, lastnonsp));
                }
                st = pos + 1;
                ignore = false;
                continue;
            }
            if (c > ' ' && !ignore) {
                lastnonsp = pos + 1;
                continue;
            }
            if (st != pos) continue;
            ++st;
        }
        if (lastnonsp > st) {
            this.toCanonical(s.substring(st, lastnonsp));
        }
    }

    public void from(String s) throws IOException {
        if (s.startsWith("<")) {
            this.issueCommand("mail from: " + s + "\r\n", 250);
        } else {
            this.issueCommand("mail from: <" + s + ">\r\n", 250);
        }
    }

    private void openServer(String host) throws IOException {
        this.mailhost = host;
        this.openServer(this.mailhost, 25);
        this.issueCommand("helo " + InetAddress.getLocalHost().getHostName() + "\r\n", 250);
    }

    public PrintStream startMessage() throws IOException {
        this.issueCommand("data\r\n", 354);
        try {
            this.message = new SmtpPrintStream((OutputStream)this.serverOutput, this);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(encoding + " encoding not found", e);
        }
        return this.message;
    }

    void closeMessage() throws IOException {
        if (this.message != null) {
            this.message.close();
        }
    }

    public SmtpClient(String host) throws IOException {
        if (host != null) {
            try {
                this.openServer(host);
                this.mailhost = host;
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.mailhost = AccessController.doPrivileged(new GetPropertyAction("mail.host"));
            if (this.mailhost != null) {
                this.openServer(this.mailhost);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mailhost = "localhost";
            this.openServer(this.mailhost);
        }
        catch (Exception e) {
            this.mailhost = "mailhost";
            this.openServer(this.mailhost);
        }
    }

    public SmtpClient() throws IOException {
        this(null);
    }

    public SmtpClient(int to) throws IOException {
        this.setConnectTimeout(to);
        try {
            this.mailhost = AccessController.doPrivileged(new GetPropertyAction("mail.host"));
            if (this.mailhost != null) {
                this.openServer(this.mailhost);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mailhost = "localhost";
            this.openServer(this.mailhost);
        }
        catch (Exception e) {
            this.mailhost = "mailhost";
            this.openServer(this.mailhost);
        }
    }

    public String getMailHost() {
        return this.mailhost;
    }

    String getEncoding() {
        return encoding;
    }
}

