/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.GSSContextImpl;
import sun.security.jgss.GSSCredentialImpl;
import sun.security.jgss.GSSNameImpl;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.ProviderList;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.spi.MechanismFactory;

public class GSSManagerImpl
extends GSSManager {
    private static final String USE_NATIVE_PROP = "sun.security.jgss.native";
    private static final Boolean USE_NATIVE = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            String osname = System.getProperty("os.name");
            if (osname.startsWith("SunOS") || osname.contains("OS X") || osname.startsWith("Linux")) {
                return new Boolean(System.getProperty(GSSManagerImpl.USE_NATIVE_PROP));
            }
            return Boolean.FALSE;
        }
    });
    private ProviderList list;

    public GSSManagerImpl(GSSCaller caller, boolean useNative) {
        this.list = new ProviderList(caller, useNative);
    }

    public GSSManagerImpl(GSSCaller caller) {
        this.list = new ProviderList(caller, USE_NATIVE);
    }

    public GSSManagerImpl() {
        this.list = new ProviderList(GSSCaller.CALLER_UNKNOWN, USE_NATIVE);
    }

    @Override
    public Oid[] getMechs() {
        return this.list.getMechs();
    }

    @Override
    public Oid[] getNamesForMech(Oid mech) throws GSSException {
        MechanismFactory factory = this.list.getMechFactory(mech);
        return (Oid[])factory.getNameTypes().clone();
    }

    @Override
    public Oid[] getMechsForName(Oid nameType) {
        Oid[] mechs = this.list.getMechs();
        Oid[] retVal = new Oid[mechs.length];
        int pos = 0;
        if (nameType.equals(GSSNameImpl.oldHostbasedServiceName)) {
            nameType = GSSName.NT_HOSTBASED_SERVICE;
        }
        for (int i = 0; i < mechs.length; ++i) {
            Oid mech = mechs[i];
            try {
                Oid[] namesForMech = this.getNamesForMech(mech);
                if (!nameType.containedIn(namesForMech)) continue;
                retVal[pos++] = mech;
                continue;
            }
            catch (GSSException e) {
                GSSUtil.debug("Skip " + mech + ": error retrieving supported name types");
            }
        }
        if (pos < retVal.length) {
            Oid[] temp = new Oid[pos];
            for (int i = 0; i < pos; ++i) {
                temp[i] = retVal[i];
            }
            retVal = temp;
        }
        return retVal;
    }

    @Override
    public GSSName createName(String nameStr, Oid nameType) throws GSSException {
        return new GSSNameImpl(this, nameStr, nameType);
    }

    @Override
    public GSSName createName(byte[] name, Oid nameType) throws GSSException {
        return new GSSNameImpl(this, name, nameType);
    }

    @Override
    public GSSName createName(String nameStr, Oid nameType, Oid mech) throws GSSException {
        return new GSSNameImpl(this, nameStr, nameType, mech);
    }

    @Override
    public GSSName createName(byte[] name, Oid nameType, Oid mech) throws GSSException {
        return new GSSNameImpl(this, name, nameType, mech);
    }

    @Override
    public GSSCredential createCredential(int usage) throws GSSException {
        return new GSSCredentialImpl(this, usage);
    }

    @Override
    public GSSCredential createCredential(GSSName aName, int lifetime, Oid mech, int usage) throws GSSException {
        return new GSSCredentialImpl(this, aName, lifetime, mech, usage);
    }

    @Override
    public GSSCredential createCredential(GSSName aName, int lifetime, Oid[] mechs, int usage) throws GSSException {
        return new GSSCredentialImpl(this, aName, lifetime, mechs, usage);
    }

    @Override
    public GSSContext createContext(GSSName peer, Oid mech, GSSCredential myCred, int lifetime) throws GSSException {
        return new GSSContextImpl(this, peer, mech, myCred, lifetime);
    }

    @Override
    public GSSContext createContext(GSSCredential myCred) throws GSSException {
        return new GSSContextImpl(this, myCred);
    }

    @Override
    public GSSContext createContext(byte[] interProcessToken) throws GSSException {
        return new GSSContextImpl(this, interProcessToken);
    }

    @Override
    public void addProviderAtFront(Provider p, Oid mech) throws GSSException {
        this.list.addProviderAtFront(p, mech);
    }

    @Override
    public void addProviderAtEnd(Provider p, Oid mech) throws GSSException {
        this.list.addProviderAtEnd(p, mech);
    }

    public GSSCredentialSpi getCredentialElement(GSSNameSpi name, int initLifetime, int acceptLifetime, Oid mech, int usage) throws GSSException {
        MechanismFactory factory = this.list.getMechFactory(mech);
        return factory.getCredentialElement(name, initLifetime, acceptLifetime, usage);
    }

    public GSSNameSpi getNameElement(String name, Oid nameType, Oid mech) throws GSSException {
        MechanismFactory factory = this.list.getMechFactory(mech);
        return factory.getNameElement(name, nameType);
    }

    public GSSNameSpi getNameElement(byte[] name, Oid nameType, Oid mech) throws GSSException {
        MechanismFactory factory = this.list.getMechFactory(mech);
        return factory.getNameElement(name, nameType);
    }

    GSSContextSpi getMechanismContext(GSSNameSpi peer, GSSCredentialSpi myInitiatorCred, int lifetime, Oid mech) throws GSSException {
        Provider p = null;
        if (myInitiatorCred != null) {
            p = myInitiatorCred.getProvider();
        }
        MechanismFactory factory = this.list.getMechFactory(mech, p);
        return factory.getMechanismContext(peer, myInitiatorCred, lifetime);
    }

    GSSContextSpi getMechanismContext(GSSCredentialSpi myAcceptorCred, Oid mech) throws GSSException {
        Provider p = null;
        if (myAcceptorCred != null) {
            p = myAcceptorCred.getProvider();
        }
        MechanismFactory factory = this.list.getMechFactory(mech, p);
        return factory.getMechanismContext(myAcceptorCred);
    }

    GSSContextSpi getMechanismContext(byte[] exportedContext) throws GSSException {
        MechanismFactory factory;
        if (exportedContext == null || exportedContext.length == 0) {
            throw new GSSException(12);
        }
        GSSContextSpi result = null;
        Oid[] mechs = this.list.getMechs();
        for (int i = 0; !(i >= mechs.length || (factory = this.list.getMechFactory(mechs[i])).getProvider().getName().equals("SunNativeGSS") && (result = factory.getMechanismContext(exportedContext)) != null); ++i) {
        }
        if (result == null) {
            throw new GSSException(16);
        }
        return result;
    }
}

