/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.StubNotFoundException;
import java.rmi.server.LogStream;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonNotFoundException;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import sun.rmi.runtime.Log;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;

public final class Util {
    static final int logLevel = LogStream.parseLevel(AccessController.doPrivileged(new GetPropertyAction("sun.rmi.server.logLevel")));
    public static final Log serverRefLog = Log.getLog("sun.rmi.server.ref", "transport", logLevel);
    private static final boolean ignoreStubClasses = AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.ignoreStubClasses"));
    private static final Map<Class<?>, Void> withoutStubs = Collections.synchronizedMap(new WeakHashMap(11));
    private static final Class<?>[] stubConsParamTypes = new Class[]{RemoteRef.class};

    private Util() {
    }

    public static Remote createProxy(Class<?> implClass, RemoteRef clientRef, boolean forceStubUse) throws StubNotFoundException {
        Class<?> remoteClass;
        try {
            remoteClass = Util.getRemoteClass(implClass);
        }
        catch (ClassNotFoundException ex) {
            throw new StubNotFoundException("object does not implement a remote interface: " + implClass.getName());
        }
        if (forceStubUse || !ignoreStubClasses && Util.stubClassExists(remoteClass)) {
            return Util.createStub(remoteClass, clientRef);
        }
        final ClassLoader loader = implClass.getClassLoader();
        final Class[] interfaces = Util.getRemoteInterfaces(implClass);
        final RemoteObjectInvocationHandler handler = new RemoteObjectInvocationHandler(clientRef);
        try {
            return AccessController.doPrivileged(new PrivilegedAction<Remote>(){

                @Override
                public Remote run() {
                    return (Remote)Proxy.newProxyInstance(loader, interfaces, handler);
                }
            });
        }
        catch (IllegalArgumentException e) {
            throw new StubNotFoundException("unable to create proxy", e);
        }
    }

    private static boolean stubClassExists(Class<?> remoteClass) {
        if (!withoutStubs.containsKey(remoteClass)) {
            try {
                Class.forName(remoteClass.getName() + "_Stub", false, remoteClass.getClassLoader());
                return true;
            }
            catch (ClassNotFoundException cnfe) {
                withoutStubs.put(remoteClass, null);
            }
        }
        return false;
    }

    private static Class<?> getRemoteClass(Class<?> cl) throws ClassNotFoundException {
        while (cl != null) {
            Class<?>[] interfaces = cl.getInterfaces();
            for (int i = interfaces.length - 1; i >= 0; --i) {
                if (!Remote.class.isAssignableFrom(interfaces[i])) continue;
                return cl;
            }
            cl = cl.getSuperclass();
        }
        throw new ClassNotFoundException("class does not implement java.rmi.Remote");
    }

    private static Class<?>[] getRemoteInterfaces(Class<?> remoteClass) {
        ArrayList list = new ArrayList();
        Util.getRemoteInterfaces(list, remoteClass);
        return list.toArray(new Class[list.size()]);
    }

    private static void getRemoteInterfaces(ArrayList<Class<?>> list, Class<?> cl) {
        Class<?> superclass = cl.getSuperclass();
        if (superclass != null) {
            Util.getRemoteInterfaces(list, superclass);
        }
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> intf = interfaces[i];
            if (!Remote.class.isAssignableFrom(intf) || list.contains(intf)) continue;
            Method[] methods = intf.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                Util.checkMethod(methods[j]);
            }
            list.add(intf);
        }
    }

    private static void checkMethod(Method m) {
        Class<?>[] ex = m.getExceptionTypes();
        for (int i = 0; i < ex.length; ++i) {
            if (!ex[i].isAssignableFrom(RemoteException.class)) continue;
            return;
        }
        throw new IllegalArgumentException("illegal remote method encountered: " + m);
    }

    private static RemoteStub createStub(Class<?> remoteClass, RemoteRef ref) throws StubNotFoundException {
        String stubname = remoteClass.getName() + "_Stub";
        try {
            Class<?> stubcl = Class.forName(stubname, false, remoteClass.getClassLoader());
            Constructor<?> cons = stubcl.getConstructor(stubConsParamTypes);
            return (RemoteStub)cons.newInstance(ref);
        }
        catch (ClassNotFoundException e) {
            throw new StubNotFoundException("Stub class not found: " + stubname, e);
        }
        catch (NoSuchMethodException e) {
            throw new StubNotFoundException("Stub class missing constructor: " + stubname, e);
        }
        catch (InstantiationException e) {
            throw new StubNotFoundException("Can't create instance of stub class: " + stubname, e);
        }
        catch (IllegalAccessException e) {
            throw new StubNotFoundException("Stub class constructor not public: " + stubname, e);
        }
        catch (InvocationTargetException e) {
            throw new StubNotFoundException("Exception creating instance of stub class: " + stubname, e);
        }
        catch (ClassCastException e) {
            throw new StubNotFoundException("Stub class not instance of RemoteStub: " + stubname, e);
        }
    }

    static Skeleton createSkeleton(Remote object) throws SkeletonNotFoundException {
        Class<?> cl;
        try {
            cl = Util.getRemoteClass(object.getClass());
        }
        catch (ClassNotFoundException ex) {
            throw new SkeletonNotFoundException("object does not implement a remote interface: " + object.getClass().getName());
        }
        String skelname = cl.getName() + "_Skel";
        try {
            Class<?> skelcl = Class.forName(skelname, false, cl.getClassLoader());
            return (Skeleton)skelcl.newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new SkeletonNotFoundException("Skeleton class not found: " + skelname, ex);
        }
        catch (InstantiationException ex) {
            throw new SkeletonNotFoundException("Can't create skeleton: " + skelname, ex);
        }
        catch (IllegalAccessException ex) {
            throw new SkeletonNotFoundException("No public constructor: " + skelname, ex);
        }
        catch (ClassCastException ex) {
            throw new SkeletonNotFoundException("Skeleton not of correct class: " + skelname, ex);
        }
    }

    public static long computeMethodHash(Method m) {
        long hash = 0L;
        ByteArrayOutputStream sink = new ByteArrayOutputStream(127);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            DataOutputStream out = new DataOutputStream(new DigestOutputStream(sink, md));
            String s = Util.getMethodNameAndDescriptor(m);
            if (serverRefLog.isLoggable(Log.VERBOSE)) {
                serverRefLog.log(Log.VERBOSE, "string used for method hash: \"" + s + "\"");
            }
            out.writeUTF(s);
            out.flush();
            byte[] hasharray = md.digest();
            for (int i = 0; i < Math.min(8, hasharray.length); ++i) {
                hash += (long)(hasharray[i] & 0xFF) << i * 8;
            }
        }
        catch (IOException ignore) {
            hash = -1L;
        }
        catch (NoSuchAlgorithmException complain) {
            throw new SecurityException(complain.getMessage());
        }
        return hash;
    }

    private static String getMethodNameAndDescriptor(Method m) {
        StringBuffer desc = new StringBuffer(m.getName());
        desc.append('(');
        Class<?>[] paramTypes = m.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            desc.append(Util.getTypeDescriptor(paramTypes[i]));
        }
        desc.append(')');
        Class<?> returnType = m.getReturnType();
        if (returnType == Void.TYPE) {
            desc.append('V');
        } else {
            desc.append(Util.getTypeDescriptor(returnType));
        }
        return desc.toString();
    }

    private static String getTypeDescriptor(Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return "I";
            }
            if (type == Boolean.TYPE) {
                return "Z";
            }
            if (type == Byte.TYPE) {
                return "B";
            }
            if (type == Character.TYPE) {
                return "C";
            }
            if (type == Short.TYPE) {
                return "S";
            }
            if (type == Long.TYPE) {
                return "J";
            }
            if (type == Float.TYPE) {
                return "F";
            }
            if (type == Double.TYPE) {
                return "D";
            }
            if (type == Void.TYPE) {
                return "V";
            }
            throw new Error("unrecognized primitive type: " + type);
        }
        if (type.isArray()) {
            return type.getName().replace('.', '/');
        }
        return "L" + type.getName().replace('.', '/') + ";";
    }

    public static String getUnqualifiedName(Class<?> c) {
        String binaryName = c.getName();
        return binaryName.substring(binaryName.lastIndexOf(46) + 1);
    }
}

