/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;

public class SynthTextFieldUI
extends BasicTextFieldUI
implements SynthUI {
    private Handler handler = new Handler();
    private SynthStyle style;

    public static ComponentUI createUI(JComponent c) {
        return new SynthTextFieldUI();
    }

    private void updateStyle(JTextComponent comp) {
        SynthContext context = this.getContext(comp, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            SynthTextFieldUI.updateStyle(comp, context, this.getPropertyPrefix());
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context.dispose();
    }

    static void updateStyle(JTextComponent comp, SynthContext context, String prefix) {
        Object o;
        Caret caret;
        Insets margin;
        Color sfg;
        Object ar;
        Color fg;
        SynthStyle style = context.getStyle();
        Color color = comp.getCaretColor();
        if (color == null || color instanceof UIResource) {
            comp.setCaretColor((Color)style.get(context, prefix + ".caretForeground"));
        }
        if (((fg = comp.getForeground()) == null || fg instanceof UIResource) && (fg = style.getColorForState(context, ColorType.TEXT_FOREGROUND)) != null) {
            comp.setForeground(fg);
        }
        if ((ar = style.get(context, prefix + ".caretAspectRatio")) instanceof Number) {
            comp.putClientProperty("caretAspectRatio", ar);
        }
        context.setComponentState(768);
        Color s = comp.getSelectionColor();
        if (s == null || s instanceof UIResource) {
            comp.setSelectionColor(style.getColor(context, ColorType.TEXT_BACKGROUND));
        }
        if ((sfg = comp.getSelectedTextColor()) == null || sfg instanceof UIResource) {
            comp.setSelectedTextColor(style.getColor(context, ColorType.TEXT_FOREGROUND));
        }
        context.setComponentState(8);
        Color dfg = comp.getDisabledTextColor();
        if (dfg == null || dfg instanceof UIResource) {
            comp.setDisabledTextColor(style.getColor(context, ColorType.TEXT_FOREGROUND));
        }
        if ((margin = comp.getMargin()) == null || margin instanceof UIResource) {
            margin = (Insets)style.get(context, prefix + ".margin");
            if (margin == null) {
                margin = SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS;
            }
            comp.setMargin(margin);
        }
        if ((caret = comp.getCaret()) instanceof UIResource && (o = style.get(context, prefix + ".caretBlinkRate")) != null && o instanceof Integer) {
            Integer rate = (Integer)o;
            caret.setBlinkRate(rate);
        }
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, SynthLookAndFeel.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(c, this.style, state);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        this.paintBackground(context, g, c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        super.paint(g, this.getComponent());
    }

    void paintBackground(SynthContext context, Graphics g, JComponent c) {
        context.getPainter().paintTextFieldBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintTextFieldBorder(context, g, x, y, w, h);
    }

    @Override
    protected void paintBackground(Graphics g) {
    }

    @Override
    protected void propertyChange(PropertyChangeEvent evt) {
        if (SynthLookAndFeel.shouldUpdateStyle(evt)) {
            this.updateStyle((JTextComponent)evt.getSource());
        }
        super.propertyChange(evt);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.updateStyle(this.getComponent());
        this.getComponent().addFocusListener(this.handler);
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this.getComponent(), 1);
        this.getComponent().putClientProperty("caretAspectRatio", null);
        this.getComponent().removeFocusListener(this.handler);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        super.uninstallDefaults();
    }

    private final class Handler
    implements FocusListener {
        private Handler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            SynthTextFieldUI.this.getComponent().repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            SynthTextFieldUI.this.getComponent().repaint();
        }
    }
}

