/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch.sctp;

import com.sun.nio.sctp.Association;
import com.sun.nio.sctp.PeerAddressChangeNotification;
import java.net.SocketAddress;
import sun.nio.ch.sctp.SctpNotification;

public class PeerAddrChange
extends PeerAddressChangeNotification
implements SctpNotification {
    private static final int SCTP_ADDR_AVAILABLE = 1;
    private static final int SCTP_ADDR_UNREACHABLE = 2;
    private static final int SCTP_ADDR_REMOVED = 3;
    private static final int SCTP_ADDR_ADDED = 4;
    private static final int SCTP_ADDR_MADE_PRIM = 5;
    private static final int SCTP_ADDR_CONFIRMED = 6;
    private Association association;
    private int assocId;
    private SocketAddress address;
    private PeerAddressChangeNotification.AddressChangeEvent event;

    private PeerAddrChange(int assocId, SocketAddress address, int intEvent) {
        switch (intEvent) {
            case 1: {
                this.event = PeerAddressChangeNotification.AddressChangeEvent.ADDR_AVAILABLE;
                break;
            }
            case 2: {
                this.event = PeerAddressChangeNotification.AddressChangeEvent.ADDR_UNREACHABLE;
                break;
            }
            case 3: {
                this.event = PeerAddressChangeNotification.AddressChangeEvent.ADDR_REMOVED;
                break;
            }
            case 4: {
                this.event = PeerAddressChangeNotification.AddressChangeEvent.ADDR_ADDED;
                break;
            }
            case 5: {
                this.event = PeerAddressChangeNotification.AddressChangeEvent.ADDR_MADE_PRIMARY;
                break;
            }
            case 6: {
                this.event = PeerAddressChangeNotification.AddressChangeEvent.ADDR_CONFIRMED;
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown event type");
            }
        }
        this.assocId = assocId;
        this.address = address;
    }

    @Override
    public int assocId() {
        return this.assocId;
    }

    @Override
    public void setAssociation(Association association) {
        this.association = association;
    }

    @Override
    public SocketAddress address() {
        assert (this.address != null);
        return this.address;
    }

    @Override
    public Association association() {
        assert (this.association != null);
        return this.association;
    }

    @Override
    public PeerAddressChangeNotification.AddressChangeEvent event() {
        assert (this.event != null);
        return this.event;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(" [");
        sb.append("Address: ").append(this.address);
        sb.append(", Association:").append(this.association);
        sb.append(", Event: ").append((Object)this.event).append("]");
        return sb.toString();
    }
}

