/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.x509.X509V1CertificateGenerator;
import org.bouncycastle.x509.X509V2CRLGenerator;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.bouncycastle.x509.extension.AuthorityKeyIdentifierStructure;
import org.bouncycastle.x509.extension.SubjectKeyIdentifierStructure;

class TestUtils {
    TestUtils() {
    }

    public static KeyPair generateRSAKeyPair() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
        kpGen.initialize(1024, new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static X509Certificate generateRootCert(KeyPair pair) throws Exception {
        X509V1CertificateGenerator certGen = new X509V1CertificateGenerator();
        certGen.setSerialNumber(BigInteger.valueOf(1L));
        certGen.setIssuerDN(new X509Principal("CN=Test CA Certificate"));
        certGen.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        certGen.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
        certGen.setSubjectDN(new X509Principal("CN=Test CA Certificate"));
        certGen.setPublicKey(pair.getPublic());
        certGen.setSignatureAlgorithm("SHA256WithRSAEncryption");
        return certGen.generate(pair.getPrivate(), "BC");
    }

    public static X509Certificate generateIntermediateCert(PublicKey intKey, PrivateKey caKey, X509Certificate caCert) throws Exception {
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.setSerialNumber(BigInteger.valueOf(1L));
        certGen.setIssuerDN(PrincipalUtil.getSubjectX509Principal(caCert));
        certGen.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        certGen.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
        certGen.setSubjectDN(new X509Principal("CN=Test Intermediate Certificate"));
        certGen.setPublicKey(intKey);
        certGen.setSignatureAlgorithm("SHA256WithRSAEncryption");
        certGen.addExtension((DERObjectIdentifier)X509Extensions.AuthorityKeyIdentifier, false, (ASN1Encodable)new AuthorityKeyIdentifierStructure(caCert));
        certGen.addExtension((DERObjectIdentifier)X509Extensions.SubjectKeyIdentifier, false, (ASN1Encodable)new SubjectKeyIdentifierStructure(intKey));
        certGen.addExtension((DERObjectIdentifier)X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(0));
        certGen.addExtension((DERObjectIdentifier)X509Extensions.KeyUsage, true, (ASN1Encodable)new KeyUsage(134));
        return certGen.generate(caKey, "BC");
    }

    public static X509Certificate generateEndEntityCert(PublicKey entityKey, PrivateKey caKey, X509Certificate caCert) throws Exception {
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.setSerialNumber(BigInteger.valueOf(1L));
        certGen.setIssuerDN(PrincipalUtil.getSubjectX509Principal(caCert));
        certGen.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        certGen.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
        certGen.setSubjectDN(new X509Principal("CN=Test End Certificate"));
        certGen.setPublicKey(entityKey);
        certGen.setSignatureAlgorithm("SHA256WithRSAEncryption");
        certGen.addExtension((DERObjectIdentifier)X509Extensions.AuthorityKeyIdentifier, false, (ASN1Encodable)new AuthorityKeyIdentifierStructure(caCert));
        certGen.addExtension((DERObjectIdentifier)X509Extensions.SubjectKeyIdentifier, false, (ASN1Encodable)new SubjectKeyIdentifierStructure(entityKey));
        certGen.addExtension((DERObjectIdentifier)X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        certGen.addExtension((DERObjectIdentifier)X509Extensions.KeyUsage, true, (ASN1Encodable)new KeyUsage(160));
        return certGen.generate(caKey, "BC");
    }

    public static X509CRL createCRL(X509Certificate caCert, PrivateKey caKey, BigInteger serialNumber) throws Exception {
        X509V2CRLGenerator crlGen = new X509V2CRLGenerator();
        Date now = new Date();
        BigInteger revokedSerialNumber = BigInteger.valueOf(2L);
        crlGen.setIssuerDN(PrincipalUtil.getSubjectX509Principal(caCert));
        crlGen.setThisUpdate(now);
        crlGen.setNextUpdate(new Date(now.getTime() + 100000L));
        crlGen.setSignatureAlgorithm("SHA256WithRSAEncryption");
        crlGen.addCRLEntry(serialNumber, now, 9);
        crlGen.addExtension((DERObjectIdentifier)X509Extensions.AuthorityKeyIdentifier, false, (ASN1Encodable)new AuthorityKeyIdentifierStructure(caCert));
        crlGen.addExtension((DERObjectIdentifier)X509Extensions.CRLNumber, false, (ASN1Encodable)new CRLNumber(BigInteger.valueOf(1L)));
        return crlGen.generate(caKey, "BC");
    }

    public static X509Certificate createExceptionCertificate(boolean exceptionOnEncode) {
        return new ExceptionCertificate(exceptionOnEncode);
    }

    private static class ExceptionCertificate
    extends X509Certificate {
        private boolean _exceptionOnEncode;

        public ExceptionCertificate(boolean exceptionOnEncode) {
            this._exceptionOnEncode = exceptionOnEncode;
        }

        @Override
        public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
            throw new CertificateNotYetValidException();
        }

        @Override
        public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
            throw new CertificateExpiredException();
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public BigInteger getSerialNumber() {
            return null;
        }

        @Override
        public Principal getIssuerDN() {
            return null;
        }

        @Override
        public Principal getSubjectDN() {
            return null;
        }

        @Override
        public Date getNotBefore() {
            return null;
        }

        @Override
        public Date getNotAfter() {
            return null;
        }

        @Override
        public byte[] getTBSCertificate() throws CertificateEncodingException {
            throw new CertificateEncodingException();
        }

        @Override
        public byte[] getSignature() {
            return new byte[0];
        }

        @Override
        public String getSigAlgName() {
            return null;
        }

        @Override
        public String getSigAlgOID() {
            return null;
        }

        @Override
        public byte[] getSigAlgParams() {
            return new byte[0];
        }

        @Override
        public boolean[] getIssuerUniqueID() {
            return new boolean[0];
        }

        @Override
        public boolean[] getSubjectUniqueID() {
            return new boolean[0];
        }

        @Override
        public boolean[] getKeyUsage() {
            return new boolean[0];
        }

        @Override
        public int getBasicConstraints() {
            return 0;
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            if (this._exceptionOnEncode) {
                throw new CertificateEncodingException();
            }
            return new byte[0];
        }

        @Override
        public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            throw new CertificateException();
        }

        @Override
        public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            throw new CertificateException();
        }

        @Override
        public String toString() {
            return null;
        }

        @Override
        public PublicKey getPublicKey() {
            return null;
        }

        @Override
        public boolean hasUnsupportedCriticalExtension() {
            return false;
        }

        public Set getCriticalExtensionOIDs() {
            return null;
        }

        public Set getNonCriticalExtensionOIDs() {
            return null;
        }

        @Override
        public byte[] getExtensionValue(String oid) {
            return new byte[0];
        }
    }
}

