/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import javax.crypto.KeyAgreement;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.util.test.SimpleTest;

public class NamedCurveTest
extends SimpleTest {
    private static Hashtable CURVE_NAMES = new Hashtable();
    private static Hashtable CURVE_ALIASES = new Hashtable();

    public void testCurve(String name) throws Exception {
        ECNamedCurveSpec privSpec;
        byte[] privEnc;
        PKCS8EncodedKeySpec privPKCS8;
        ECPrivateKey privKey;
        X509EncodedKeySpec pubX509;
        ECGenParameterSpec ecSpec = new ECGenParameterSpec(name);
        KeyPairGenerator g = KeyPairGenerator.getInstance("ECDH", "BC");
        g.initialize(ecSpec, new SecureRandom());
        KeyPair aKeyPair = g.generateKeyPair();
        KeyAgreement aKeyAgree = KeyAgreement.getInstance("ECDHC", "BC");
        aKeyAgree.init(aKeyPair.getPrivate());
        KeyPair bKeyPair = g.generateKeyPair();
        KeyAgreement bKeyAgree = KeyAgreement.getInstance("ECDHC", "BC");
        bKeyAgree.init(bKeyPair.getPrivate());
        aKeyAgree.doPhase(bKeyPair.getPublic(), true);
        bKeyAgree.doPhase(aKeyPair.getPublic(), true);
        BigInteger k1 = new BigInteger(aKeyAgree.generateSecret());
        BigInteger k2 = new BigInteger(bKeyAgree.generateSecret());
        if (!k1.equals(k2)) {
            this.fail("2-way test failed");
        }
        byte[] pubEnc = aKeyPair.getPublic().getEncoded();
        KeyFactory keyFac = KeyFactory.getInstance("ECDH", "BC");
        ECPublicKey pubKey = (ECPublicKey)keyFac.generatePublic(pubX509 = new X509EncodedKeySpec(pubEnc));
        if (!pubKey.getW().equals(((ECPublicKey)aKeyPair.getPublic()).getW())) {
            this.fail("public key encoding (Q test) failed");
        }
        if (!(pubKey.getParams() instanceof ECNamedCurveSpec)) {
            this.fail("public key encoding not named curve");
        }
        if (!(privKey = (ECPrivateKey)keyFac.generatePrivate(privPKCS8 = new PKCS8EncodedKeySpec(privEnc = aKeyPair.getPrivate().getEncoded()))).getS().equals(((ECPrivateKey)aKeyPair.getPrivate()).getS())) {
            this.fail("private key encoding (S test) failed");
        }
        if (!(privKey.getParams() instanceof ECNamedCurveSpec)) {
            this.fail("private key encoding not named curve");
        }
        if (!(privSpec = (ECNamedCurveSpec)privKey.getParams()).getName().equals(name) && !privSpec.getName().equals(CURVE_NAMES.get(name))) {
            this.fail("private key encoding wrong named curve. Expected: " + CURVE_NAMES.get(name) + " got " + privSpec.getName());
        }
    }

    public void testECDSA(String name) throws Exception {
        ECNamedCurveSpec privSpec;
        byte[] privEnc;
        PKCS8EncodedKeySpec privPKCS8;
        ECPrivateKey privKey;
        X509EncodedKeySpec pubX509;
        ECGenParameterSpec ecSpec = new ECGenParameterSpec(name);
        KeyPairGenerator g = KeyPairGenerator.getInstance("ECDSA", "BC");
        g.initialize(ecSpec, new SecureRandom());
        Signature sgr = Signature.getInstance("ECDSA", "BC");
        KeyPair pair = g.generateKeyPair();
        PrivateKey sKey = pair.getPrivate();
        PublicKey vKey = pair.getPublic();
        sgr.initSign(sKey);
        byte[] message = new byte[]{97, 98, 99};
        sgr.update(message);
        byte[] sigBytes = sgr.sign();
        sgr.initVerify(vKey);
        sgr.update(message);
        if (!sgr.verify(sigBytes)) {
            this.fail(name + " verification failed");
        }
        byte[] pubEnc = vKey.getEncoded();
        KeyFactory keyFac = KeyFactory.getInstance("ECDH", "BC");
        ECPublicKey pubKey = (ECPublicKey)keyFac.generatePublic(pubX509 = new X509EncodedKeySpec(pubEnc));
        if (!pubKey.getW().equals(((ECPublicKey)vKey).getW())) {
            this.fail("public key encoding (Q test) failed");
        }
        if (!(pubKey.getParams() instanceof ECNamedCurveSpec)) {
            this.fail("public key encoding not named curve");
        }
        if (!(privKey = (ECPrivateKey)keyFac.generatePrivate(privPKCS8 = new PKCS8EncodedKeySpec(privEnc = sKey.getEncoded()))).getS().equals(((ECPrivateKey)sKey).getS())) {
            this.fail("private key encoding (S test) failed");
        }
        if (!(privKey.getParams() instanceof ECNamedCurveSpec)) {
            this.fail("private key encoding not named curve");
        }
        if (!(privSpec = (ECNamedCurveSpec)privKey.getParams()).getName().equalsIgnoreCase(name) && !privSpec.getName().equalsIgnoreCase((String)CURVE_ALIASES.get(name))) {
            this.fail("private key encoding wrong named curve. Expected: " + name + " got " + privSpec.getName());
        }
    }

    public void testECGOST(String name) throws Exception {
        ECNamedCurveSpec privSpec;
        byte[] privEnc;
        PKCS8EncodedKeySpec privPKCS8;
        ECPrivateKey privKey;
        X509EncodedKeySpec pubX509;
        ECGenParameterSpec ecSpec = new ECGenParameterSpec(name);
        KeyPairGenerator g = KeyPairGenerator.getInstance("ECGOST3410", "BC");
        g.initialize(ecSpec, new SecureRandom());
        Signature sgr = Signature.getInstance("ECGOST3410", "BC");
        KeyPair pair = g.generateKeyPair();
        PrivateKey sKey = pair.getPrivate();
        PublicKey vKey = pair.getPublic();
        sgr.initSign(sKey);
        byte[] message = new byte[]{97, 98, 99};
        sgr.update(message);
        byte[] sigBytes = sgr.sign();
        sgr.initVerify(vKey);
        sgr.update(message);
        if (!sgr.verify(sigBytes)) {
            this.fail(name + " verification failed");
        }
        byte[] pubEnc = vKey.getEncoded();
        KeyFactory keyFac = KeyFactory.getInstance("ECGOST3410", "BC");
        ECPublicKey pubKey = (ECPublicKey)keyFac.generatePublic(pubX509 = new X509EncodedKeySpec(pubEnc));
        if (!pubKey.getW().equals(((ECPublicKey)vKey).getW())) {
            this.fail("public key encoding (Q test) failed");
        }
        if (!(pubKey.getParams() instanceof ECNamedCurveSpec)) {
            this.fail("public key encoding not named curve");
        }
        if (!(privKey = (ECPrivateKey)keyFac.generatePrivate(privPKCS8 = new PKCS8EncodedKeySpec(privEnc = sKey.getEncoded()))).getS().equals(((ECPrivateKey)sKey).getS())) {
            this.fail("GOST private key encoding (S test) failed");
        }
        if (!(privKey.getParams() instanceof ECNamedCurveSpec)) {
            this.fail("GOST private key encoding not named curve");
        }
        if (!(privSpec = (ECNamedCurveSpec)privKey.getParams()).getName().equalsIgnoreCase(name) && !privSpec.getName().equalsIgnoreCase((String)CURVE_ALIASES.get(name))) {
            this.fail("GOST private key encoding wrong named curve. Expected: " + name + " got " + privSpec.getName());
        }
    }

    @Override
    public String getName() {
        return "NamedCurve";
    }

    @Override
    public void performTest() throws Exception {
        this.testCurve("prime192v1");
        this.testCurve("sect571r1");
        this.testCurve("secp224r1");
        this.testCurve("B-409");
        this.testCurve("P-521");
        this.testCurve("brainpoolp160r1");
        Enumeration en = X962NamedCurves.getNames();
        while (en.hasMoreElements()) {
            this.testECDSA((String)en.nextElement());
        }
        HashSet<String> problemCurves = new HashSet<String>();
        problemCurves.add("secp256k1");
        problemCurves.add("secp160k1");
        problemCurves.add("secp224k1");
        problemCurves.add("secp192k1");
        Enumeration en2 = SECNamedCurves.getNames();
        while (en2.hasMoreElements()) {
            String curveName = (String)en2.nextElement();
            if (problemCurves.contains(curveName)) continue;
            this.testECDSA(curveName);
        }
        en2 = TeleTrusTNamedCurves.getNames();
        while (en2.hasMoreElements()) {
            this.testECDSA((String)en2.nextElement());
        }
        en2 = ECGOST3410NamedCurves.getNames();
        while (en2.hasMoreElements()) {
            this.testECGOST((String)en2.nextElement());
        }
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        NamedCurveTest.runTest(new NamedCurveTest());
    }

    static {
        CURVE_NAMES.put("prime192v1", "prime192v1");
        CURVE_NAMES.put("sect571r1", "sect571r1");
        CURVE_NAMES.put("secp224r1", "secp224r1");
        CURVE_NAMES.put("B-409", SECNamedCurves.getName(NISTNamedCurves.getOID("B-409")));
        CURVE_NAMES.put("P-521", SECNamedCurves.getName(NISTNamedCurves.getOID("P-521")));
        CURVE_NAMES.put("brainpoolp160r1", "brainpoolp160r1");
        CURVE_ALIASES.put("secp192r1", "prime192v1");
        CURVE_ALIASES.put("secp256r1", "prime256v1");
    }
}

