/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.interfaces.GOST3410PrivateKey;
import org.bouncycastle.jce.interfaces.GOST3410PublicKey;
import org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.jce.spec.GOST3410ParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.test.FixedSecureRandom;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class GOST3410Test
extends SimpleTest {
    private void ecGOST3410Test() throws Exception {
        BigInteger[] sig;
        BigInteger r = new BigInteger("29700980915817952874371204983938256990422752107994319651632687982059210933395");
        BigInteger s = new BigInteger("46959264877825372965922731380059061821746083849389763294914877353246631700866");
        byte[] kData = BigIntegers.asUnsignedByteArray(new BigInteger("53854137677348463731403841147996619241504003434302020712960838528893196233395"));
        FixedSecureRandom k = new FixedSecureRandom(kData);
        BigInteger mod_p = new BigInteger("57896044618658097711785492504343953926634992332820282019728792003956564821041");
        ECCurve.Fp curve = new ECCurve.Fp(mod_p, new BigInteger("7"), new BigInteger("43308876546767276905765904595650931995942111794451039583252968842033849580414"));
        ECParameterSpec spec = new ECParameterSpec(curve, new ECPoint.Fp(curve, new ECFieldElement.Fp(mod_p, new BigInteger("2")), new ECFieldElement.Fp(mod_p, new BigInteger("4018974056539037503335449422937059775635739389905545080690979365213431566280"))), new BigInteger("57896044618658097711785492504343953927082934583725450622380973592137631069619"));
        ECPrivateKeySpec priKey = new ECPrivateKeySpec(new BigInteger("55441196065363246126355624130324183196576709222340016572108097750006097525544"), spec);
        ECPublicKeySpec pubKey = new ECPublicKeySpec(new ECPoint.Fp(curve, new ECFieldElement.Fp(mod_p, new BigInteger("57520216126176808443631405023338071176630104906313632182896741342206604859403")), new ECFieldElement.Fp(mod_p, new BigInteger("17614944419213781543809391949654080031942662045363639260709847859438286763994"))), spec);
        Signature sgr = Signature.getInstance("ECGOST3410", "BC");
        KeyFactory f = KeyFactory.getInstance("ECGOST3410", "BC");
        PrivateKey sKey = f.generatePrivate(priKey);
        PublicKey vKey = f.generatePublic(pubKey);
        sgr.initSign(sKey, k);
        byte[] message = new byte[]{97, 98, 99};
        sgr.update(message);
        byte[] sigBytes = sgr.sign();
        sgr.initVerify(vKey);
        sgr.update(message);
        if (!sgr.verify(sigBytes)) {
            this.fail("ECGOST3410 verification failed");
        }
        if (!r.equals((sig = this.decode(sigBytes))[0])) {
            this.fail(": r component wrong." + System.getProperty("line.separator") + " expecting: " + r + System.getProperty("line.separator") + " got      : " + sig[0]);
        }
        if (!s.equals(sig[1])) {
            this.fail(": s component wrong." + System.getProperty("line.separator") + " expecting: " + s + System.getProperty("line.separator") + " got      : " + sig[1]);
        }
    }

    private void generationTest() throws Exception {
        ECPrivateKey eck2;
        ECPublicKey eck1;
        PKCS8EncodedKeySpec pkcs8;
        GOST3410PrivateKey k2;
        X509EncodedKeySpec x509s;
        KeyFactory f;
        GOST3410PublicKey k1;
        Signature s = Signature.getInstance("GOST3410", "BC");
        KeyPairGenerator g = KeyPairGenerator.getInstance("GOST3410", "BC");
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        GOST3410ParameterSpec gost3410P = new GOST3410ParameterSpec(CryptoProObjectIdentifiers.gostR3410_94_CryptoPro_A.getId());
        g.initialize(gost3410P, new SecureRandom());
        KeyPair p = g.generateKeyPair();
        PrivateKey sKey = p.getPrivate();
        PublicKey vKey = p.getPublic();
        s.initSign(sKey);
        s.update(data);
        byte[] sigBytes = s.sign();
        s = Signature.getInstance("GOST3410", "BC");
        s.initVerify(vKey);
        s.update(data);
        if (!s.verify(sigBytes)) {
            this.fail("GOST3410 verification failed");
        }
        s = Signature.getInstance("GOST3410", "BC");
        g = KeyPairGenerator.getInstance("GOST3410", "BC");
        p = g.generateKeyPair();
        sKey = p.getPrivate();
        vKey = p.getPublic();
        s.initSign(sKey);
        s.update(data);
        sigBytes = s.sign();
        s = Signature.getInstance("GOST3410", "BC");
        s.initVerify(vKey);
        s.update(data);
        if (!s.verify(sigBytes)) {
            this.fail("GOST3410 verification failed");
        }
        if (!(k1 = (GOST3410PublicKey)(f = KeyFactory.getInstance("GOST3410", "BC")).generatePublic(x509s = new X509EncodedKeySpec(vKey.getEncoded()))).getY().equals(((GOST3410PublicKey)vKey).getY())) {
            this.fail("public number not decoded properly");
        }
        if (!k1.getParameters().equals(((GOST3410PublicKey)vKey).getParameters())) {
            this.fail("public parameters not decoded properly");
        }
        if (!(k2 = (GOST3410PrivateKey)f.generatePrivate(pkcs8 = new PKCS8EncodedKeySpec(sKey.getEncoded()))).getX().equals(((GOST3410PrivateKey)sKey).getX())) {
            this.fail("private number not decoded properly");
        }
        if (!k2.getParameters().equals(((GOST3410PrivateKey)sKey).getParameters())) {
            this.fail("private number not decoded properly");
        }
        if (!(k2 = (GOST3410PrivateKey)this.serializeDeserialize(sKey)).getX().equals(((GOST3410PrivateKey)sKey).getX())) {
            this.fail("private number not deserialised properly");
        }
        if (!k2.getParameters().equals(((GOST3410PrivateKey)sKey).getParameters())) {
            this.fail("private number not deserialised properly");
        }
        this.checkEquals(k2, sKey);
        if (!(k2 instanceof PKCS12BagAttributeCarrier)) {
            this.fail("private key not implementing PKCS12 attribute carrier");
        }
        if (!(k1 = (GOST3410PublicKey)this.serializeDeserialize(vKey)).getY().equals(((GOST3410PublicKey)vKey).getY())) {
            this.fail("public number not deserialised properly");
        }
        if (!k1.getParameters().equals(((GOST3410PublicKey)vKey).getParameters())) {
            this.fail("public parameters not deserialised properly");
        }
        this.checkEquals(k1, vKey);
        s = Signature.getInstance("ECGOST3410", "BC");
        g = KeyPairGenerator.getInstance("ECGOST3410", "BC");
        g.initialize(new ECNamedCurveGenParameterSpec("GostR3410-2001-CryptoPro-A"), new SecureRandom());
        p = g.generateKeyPair();
        sKey = p.getPrivate();
        vKey = p.getPublic();
        s.initSign(sKey);
        s.update(data);
        sigBytes = s.sign();
        s = Signature.getInstance("ECGOST3410", "BC");
        s.initVerify(vKey);
        s.update(data);
        if (!s.verify(sigBytes)) {
            this.fail("ECGOST3410 verification failed");
        }
        if (!(eck1 = (ECPublicKey)(f = KeyFactory.getInstance("ECGOST3410", "BC")).generatePublic(x509s = new X509EncodedKeySpec(vKey.getEncoded()))).getQ().equals(((ECPublicKey)vKey).getQ())) {
            this.fail("public number not decoded properly");
        }
        if (!eck1.getParameters().equals(((ECPublicKey)vKey).getParameters())) {
            this.fail("public parameters not decoded properly");
        }
        if (!(eck2 = (ECPrivateKey)f.generatePrivate(pkcs8 = new PKCS8EncodedKeySpec(sKey.getEncoded()))).getD().equals(((ECPrivateKey)sKey).getD())) {
            this.fail("private number not decoded properly");
        }
        if (!eck2.getParameters().equals(((ECPrivateKey)sKey).getParameters())) {
            this.fail("private number not decoded properly");
        }
        if (!(eck2 = (ECPrivateKey)this.serializeDeserialize(sKey)).getD().equals(((ECPrivateKey)sKey).getD())) {
            this.fail("private number not decoded properly");
        }
        if (!eck2.getParameters().equals(((ECPrivateKey)sKey).getParameters())) {
            this.fail("private number not decoded properly");
        }
        this.checkEquals(eck2, sKey);
        if (!(eck2 instanceof PKCS12BagAttributeCarrier)) {
            this.fail("private key not implementing PKCS12 attribute carrier");
        }
        if (!(eck1 = (ECPublicKey)this.serializeDeserialize(vKey)).getQ().equals(((ECPublicKey)vKey).getQ())) {
            this.fail("public number not decoded properly");
        }
        if (!eck1.getParameters().equals(((ECPublicKey)vKey).getParameters())) {
            this.fail("public parameters not decoded properly");
        }
        this.checkEquals(eck1, vKey);
    }

    private void keyStoreTest(PrivateKey sKey, PublicKey vKey) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, NoSuchProviderException, SignatureException, InvalidKeyException, UnrecoverableKeyException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.setSerialNumber(BigInteger.valueOf(1L));
        certGen.setIssuerDN(new X509Principal("CN=Test"));
        certGen.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        certGen.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
        certGen.setSubjectDN(new X509Principal("CN=Test"));
        certGen.setPublicKey(vKey);
        certGen.setSignatureAlgorithm("GOST3411withGOST3410");
        X509Certificate cert = certGen.generate(sKey, "BC");
        ks.setKeyEntry("gost", sKey, "gost".toCharArray(), new Certificate[]{cert});
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ks.store(bOut, "gost".toCharArray());
        ks = KeyStore.getInstance("JKS");
        ks.load(new ByteArrayInputStream(bOut.toByteArray()), "gost".toCharArray());
        PrivateKey gKey = (PrivateKey)ks.getKey("gost", "gost".toCharArray());
    }

    private void checkEquals(Object o1, Object o2) {
        if (!o1.equals(o2)) {
            this.fail("comparison test failed");
        }
        if (o1.hashCode() != o2.hashCode()) {
            this.fail("hashCode test failed");
        }
    }

    private void parametersTest() throws Exception {
        GOST3410ParameterSpec gost3410P = new GOST3410ParameterSpec(CryptoProObjectIdentifiers.gostR3410_94_CryptoPro_B.getId());
        KeyPairGenerator g = KeyPairGenerator.getInstance("GOST3410", "BC");
        g.initialize(gost3410P, new SecureRandom());
        KeyPair p = g.generateKeyPair();
        PrivateKey sKey = p.getPrivate();
        PublicKey vKey = p.getPublic();
        Signature s = Signature.getInstance("GOST3410", "BC");
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        s.initSign(sKey);
        s.update(data);
        byte[] sigBytes = s.sign();
        s = Signature.getInstance("GOST3410", "BC");
        s.initVerify(vKey);
        s.update(data);
        if (!s.verify(sigBytes)) {
            this.fail("GOST3410 verification failed");
        }
        this.keyStoreTest(sKey, vKey);
    }

    private BigInteger[] decode(byte[] encoding) {
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        System.arraycopy(encoding, 0, s, 0, 32);
        System.arraycopy(encoding, 32, r, 0, 32);
        BigInteger[] sig = new BigInteger[]{new BigInteger(1, r), new BigInteger(1, s)};
        return sig;
    }

    private Object serializeDeserialize(Object o) throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ObjectOutputStream oOut = new ObjectOutputStream(bOut);
        oOut.writeObject(o);
        oOut.close();
        ObjectInputStream oIn = new ObjectInputStream(new ByteArrayInputStream(bOut.toByteArray()));
        return oIn.readObject();
    }

    @Override
    public String getName() {
        return "GOST3410/ECGOST3410";
    }

    @Override
    public void performTest() throws Exception {
        this.ecGOST3410Test();
        this.generationTest();
        this.parametersTest();
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        GOST3410Test.runTest(new GOST3410Test());
    }
}

