/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.request.impl;

import org.italiangrid.voms.request.VOMSErrorMessage;
import org.italiangrid.voms.request.VOMSResponse;
import org.italiangrid.voms.request.VOMSWarningMessage;
import org.italiangrid.voms.request.impl.GoodACDecodingStrategy;
import org.italiangrid.voms.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RESTVOMSResponse
implements VOMSResponse {
    private static int ERROR_OFFSET = 1000;
    protected Document xmlResponse;

    public RESTVOMSResponse(Document res) {
        this.xmlResponse = res;
    }

    @Override
    public int getVersion() {
        Element versionElement = (Element)this.xmlResponse.getElementsByTagName("version").item(0);
        if (versionElement == null) {
            return 0;
        }
        return Integer.parseInt(versionElement.getFirstChild().getNodeValue());
    }

    @Override
    public boolean hasErrors() {
        return this.xmlResponse.getElementsByTagName("error").getLength() != 0;
    }

    @Override
    public boolean hasWarnings() {
        return this.xmlResponse.getElementsByTagName("warning").getLength() != 0;
    }

    @Override
    public byte[] getAC() {
        Element acElement = (Element)this.xmlResponse.getElementsByTagName("ac").item(0);
        if (acElement == null || !acElement.hasChildNodes()) {
            return null;
        }
        String acString = acElement.getFirstChild().getNodeValue();
        GoodACDecodingStrategy acDecodingStrategy = new GoodACDecodingStrategy();
        byte[] decodedAc = acDecodingStrategy.decode(acString);
        return decodedAc;
    }

    @Override
    public VOMSErrorMessage[] errorMessages() {
        NodeList nodes = this.xmlResponse.getElementsByTagName("error");
        if (nodes.getLength() == 0) {
            return null;
        }
        VOMSErrorMessage[] result = new VOMSErrorMessage[nodes.getLength()];
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element itemElement = (Element)nodes.item(i);
            Element codeElement = (Element)itemElement.getElementsByTagName("code").item(0);
            Element messageElement = (Element)itemElement.getElementsByTagName("message").item(0);
            String strcode = codeElement.getFirstChild().getNodeValue();
            int code = strcode.equals("NoSuchUser") ? 1001 : (strcode.equals("BadRequest") ? 1005 : (strcode.equals("SuspendedUser") ? 1004 : 1006));
            result[i] = new VOMSErrorMessage(code, messageElement.getFirstChild().getNodeValue());
        }
        return result;
    }

    @Override
    public VOMSWarningMessage[] warningMessages() {
        NodeList nodes = this.xmlResponse.getElementsByTagName("warning");
        if (nodes.getLength() == 0) {
            return null;
        }
        VOMSWarningMessage[] result = new VOMSWarningMessage[nodes.getLength()];
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element itemElement = (Element)nodes.item(i);
            String message = itemElement.getFirstChild().getNodeValue();
            int number = message.contains("validity") ? 2 : (message.contains("selected") ? 1 : (message.contains("contains attributes") ? 3 : 4));
            if (number >= ERROR_OFFSET) continue;
            result[i] = new VOMSWarningMessage(number, message);
        }
        return result;
    }

    @Override
    public String getXMLAsString() {
        return XMLUtils.documentAsString(this.xmlResponse);
    }
}

