/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.request.impl;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.italiangrid.voms.request.VOMSACRequest;

public class DefaultVOMSACRequest
implements VOMSACRequest {
    public static final int DEFAULT_LIFETIME = (int)TimeUnit.HOURS.toSeconds(12L);
    private int lifetime;
    private List<String> requestedFQANs;
    private List<String> targets;
    private String voName;

    @Override
    public int getLifetime() {
        return this.lifetime;
    }

    @Override
    public List<String> getRequestedFQANs() {
        return this.requestedFQANs;
    }

    @Override
    public List<String> getTargets() {
        return this.targets;
    }

    @Override
    public String getVoName() {
        return this.voName;
    }

    private DefaultVOMSACRequest(Builder b) {
        this.lifetime = b.lifetime;
        this.voName = b.voName;
        this.targets = b.targets;
        this.requestedFQANs = b.requestedFQANs;
    }

    public static class Builder {
        private int lifetime = DEFAULT_LIFETIME;
        private List<String> requestedFQANs = Collections.emptyList();
        private List<String> targets = Collections.emptyList();
        private String voName;

        public Builder(String voName) {
            this.voName = voName;
        }

        public Builder lifetime(int l) {
            this.lifetime = l;
            return this;
        }

        public Builder fqans(List<String> fqans) {
            if (fqans != null) {
                this.requestedFQANs = fqans;
            }
            return this;
        }

        public Builder targets(List<String> targets) {
            if (targets != null) {
                this.targets = targets;
            }
            return this;
        }

        public DefaultVOMSACRequest build() {
            return new DefaultVOMSACRequest(this);
        }
    }
}

