/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.ac.impl;

import java.security.cert.X509Certificate;
import java.util.List;
import org.italiangrid.voms.VOMSAttribute;
import org.italiangrid.voms.ac.ACParsingContext;
import org.italiangrid.voms.ac.VOMSACLookupStrategy;
import org.italiangrid.voms.ac.VOMSACParser;
import org.italiangrid.voms.ac.VOMSAttributesNormalizationStrategy;
import org.italiangrid.voms.ac.impl.LeafACLookupStrategy;
import org.italiangrid.voms.ac.impl.LeafVOMSExtensionNormalizationStrategy;
import org.italiangrid.voms.util.NullListener;

public class DefaultVOMSACParser
implements VOMSACParser {
    private final VOMSACLookupStrategy acLookupStrategy;
    private final VOMSAttributesNormalizationStrategy acNormalizationStrategy = new LeafVOMSExtensionNormalizationStrategy();

    public DefaultVOMSACParser() {
        this(new LeafACLookupStrategy(NullListener.INSTANCE));
    }

    public DefaultVOMSACParser(VOMSACLookupStrategy strategy) {
        this.acLookupStrategy = strategy;
    }

    @Override
    public List<VOMSAttribute> parse(X509Certificate[] validatedChain) {
        if (validatedChain == null) {
            throw new NullPointerException("Cannot parse a null certchain!");
        }
        List<ACParsingContext> parsedACs = this.acLookupStrategy.lookupVOMSAttributeCertificates(validatedChain);
        return this.acNormalizationStrategy.normalizeAttributes(parsedACs);
    }
}

