/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.ocsp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.ResponseData;
import org.bouncycastle.asn1.ocsp.SingleResponse;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.ocsp.OCSPException;
import org.bouncycastle.ocsp.OCSPUtil;
import org.bouncycastle.ocsp.RespData;
import org.bouncycastle.ocsp.RespID;
import org.bouncycastle.ocsp.SingleResp;

public class BasicOCSPResp
implements X509Extension {
    BasicOCSPResponse resp;
    ResponseData data;
    X509Certificate[] chain = null;

    public BasicOCSPResp(BasicOCSPResponse resp) {
        this.resp = resp;
        this.data = resp.getTbsResponseData();
    }

    public byte[] getTBSResponseData() throws OCSPException {
        try {
            return this.resp.getTbsResponseData().getEncoded();
        }
        catch (IOException e) {
            throw new OCSPException("problem encoding tbsResponseData", e);
        }
    }

    public int getVersion() {
        return this.data.getVersion().getValue().intValue() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.data.getResponderID());
    }

    public Date getProducedAt() {
        try {
            return this.data.getProducedAt().getDate();
        }
        catch (ParseException e) {
            throw new IllegalStateException("ParseException:" + e.getMessage());
        }
    }

    public SingleResp[] getResponses() {
        ASN1Sequence s = this.data.getResponses();
        SingleResp[] rs = new SingleResp[s.size()];
        for (int i = 0; i != rs.length; ++i) {
            rs[i] = new SingleResp(SingleResponse.getInstance(s.getObjectAt(i)));
        }
        return rs;
    }

    public X509Extensions getResponseExtensions() {
        return X509Extensions.getInstance(this.data.getResponseExtensions());
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        Set extns = this.getCriticalExtensionOIDs();
        return extns != null && !extns.isEmpty();
    }

    private Set getExtensionOIDs(boolean critical) {
        HashSet<String> set = new HashSet<String>();
        X509Extensions extensions = this.getResponseExtensions();
        if (extensions != null) {
            Enumeration e = extensions.oids();
            while (e.hasMoreElements()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                org.bouncycastle.asn1.x509.X509Extension ext = extensions.getExtension(oid);
                if (critical != ext.isCritical()) continue;
                set.add(oid.getId());
            }
        }
        return set;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        org.bouncycastle.asn1.x509.X509Extension ext;
        X509Extensions exts = this.getResponseExtensions();
        if (exts != null && (ext = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
            try {
                return ext.getValue().getEncoded("DER");
            }
            catch (Exception e) {
                throw new RuntimeException("error encoding " + e.toString());
            }
        }
        return null;
    }

    public String getSignatureAlgName() {
        return OCSPUtil.getAlgorithmName(this.resp.getSignatureAlgorithm().getObjectId());
    }

    public String getSignatureAlgOID() {
        return this.resp.getSignatureAlgorithm().getObjectId().getId();
    }

    public RespData getResponseData() {
        return new RespData(this.resp.getTbsResponseData());
    }

    public byte[] getSignature() {
        return this.resp.getSignature().getBytes();
    }

    private List getCertList(String provider) throws OCSPException, NoSuchProviderException {
        CertificateFactory cf;
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        try {
            cf = OCSPUtil.createX509CertificateFactory(provider);
        }
        catch (CertificateException ex) {
            throw new OCSPException("can't get certificate factory.", ex);
        }
        ASN1Sequence s = this.resp.getCerts();
        if (s != null) {
            Enumeration e = s.getObjects();
            while (e.hasMoreElements()) {
                try {
                    aOut.writeObject((ASN1Encodable)e.nextElement());
                    certs.add(cf.generateCertificate(new ByteArrayInputStream(bOut.toByteArray())));
                }
                catch (IOException ex) {
                    throw new OCSPException("can't re-encode certificate!", ex);
                }
                catch (CertificateException ex) {
                    throw new OCSPException("can't re-encode certificate!", ex);
                }
                bOut.reset();
            }
        }
        return certs;
    }

    public X509Certificate[] getCerts(String provider) throws OCSPException, NoSuchProviderException {
        List certs = this.getCertList(provider);
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    public CertStore getCertificates(String type, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, OCSPException {
        try {
            CollectionCertStoreParameters params = new CollectionCertStoreParameters(this.getCertList(provider));
            return OCSPUtil.createCertStoreInstance(type, params, provider);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new OCSPException("can't setup the CertStore", e);
        }
    }

    public boolean verify(PublicKey key, String sigProvider) throws OCSPException, NoSuchProviderException {
        try {
            Signature signature = OCSPUtil.createSignatureInstance(this.getSignatureAlgName(), sigProvider);
            signature.initVerify(key);
            signature.update(this.resp.getTbsResponseData().getEncoded("DER"));
            return signature.verify(this.getSignature());
        }
        catch (NoSuchProviderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OCSPException("exception processing sig: " + e, e);
        }
    }

    public byte[] getEncoded() throws IOException {
        return this.resp.getEncoded();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicOCSPResp)) {
            return false;
        }
        BasicOCSPResp r = (BasicOCSPResp)o;
        return this.resp.equals(r.resp);
    }

    public int hashCode() {
        return this.resp.hashCode();
    }
}

