/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.AbstractECMultiplier;
import org.bouncycastle.math.ec.ECPoint;

public class ReferenceMultiplier
extends AbstractECMultiplier {
    @Override
    protected ECPoint multiplyPositive(ECPoint p, BigInteger k) {
        ECPoint q = p.getCurve().getInfinity();
        int t = k.bitLength();
        if (t > 0) {
            if (k.testBit(0)) {
                q = p;
            }
            for (int i = 1; i < t; ++i) {
                p = p.twice();
                if (!k.testBit(i)) continue;
                q = q.add(p);
            }
        }
        return q;
    }
}

