/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.x509.AttributeCertificateHolder;
import org.bouncycastle.x509.AttributeCertificateIssuer;
import org.bouncycastle.x509.X509Attribute;
import org.bouncycastle.x509.X509AttributeCertificate;
import org.bouncycastle.x509.X509V2AttributeCertificate;
import org.bouncycastle.x509.X509V2AttributeCertificateGenerator;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public class AttrCertTest
extends SimpleTest {
    private static final RSAPrivateCrtKeySpec RSA_PRIVATE_KEY_SPEC = new RSAPrivateCrtKeySpec(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16), new BigInteger("9f66f6b05410cd503b2709e88115d55daced94d1a34d4e32bf824d0dde6028ae79c5f07b580f5dce240d7111f7ddb130a7945cd7d957d1920994da389f490c89", 16), new BigInteger("c0a0758cdf14256f78d4708c86becdead1b50ad4ad6c5c703e2168fbf37884cb", 16), new BigInteger("f01734d7960ea60070f1b06f2bb81bfac48ff192ae18451d5e56c734a5aab8a5", 16), new BigInteger("b54bb9edff22051d9ee60f9351a48591b6500a319429c069a3e335a1d6171391", 16), new BigInteger("d3d83daf2a0cecd3367ae6f8ae1aeb82e9ac2f816c6fc483533d8297dd7884cd", 16), new BigInteger("b8f52fc6f38593dabb661d3f50f8897f8106eee68b1bce78a95b132b4e5b5d19", 16));
    public static byte[] attrCert = Base64.decode("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");
    byte[] signCert = Base64.decode("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");
    static byte[] certWithBaseCertificateID = Base64.decode("MIIBqzCCARQCAQEwSKBGMD6kPDA6MQswCQYDVQQGEwJJVDEOMAwGA1UEChMFVU5JVE4xDDAKBgNVBAsTA0RJVDENMAsGA1UEAxMEcm9vdAIEAVMVjqB6MHikdjB0MQswCQYDVQQGEwJBVTEoMCYGA1UEChMfVGhlIExlZ2lvbiBvZiB0aGUgQm91bmN5IENhc3RsZTEjMCEGA1UECxMaQm91bmN5IFByaW1hcnkgQ2VydGlmaWNhdGUxFjAUBgNVBAMTDUJvdW5jeSBDYXN0bGUwDQYJKoZIhvcNAQEFBQACBQKWRhnHMCIYDzIwMDUxMjEyMTIwMDQyWhgPMjAwNTEyMTkxMjAxMzJaMA8wDQYDVRhIMQaBBGVWSVAwDQYJKoZIhvcNAQEFBQADgYEAUAVin9StDaA+InxtXq/av6rUQLI9p1X6louBcj4kYJnxRvTrHpsrN3+i9Uq/uk5lRdAqmPFvcmSbuE3TRAsjrXON5uFiBBKZ1AouLqcr8nHbwcdwjJ9TyUNO9I4hfpSHUHHXMtBKgp4MOkhhX8xTGyWg3hp23d3GaUeg/IYlXBI=");
    byte[] holderCertWithBaseCertificateID = Base64.decode("MIIBwDCCASmgAwIBAgIEAVMVjjANBgkqhkiG9w0BAQUFADA6MQswCQYDVQQGEwJJVDEOMAwGA1UEChMFVU5JVE4xDDAKBgNVBAsTA0RJVDENMAsGA1UEAxMEcm9vdDAeFw0wNTExMTExMjAxMzJaFw0wNjA2MTYxMjAxMzJaMD4xCzAJBgNVBAYTAklUMQ4wDAYDVQQKEwVVTklUTjEMMAoGA1UECxMDRElUMREwDwYDVQQDEwhMdWNhQm9yejBaMA0GCSqGSIb3DQEBAQUAA0kAMEYCQQC0p+RhcFdPFqlwgrIr5YtqKmKXmEGb4ShypL26Ymz66ZAPdqv7EhOdzl3lZWT6srZUMWWgQMYGiHQg4z2R7X7XAgERoxUwEzARBglghkgBhvhCAQEEBAMCBDAwDQYJKoZIhvcNAQEFBQADgYEAsX50VPQQCWmHvPq9y9DeCpmS4szcpFAhpZyn6gYRwY9CRZVtmZKH8713XhkGDWcIEMcG0u3oTz3tdKgPU5uyIPrDEWr6w8ClUj4x5aVz5c2223+dVY7KES//JSB2bE/KCIchN3kAioQ4K8O3e0OL6oDVjsqKGw5bfahgKuSIk/Q=");

    @Override
    public String getName() {
        return "AttrCertTest";
    }

    private void testCertWithBaseCertificateID() throws Exception {
        X509V2AttributeCertificate attrCert = new X509V2AttributeCertificate(certWithBaseCertificateID);
        CertificateFactory fact = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate cert = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(this.holderCertWithBaseCertificateID));
        AttributeCertificateHolder holder = attrCert.getHolder();
        if (holder.getEntityNames() != null) {
            this.fail("entity names set when none expected");
        }
        if (!holder.getSerialNumber().equals(cert.getSerialNumber())) {
            this.fail("holder serial number doesn't match");
        }
        if (!holder.getIssuer()[0].equals(cert.getIssuerX500Principal())) {
            this.fail("holder issuer doesn't match");
        }
        if (!holder.match(cert)) {
            this.fail("holder not matching holder certificate");
        }
        if (!holder.equals(holder.clone())) {
            this.fail("holder clone test failed");
        }
        if (!attrCert.getIssuer().equals(attrCert.getIssuer().clone())) {
            this.fail("issuer clone test failed");
        }
    }

    private void equalityAndHashCodeTest(X509AttributeCertificate attrCert, byte[] encoding) throws IOException {
        X509V2AttributeCertificate attrCert2;
        if (!attrCert.equals(attrCert)) {
            this.fail("same certificate not equal");
        }
        if (!attrCert.getHolder().equals(attrCert.getHolder())) {
            this.fail("same holder not equal");
        }
        if (!attrCert.getIssuer().equals(attrCert.getIssuer())) {
            this.fail("same issuer not equal");
        }
        if (attrCert.getHolder().equals(attrCert.getIssuer())) {
            this.fail("wrong holder equal");
        }
        if (attrCert.getIssuer().equals(attrCert.getHolder())) {
            this.fail("wrong issuer equal");
        }
        if ((attrCert2 = new X509V2AttributeCertificate(encoding)).getHolder().hashCode() != attrCert.getHolder().hashCode()) {
            this.fail("holder hashCode test failed");
        }
        if (!attrCert2.getHolder().equals(attrCert.getHolder())) {
            this.fail("holder equals test failed");
        }
        if (attrCert2.getIssuer().hashCode() != attrCert.getIssuer().hashCode()) {
            this.fail("issuer hashCode test failed");
        }
        if (!attrCert2.getIssuer().equals(attrCert.getIssuer())) {
            this.fail("issuer equals test failed");
        }
    }

    private void testGenerateWithCert() throws Exception {
        X509Certificate sCert;
        ASN1Encodable[] values;
        GeneralName role;
        X509Attribute attr;
        X509Attribute[] attrs;
        CertificateFactory fact = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate iCert = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(this.signCert));
        RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16));
        KeyFactory kFact = KeyFactory.getInstance("RSA", "BC");
        PrivateKey privKey = kFact.generatePrivate(RSA_PRIVATE_KEY_SPEC);
        PublicKey pubKey = kFact.generatePublic(pubKeySpec);
        X509V2AttributeCertificateGenerator gen = new X509V2AttributeCertificateGenerator();
        GeneralName roleName = new GeneralName(1, "DAU123456789");
        ASN1EncodableVector roleSyntax = new ASN1EncodableVector();
        roleSyntax.add(roleName);
        X509Attribute attributes = new X509Attribute("2.5.24.72", new DERSequence(roleSyntax));
        gen.addAttribute(attributes);
        gen.setHolder(new AttributeCertificateHolder(iCert));
        gen.setIssuer(new AttributeCertificateIssuer(new X509Principal("cn=test")));
        gen.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        gen.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
        gen.setSerialNumber(BigInteger.ONE);
        gen.setSignatureAlgorithm("SHA1WithRSAEncryption");
        X509AttributeCertificate aCert = gen.generate(privKey, "BC");
        aCert.checkValidity();
        aCert.verify(pubKey, "BC");
        AttributeCertificateHolder holder = aCert.getHolder();
        if (holder.getEntityNames() != null) {
            this.fail("entity names set when none expected");
        }
        if (!holder.getSerialNumber().equals(iCert.getSerialNumber())) {
            this.fail("holder serial number doesn't match");
        }
        if (!holder.getIssuer()[0].equals(iCert.getIssuerX500Principal())) {
            this.fail("holder issuer doesn't match");
        }
        if (!holder.match(iCert)) {
            this.fail("generated holder not matching holder certificate");
        }
        if ((attrs = aCert.getAttributes("2.5.24.72")) == null) {
            this.fail("attributes related to 2.5.24.72 not found");
        }
        if (!(attr = attrs[0]).getOID().equals("2.5.24.72")) {
            this.fail("attribute oid mismatch");
        }
        if ((role = GeneralNames.getInstance((values = attr.getValues())[0]).getNames()[0]).getTagNo() != 1) {
            this.fail("wrong general name type found in role");
        }
        if (!((ASN1String)((Object)role.getName())).getString().equals("DAU123456789")) {
            this.fail("wrong general name value found in role");
        }
        if (holder.match(sCert = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(this.holderCertWithBaseCertificateID)))) {
            this.fail("generated holder matching wrong certificate");
        }
        this.equalityAndHashCodeTest(aCert, aCert.getEncoded());
    }

    private void testGenerateWithPrincipal() throws Exception {
        X509Certificate sCert;
        CertificateFactory fact = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate iCert = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(this.signCert));
        RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16));
        KeyFactory kFact = KeyFactory.getInstance("RSA", "BC");
        PrivateKey privKey = kFact.generatePrivate(RSA_PRIVATE_KEY_SPEC);
        PublicKey pubKey = kFact.generatePublic(pubKeySpec);
        X509V2AttributeCertificateGenerator gen = new X509V2AttributeCertificateGenerator();
        GeneralName roleName = new GeneralName(1, "DAU123456789");
        ASN1EncodableVector roleSyntax = new ASN1EncodableVector();
        roleSyntax.add(roleName);
        X509Attribute attributes = new X509Attribute("2.5.24.72", new DERSequence(roleSyntax));
        gen.addAttribute(attributes);
        gen.setHolder(new AttributeCertificateHolder(iCert.getSubjectX500Principal()));
        gen.setIssuer(new AttributeCertificateIssuer(new X509Principal("cn=test")));
        gen.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        gen.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
        gen.setSerialNumber(BigInteger.ONE);
        gen.setSignatureAlgorithm("SHA1WithRSAEncryption");
        X509AttributeCertificate aCert = gen.generate(privKey, "BC");
        aCert.checkValidity();
        aCert.verify(pubKey, "BC");
        AttributeCertificateHolder holder = aCert.getHolder();
        if (holder.getEntityNames() == null) {
            this.fail("entity names not set when expected");
        }
        if (holder.getSerialNumber() != null) {
            this.fail("holder serial number found when none expected");
        }
        if (holder.getIssuer() != null) {
            this.fail("holder issuer found when none expected");
        }
        if (!holder.match(iCert)) {
            this.fail("generated holder not matching holder certificate");
        }
        if (holder.match(sCert = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(this.holderCertWithBaseCertificateID)))) {
            this.fail("principal generated holder matching wrong certificate");
        }
        this.equalityAndHashCodeTest(aCert, aCert.getEncoded());
    }

    @Override
    public void performTest() throws Exception {
        byte[] extString;
        ASN1Primitive extValue;
        X509Attribute[] attrs;
        X509AttributeCertificate aCert = new X509V2AttributeCertificate(attrCert);
        CertificateFactory fact = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate sCert = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(this.signCert));
        aCert.verify(sCert.getPublicKey(), "BC");
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        list.add(sCert);
        CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(list);
        CertStore store = CertStore.getInstance("Collection", ccsp);
        Collection<? extends Certificate> certs = store.getCertificates(aCert.getIssuer());
        if (certs.size() != 1 || !certs.contains(sCert)) {
            this.fail("sCert not found by issuer");
        }
        if ((attrs = aCert.getAttributes("1.3.6.1.4.1.6760.8.1.1")) == null || attrs.length != 1) {
            this.fail("attribute not found");
        }
        aCert = new X509V2AttributeCertificate(aCert.getEncoded());
        aCert.verify(sCert.getPublicKey(), "BC");
        X509V2AttributeCertificate saCert = new X509V2AttributeCertificate(new ByteArrayInputStream(aCert.getEncoded()));
        if (!aCert.getNotAfter().equals(saCert.getNotAfter())) {
            this.fail("failed date comparison");
        }
        RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16));
        RSAPrivateCrtKeySpec privKeySpec = RSA_PRIVATE_KEY_SPEC;
        KeyFactory kFact = KeyFactory.getInstance("RSA", "BC");
        PrivateKey privKey = kFact.generatePrivate(privKeySpec);
        PublicKey pubKey = kFact.generatePublic(pubKeySpec);
        X509V2AttributeCertificateGenerator gen = new X509V2AttributeCertificateGenerator();
        gen.addAttribute(attrs[0]);
        gen.setHolder(aCert.getHolder());
        gen.setIssuer(aCert.getIssuer());
        gen.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        gen.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
        gen.setSerialNumber(aCert.getSerialNumber());
        gen.setSignatureAlgorithm("SHA1WithRSAEncryption");
        aCert = gen.generate(privKey, "BC");
        aCert.checkValidity();
        aCert.verify(pubKey, "BC");
        certs = store.getCertificates(aCert.getIssuer());
        if (certs.size() != 1 || !certs.contains(sCert)) {
            this.fail("sCert not found by issuer");
        }
        if ((attrs = aCert.getAttributes("1.3.6.1.4.1.6760.8.1.1")) == null || attrs.length != 1) {
            this.fail("attribute not found");
        }
        aCert = new X509V2AttributeCertificate(aCert.getEncoded());
        aCert.verify(pubKey, "BC");
        AttributeCertificateIssuer issuer = aCert.getIssuer();
        Principal[] principals = issuer.getPrincipals();
        AttributeCertificateHolder holder = aCert.getHolder();
        if (holder.getEntityNames() == null) {
            this.fail("entity names not set");
        }
        if (holder.getSerialNumber() != null) {
            this.fail("holder serial number set when none expected");
        }
        if (holder.getIssuer() != null) {
            this.fail("holder issuer set when none expected");
        }
        if (!(principals = holder.getEntityNames())[0].toString().equals("C=US, O=vt, OU=Class 2, OU=Virginia Tech User, CN=Markus Lorch (mlorch), EMAILADDRESS=mlorch@vt.edu")) {
            this.fail("principal[0] for entity names don't match");
        }
        if (aCert.hasUnsupportedCriticalExtension()) {
            this.fail("unsupported extensions found with no extensions");
        }
        gen.addExtension("1.1", true, new DEROctetString(new byte[10]));
        gen.addExtension("2.2", false, new DEROctetString(new byte[20]));
        aCert = gen.generate(privKey, "BC");
        Set<String> exts = aCert.getCriticalExtensionOIDs();
        if (exts.size() != 1 || !exts.contains("1.1")) {
            this.fail("critical extension test failed");
        }
        if ((exts = aCert.getNonCriticalExtensionOIDs()).size() != 1 || !exts.contains("2.2")) {
            this.fail("non-critical extension test failed");
        }
        if (!aCert.hasUnsupportedCriticalExtension()) {
            this.fail("unsupported extensions not found");
        }
        if (!((Object)(extValue = X509ExtensionUtil.fromExtensionValue(extString = aCert.getExtensionValue("1.1")))).equals(new DEROctetString(new byte[10]))) {
            this.fail("wrong extension value found for 1.1");
        }
        this.testCertWithBaseCertificateID();
        this.testGenerateWithCert();
        this.testGenerateWithPrincipal();
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        AttrCertTest.runTest(new AttrCertTest());
    }
}

