/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.PackerImpl;
import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.TLGlobals;
import com.sun.java.util.jar.pack.UnpackerImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import sun.util.logging.PlatformLogger;

class Utils {
    static final String COM_PREFIX = "com.sun.java.util.jar.pack.";
    static final String METAINF = "META-INF";
    static final String DEBUG_VERBOSE = "com.sun.java.util.jar.pack.verbose";
    static final String DEBUG_DISABLE_NATIVE = "com.sun.java.util.jar.pack.disable.native";
    static final String PACK_DEFAULT_TIMEZONE = "com.sun.java.util.jar.pack.default.timezone";
    static final String UNPACK_MODIFICATION_TIME = "com.sun.java.util.jar.pack.unpack.modification.time";
    static final String UNPACK_STRIP_DEBUG = "com.sun.java.util.jar.pack.unpack.strip.debug";
    static final String UNPACK_REMOVE_PACKFILE = "com.sun.java.util.jar.pack.unpack.remove.packfile";
    static final String NOW = "now";
    static final String PACK_KEEP_CLASS_ORDER = "com.sun.java.util.jar.pack.keep.class.order";
    static final String PACK_ZIP_ARCHIVE_MARKER_COMMENT = "PACK200";
    static final String CLASS_FORMAT_ERROR = "com.sun.java.util.jar.pack.class.format.error";
    static final ThreadLocal<TLGlobals> currentInstance = new ThreadLocal();
    private static TimeZone tz;
    private static int workingPackerCount;
    static final boolean nolog;
    static final boolean SORT_MEMBERS_DESCR_MAJOR;
    static final boolean SORT_HANDLES_KIND_MAJOR;
    static final boolean SORT_INDY_BSS_MAJOR;
    static final boolean SORT_BSS_BSM_MAJOR;
    static final Pack200Logger log;

    static TLGlobals getTLGlobals() {
        return currentInstance.get();
    }

    static PropMap currentPropMap() {
        TLGlobals obj = currentInstance.get();
        if (obj instanceof PackerImpl) {
            return ((PackerImpl)obj).props;
        }
        if (obj instanceof UnpackerImpl) {
            return ((UnpackerImpl)obj).props;
        }
        return null;
    }

    static synchronized void changeDefaultTimeZoneToUtc() {
        if (workingPackerCount++ == 0) {
            tz = TimeZone.getDefault();
            TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        }
    }

    static synchronized void restoreDefaultTimeZone() {
        if (--workingPackerCount == 0) {
            if (tz != null) {
                TimeZone.setDefault(tz);
            }
            tz = null;
        }
    }

    static String getVersionString() {
        return "Pack200, Vendor: " + System.getProperty("java.vendor") + ", Version: " + Constants.MAX_PACKAGE_VERSION;
    }

    static void markJarFile(JarOutputStream out) throws IOException {
        out.setComment(PACK_ZIP_ARCHIVE_MARKER_COMMENT);
    }

    static void copyJarFile(JarInputStream in, JarOutputStream out) throws IOException {
        JarEntry je;
        if (in.getManifest() != null) {
            ZipEntry me = new ZipEntry("META-INF/MANIFEST.MF");
            out.putNextEntry(me);
            in.getManifest().write(out);
            out.closeEntry();
        }
        byte[] buffer = new byte[16384];
        while ((je = in.getNextJarEntry()) != null) {
            int nr;
            out.putNextEntry(je);
            while (0 < (nr = in.read(buffer))) {
                out.write(buffer, 0, nr);
            }
        }
        in.close();
        Utils.markJarFile(out);
    }

    static void copyJarFile(JarFile in, JarOutputStream out) throws IOException {
        byte[] buffer = new byte[16384];
        for (JarEntry je : Collections.list(in.entries())) {
            int nr;
            out.putNextEntry(je);
            InputStream ein = in.getInputStream(je);
            while (0 < (nr = ein.read(buffer))) {
                out.write(buffer, 0, nr);
            }
        }
        in.close();
        Utils.markJarFile(out);
    }

    static void copyJarFile(JarInputStream in, OutputStream out) throws IOException {
        out = new BufferedOutputStream(out);
        out = new NonCloser(out);
        try (JarOutputStream jout = new JarOutputStream(out);){
            Utils.copyJarFile(in, jout);
        }
    }

    static void copyJarFile(JarFile in, OutputStream out) throws IOException {
        out = new BufferedOutputStream(out);
        out = new NonCloser(out);
        try (JarOutputStream jout = new JarOutputStream(out);){
            Utils.copyJarFile(in, jout);
        }
    }

    static String getJarEntryName(String name) {
        if (name == null) {
            return null;
        }
        return name.replace(File.separatorChar, '/');
    }

    static String zeString(ZipEntry ze) {
        int store = ze.getCompressedSize() > 0L ? (int)((1.0 - (double)ze.getCompressedSize() / (double)ze.getSize()) * 100.0) : 0;
        return ze.getSize() + "\t" + ze.getMethod() + "\t" + ze.getCompressedSize() + "\t" + store + "%\t" + new Date(ze.getTime()) + "\t" + Long.toHexString(ze.getCrc()) + "\t" + ze.getName();
    }

    static byte[] readMagic(BufferedInputStream in) throws IOException {
        in.mark(4);
        byte[] magic = new byte[4];
        for (int i = 0; i < magic.length && 1 == in.read(magic, i, 1); ++i) {
        }
        in.reset();
        return magic;
    }

    static boolean isJarMagic(byte[] magic) {
        return magic[0] == 80 && magic[1] == 75 && magic[2] >= 1 && magic[2] < 8 && magic[3] == magic[2] + 1;
    }

    static boolean isPackMagic(byte[] magic) {
        return magic[0] == -54 && magic[1] == -2 && magic[2] == -48 && magic[3] == 13;
    }

    static boolean isGZIPMagic(byte[] magic) {
        return magic[0] == 31 && magic[1] == -117 && magic[2] == 8;
    }

    private Utils() {
    }

    static {
        workingPackerCount = 0;
        nolog = Boolean.getBoolean("com.sun.java.util.jar.pack.nolog");
        SORT_MEMBERS_DESCR_MAJOR = Boolean.getBoolean("com.sun.java.util.jar.pack.sort.members.descr.major");
        SORT_HANDLES_KIND_MAJOR = Boolean.getBoolean("com.sun.java.util.jar.pack.sort.handles.kind.major");
        SORT_INDY_BSS_MAJOR = Boolean.getBoolean("com.sun.java.util.jar.pack.sort.indy.bss.major");
        SORT_BSS_BSM_MAJOR = Boolean.getBoolean("com.sun.java.util.jar.pack.sort.bss.bsm.major");
        log = new Pack200Logger("java.util.jar.Pack200");
    }

    private static class NonCloser
    extends FilterOutputStream {
        NonCloser(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }

    static class Pack200Logger {
        private final String name;
        private PlatformLogger log;

        Pack200Logger(String name) {
            this.name = name;
        }

        private synchronized PlatformLogger getLogger() {
            if (this.log == null) {
                this.log = PlatformLogger.getLogger(this.name);
            }
            return this.log;
        }

        public void warning(String msg, Object param) {
            this.getLogger().warning(msg, param);
        }

        public void warning(String msg) {
            this.warning(msg, null);
        }

        public void info(String msg) {
            int verbose = Utils.currentPropMap().getInteger(Utils.DEBUG_VERBOSE);
            if (verbose > 0) {
                if (nolog) {
                    System.out.println(msg);
                } else {
                    this.getLogger().info(msg);
                }
            }
        }

        public void fine(String msg) {
            int verbose = Utils.currentPropMap().getInteger(Utils.DEBUG_VERBOSE);
            if (verbose > 0) {
                System.out.println(msg);
            }
        }
    }
}

