/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import sun.misc.FloatingDecimal;

public final class Float
extends Number
implements Comparable<Float> {
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_NORMAL = 1.1754944E-38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final int MAX_EXPONENT = 127;
    public static final int MIN_EXPONENT = -126;
    public static final int SIZE = 32;
    public static final int BYTES = 4;
    public static final Class<Float> TYPE = Class.getPrimitiveClass("float");
    private final float value;
    private static final long serialVersionUID = -2671257302660747028L;

    public static String toString(float f) {
        return FloatingDecimal.toJavaFormatString(f);
    }

    public static String toHexString(float f) {
        if (Math.abs(f) < Float.MIN_NORMAL && f != 0.0f) {
            String s = Double.toHexString(Math.scalb((double)f, -896));
            return s.replaceFirst("p-1022$", "p-126");
        }
        return Double.toHexString(f);
    }

    public static Float valueOf(String s) throws NumberFormatException {
        return new Float(Float.parseFloat(s));
    }

    public static Float valueOf(float f) {
        return new Float(f);
    }

    public static float parseFloat(String s) throws NumberFormatException {
        return FloatingDecimal.parseFloat(s);
    }

    public static boolean isNaN(float v) {
        return v != v;
    }

    public static boolean isInfinite(float v) {
        return v == Float.POSITIVE_INFINITY || v == Float.NEGATIVE_INFINITY;
    }

    public static boolean isFinite(float f) {
        return Math.abs(f) <= Float.MAX_VALUE;
    }

    public Float(float value) {
        this.value = value;
    }

    public Float(double value) {
        this.value = (float)value;
    }

    public Float(String s) throws NumberFormatException {
        this.value = Float.parseFloat(s);
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public String toString() {
        return Float.toString(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Float.hashCode(this.value);
    }

    public static int hashCode(float value) {
        return Float.floatToIntBits(value);
    }

    public boolean equals(Object obj) {
        return obj instanceof Float && Float.floatToIntBits(((Float)obj).value) == Float.floatToIntBits(this.value);
    }

    public static int floatToIntBits(float value) {
        int result = Float.floatToRawIntBits(value);
        if ((result & 0x7F800000) == 2139095040 && (result & 0x7FFFFF) != 0) {
            result = 2143289344;
        }
        return result;
    }

    public static native int floatToRawIntBits(float var0);

    public static native float intBitsToFloat(int var0);

    @Override
    public int compareTo(Float anotherFloat) {
        return Float.compare(this.value, anotherFloat.value);
    }

    public static int compare(float f1, float f2) {
        int anotherBits;
        if (f1 < f2) {
            return -1;
        }
        if (f1 > f2) {
            return 1;
        }
        int thisBits = Float.floatToIntBits(f1);
        return thisBits == (anotherBits = Float.floatToIntBits(f2)) ? 0 : (thisBits < anotherBits ? -1 : 1);
    }

    public static float sum(float a, float b) {
        return a + b;
    }

    public static float max(float a, float b) {
        return Math.max(a, b);
    }

    public static float min(float a, float b) {
        return Math.min(a, b);
    }
}

