/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.proxy;

public class IPAddressHelper {
    private static final int IPv4_FULL_MASK = 32;
    private static final int IPv6_FULL_MASK = 128;
    private static final int IPv6_HALF_MASK = 64;

    public static boolean isWithinAddressSpace(byte[] ipBytes, byte[] ipAddressWithNetmask) {
        if (!(ipAddressWithNetmask.length == 8 && ipBytes.length == 4 || ipAddressWithNetmask.length == 32 && ipBytes.length == 16)) {
            throw new IllegalArgumentException("IP address and IP address-netmask length mismatch, should be either (4 and 8) or (16 and 32), actual lengths were: " + ipBytes.length + " and " + ipAddressWithNetmask.length + ".");
        }
        if (ipBytes.length == 4) {
            int netAsInt;
            int mask = IPAddressHelper.getCidrNetmask(4, ipAddressWithNetmask, 4);
            int ipAsInt = IPAddressHelper.getInt(ipBytes, 0);
            return (ipAsInt ^ (netAsInt = IPAddressHelper.getInt(ipAddressWithNetmask, 0))) >> 32 - mask == 0;
        }
        long ipAsLong0 = IPAddressHelper.getLong(ipBytes, 0);
        long netAsLong0 = IPAddressHelper.getLong(ipAddressWithNetmask, 0);
        int mask = IPAddressHelper.getCidrNetmask(16, ipAddressWithNetmask, 16);
        if (mask > 64) {
            long ipAsLong1 = IPAddressHelper.getLong(ipBytes, 8);
            long netAsLong1 = IPAddressHelper.getLong(ipAddressWithNetmask, 8);
            return ipAsLong0 == netAsLong0 & (ipAsLong1 ^ netAsLong1) >> 128 - mask == 0L;
        }
        return (ipAsLong0 ^ netAsLong0) >> 64 - mask == 0L;
    }

    private static long getLong(byte[] bytes, int offset) {
        return ((long)bytes[offset] & 0xFFL) << 56 | ((long)bytes[offset + 1] & 0xFFL) << 48 | ((long)bytes[offset + 2] & 0xFFL) << 40 | ((long)bytes[offset + 3] & 0xFFL) << 32 | ((long)bytes[offset + 4] & 0xFFL) << 24 | ((long)bytes[offset + 5] & 0xFFL) << 16 | ((long)bytes[offset + 6] & 0xFFL) << 8 | (long)bytes[offset + 7] & 0xFFL;
    }

    private static int getInt(byte[] bytes, int offset) {
        return (bytes[offset + 0] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    private static int getCidrNetmask(int size, byte[] netmask, int offset) {
        int ret = 0;
        for (int i = 0; i < size; ++i) {
            if (netmask[i + offset] != -1) {
                int maskByteReversed = ~netmask[i + offset] & 0xFF;
                int bitPfx = Integer.numberOfLeadingZeros(maskByteReversed) - 24;
                return ret + bitPfx;
            }
            ret += 8;
        }
        return ret;
    }
}

