/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerCloneException;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.server.UnicastServerRef2;
import sun.rmi.transport.ObjectTable;

public class UnicastRemoteObject
extends RemoteServer {
    private int port = 0;
    private RMIClientSocketFactory csf = null;
    private RMIServerSocketFactory ssf = null;
    private static final long serialVersionUID = 4974527148936298033L;

    protected UnicastRemoteObject() throws RemoteException {
        this(0);
    }

    protected UnicastRemoteObject(int port) throws RemoteException {
        this.port = port;
        UnicastRemoteObject.exportObject((Remote)this, port);
    }

    protected UnicastRemoteObject(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        this.port = port;
        this.csf = csf;
        this.ssf = ssf;
        UnicastRemoteObject.exportObject(this, port, csf, ssf);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.reexport();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            UnicastRemoteObject cloned = (UnicastRemoteObject)super.clone();
            cloned.reexport();
            return cloned;
        }
        catch (RemoteException e) {
            throw new ServerCloneException("Clone failed", e);
        }
    }

    private void reexport() throws RemoteException {
        if (this.csf == null && this.ssf == null) {
            UnicastRemoteObject.exportObject((Remote)this, this.port);
        } else {
            UnicastRemoteObject.exportObject(this, this.port, this.csf, this.ssf);
        }
    }

    @Deprecated
    public static RemoteStub exportObject(Remote obj) throws RemoteException {
        return (RemoteStub)UnicastRemoteObject.exportObject(obj, new UnicastServerRef(true));
    }

    public static Remote exportObject(Remote obj, int port) throws RemoteException {
        return UnicastRemoteObject.exportObject(obj, new UnicastServerRef(port));
    }

    public static Remote exportObject(Remote obj, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        return UnicastRemoteObject.exportObject(obj, new UnicastServerRef2(port, csf, ssf));
    }

    public static boolean unexportObject(Remote obj, boolean force) throws NoSuchObjectException {
        return ObjectTable.unexportObject(obj, force);
    }

    private static Remote exportObject(Remote obj, UnicastServerRef sref) throws RemoteException {
        if (obj instanceof UnicastRemoteObject) {
            ((UnicastRemoteObject)obj).ref = sref;
        }
        return sref.exportObject(obj, null, false);
    }
}

