/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.GlyphJustificationInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public abstract class GraphicAttribute {
    private int fAlignment;
    public static final int TOP_ALIGNMENT = -1;
    public static final int BOTTOM_ALIGNMENT = -2;
    public static final int ROMAN_BASELINE = 0;
    public static final int CENTER_BASELINE = 1;
    public static final int HANGING_BASELINE = 2;

    protected GraphicAttribute(int alignment) {
        if (alignment < -2 || alignment > 2) {
            throw new IllegalArgumentException("bad alignment");
        }
        this.fAlignment = alignment;
    }

    public abstract float getAscent();

    public abstract float getDescent();

    public abstract float getAdvance();

    public Rectangle2D getBounds() {
        float ascent = this.getAscent();
        return new Rectangle2D.Float(0.0f, -ascent, this.getAdvance(), ascent + this.getDescent());
    }

    public Shape getOutline(AffineTransform tx) {
        Shape b = this.getBounds();
        if (tx != null) {
            b = tx.createTransformedShape(b);
        }
        return b;
    }

    public abstract void draw(Graphics2D var1, float var2, float var3);

    public final int getAlignment() {
        return this.fAlignment;
    }

    public GlyphJustificationInfo getJustificationInfo() {
        float advance = this.getAdvance();
        return new GlyphJustificationInfo(advance, false, 2, advance / 3.0f, advance / 3.0f, false, 1, 0.0f, 0.0f);
    }
}

