/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.clients.impl;

import eu.emi.security.authn.x509.X509Credential;
import org.bouncycastle.openssl.PasswordFinder;
import org.italiangrid.voms.credential.LoadCredentialsEventListener;
import org.italiangrid.voms.credential.impl.AbstractLoadCredentialsStrategy;

public class LoadUserCredential
extends AbstractLoadCredentialsStrategy {
    String certFile;
    String keyFile;
    String pkcs12File;

    public LoadUserCredential(LoadCredentialsEventListener listener, String certFile, String keyFile) {
        super(listener);
        this.certFile = certFile;
        this.keyFile = keyFile;
    }

    public LoadUserCredential(LoadCredentialsEventListener listener, String pkcs12File) {
        super(listener);
        this.pkcs12File = pkcs12File;
    }

    public X509Credential loadCredentials(PasswordFinder passwordFinder) {
        if (this.pkcs12File != null) {
            return this.loadPKCS12Credential(this.pkcs12File, passwordFinder);
        }
        if (this.certFile != null && this.keyFile != null) {
            return this.loadPEMCredential(this.keyFile, this.certFile, passwordFinder);
        }
        return null;
    }
}

