/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.clients.impl;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.ValidationErrorListener;
import eu.emi.security.authn.x509.ValidationResult;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.helpers.proxy.ExtendedProxyType;
import eu.emi.security.authn.x509.helpers.proxy.ProxyHelper;
import eu.emi.security.authn.x509.proxy.ProxyCertificate;
import eu.emi.security.authn.x509.proxy.ProxyCertificateOptions;
import eu.emi.security.authn.x509.proxy.ProxyChainInfo;
import eu.emi.security.authn.x509.proxy.ProxyChainType;
import eu.emi.security.authn.x509.proxy.ProxyGenerator;
import eu.emi.security.authn.x509.proxy.ProxyPolicy;
import eu.emi.security.authn.x509.proxy.ProxyType;
import eu.emi.security.authn.x509.proxy.ProxyUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.openssl.PasswordFinder;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.VOMSValidators;
import org.italiangrid.voms.ac.VOMSACValidator;
import org.italiangrid.voms.ac.ValidationResultListener;
import org.italiangrid.voms.clients.ProxyInitParams;
import org.italiangrid.voms.clients.impl.InitListenerAdapter;
import org.italiangrid.voms.clients.impl.LoadProxyCredential;
import org.italiangrid.voms.clients.impl.LoadUserCredential;
import org.italiangrid.voms.clients.impl.ProxyCreationListener;
import org.italiangrid.voms.clients.strategies.ProxyInitStrategy;
import org.italiangrid.voms.clients.strategies.VOMSCommandsParsingStrategy;
import org.italiangrid.voms.clients.util.PasswordFinders;
import org.italiangrid.voms.clients.util.VOMSProxyPathBuilder;
import org.italiangrid.voms.credential.LoadCredentialsEventListener;
import org.italiangrid.voms.credential.LoadCredentialsStrategy;
import org.italiangrid.voms.credential.impl.DefaultLoadCredentialsStrategy;
import org.italiangrid.voms.request.VOMSACRequest;
import org.italiangrid.voms.request.VOMSESLookupStrategy;
import org.italiangrid.voms.request.VOMSProtocolListener;
import org.italiangrid.voms.request.VOMSRequestListener;
import org.italiangrid.voms.request.VOMSServerInfoStore;
import org.italiangrid.voms.request.VOMSServerInfoStoreListener;
import org.italiangrid.voms.request.impl.BaseVOMSESLookupStrategy;
import org.italiangrid.voms.request.impl.DefaultVOMSACRequest;
import org.italiangrid.voms.request.impl.DefaultVOMSACService;
import org.italiangrid.voms.request.impl.DefaultVOMSESLookupStrategy;
import org.italiangrid.voms.request.impl.DefaultVOMSServerInfoStore;
import org.italiangrid.voms.store.VOMSTrustStore;
import org.italiangrid.voms.store.VOMSTrustStoreStatusListener;
import org.italiangrid.voms.store.impl.DefaultVOMSTrustStore;
import org.italiangrid.voms.util.CertificateValidatorBuilder;
import org.italiangrid.voms.util.CredentialsUtils;
import org.italiangrid.voms.util.VOMSFQANNamingScheme;

public class DefaultVOMSProxyInitBehaviour
implements ProxyInitStrategy {
    private VOMSCommandsParsingStrategy commandsParser;
    private X509CertChainValidatorExt certChainValidator;
    private VOMSACValidator vomsValidator;
    private ValidationResultListener validationResultListener;
    private VOMSRequestListener requestListener;
    private ProxyCreationListener proxyCreationListener;
    private VOMSServerInfoStoreListener serverInfoStoreListener;
    private LoadCredentialsEventListener loadCredentialsEventListener;
    private ValidationErrorListener certChainValidationErrorListener;
    private VOMSTrustStoreStatusListener vomsTrustStoreListener;
    private StoreUpdateListener storeUpdateListener;
    private VOMSProtocolListener protocolListener;

    public DefaultVOMSProxyInitBehaviour(VOMSCommandsParsingStrategy commandsParser, ValidationResultListener validationListener, VOMSRequestListener requestListener, ProxyCreationListener pxCreationListener, VOMSServerInfoStoreListener serverInfoStoreListener, LoadCredentialsEventListener loadCredEventListener, ValidationErrorListener certChainListener, VOMSTrustStoreStatusListener vomsTSListener, StoreUpdateListener trustStoreUpdateListener, VOMSProtocolListener protocolListener) {
        this.commandsParser = commandsParser;
        this.validationResultListener = validationListener;
        this.requestListener = requestListener;
        this.proxyCreationListener = pxCreationListener;
        this.serverInfoStoreListener = serverInfoStoreListener;
        this.loadCredentialsEventListener = loadCredEventListener;
        this.certChainValidationErrorListener = certChainListener;
        this.vomsTrustStoreListener = vomsTSListener;
        this.storeUpdateListener = trustStoreUpdateListener;
        this.protocolListener = protocolListener;
    }

    public DefaultVOMSProxyInitBehaviour(VOMSCommandsParsingStrategy commandsParser, InitListenerAdapter listenerAdapter) {
        this.commandsParser = commandsParser;
        this.validationResultListener = listenerAdapter;
        this.requestListener = listenerAdapter;
        this.proxyCreationListener = listenerAdapter;
        this.serverInfoStoreListener = listenerAdapter;
        this.loadCredentialsEventListener = listenerAdapter;
        this.certChainValidationErrorListener = listenerAdapter;
        this.vomsTrustStoreListener = listenerAdapter;
        this.storeUpdateListener = listenerAdapter;
        this.protocolListener = listenerAdapter;
    }

    protected void validateUserCredential(ProxyInitParams params, X509Credential cred) {
        ValidationResult result = this.certChainValidator.validate(cred.getCertificateChain());
        if (!result.isValid()) {
            throw new VOMSError("User credential is not valid!");
        }
    }

    private void init(ProxyInitParams params) {
        boolean hasVOMSCommands;
        boolean bl = hasVOMSCommands = params.getVomsCommands() != null && !params.getVomsCommands().isEmpty();
        if (hasVOMSCommands || params.validateUserCredential()) {
            params.setValidateUserCredential(true);
            this.initCertChainValidator(params);
            if (params.verifyAC() && hasVOMSCommands) {
                this.initVOMSValidator(params);
            }
        }
    }

    @Override
    public void initProxy(ProxyInitParams params) {
        X509Credential cred;
        this.init(params);
        VOMSServerInfoStore serverInfoStore = null;
        if (params.getVomsCommands() != null && !params.getVomsCommands().isEmpty()) {
            serverInfoStore = this.initServerInfoStore(params);
            this.checkCommands(params, serverInfoStore);
        }
        if ((cred = this.lookupCredential(params)) == null) {
            throw new VOMSError("No credentials found!");
        }
        if (params.validateUserCredential()) {
            this.validateUserCredential(params, cred);
        }
        List<AttributeCertificate> acs = Collections.emptyList();
        if (params.getVomsCommands() != null && !params.getVomsCommands().isEmpty()) {
            this.initCertChainValidator(params);
            acs = this.getAttributeCertificates(params, cred, serverInfoStore);
        }
        if (params.verifyAC() && !acs.isEmpty()) {
            this.verifyACs(params, acs);
        }
        this.createProxy(params, cred, acs);
    }

    private void checkCommands(ProxyInitParams params, VOMSServerInfoStore sis) {
        Map<String, List<String>> vomsCommandsMap = this.commandsParser.parseCommands(params.getVomsCommands());
        for (String voOrAlias : vomsCommandsMap.keySet()) {
            if (!sis.getVOMSServerInfo(voOrAlias).isEmpty()) continue;
            String msg = String.format("VOMS server for VO %s is not known! Check your vomses configuration.", voOrAlias);
            throw new VOMSError(msg);
        }
    }

    private VOMSServerInfoStore initServerInfoStore(ProxyInitParams params) {
        DefaultVOMSServerInfoStore sis = null;
        if (params.getVomsCommands() != null && !params.getVomsCommands().isEmpty()) {
            sis = new DefaultVOMSServerInfoStore.Builder().lookupStrategy(this.getVOMSESLookupStrategyFromParams(params)).storeListener(this.serverInfoStoreListener).build();
        }
        return sis;
    }

    private void directorySanityChecks(String dirPath, String preambleMessage) {
        File f = new File(dirPath);
        String errorTemplate = String.format("%s: '%s'", preambleMessage, dirPath);
        errorTemplate = errorTemplate + " (%s)";
        if (!f.exists()) {
            FileNotFoundException t = new FileNotFoundException(String.format(errorTemplate, "file not found"));
            throw new VOMSError(t.getMessage(), (Throwable)t);
        }
        if (!f.isDirectory()) {
            throw new VOMSError(String.format(errorTemplate, "not a directory"));
        }
        if (!f.canRead()) {
            throw new VOMSError(String.format(errorTemplate, "not readable"));
        }
    }

    private void initCertChainValidator(ProxyInitParams params) {
        if (this.certChainValidator == null) {
            String trustAnchorsDir = "/etc/grid-security/certificates";
            if (System.getenv("X509_CERT_DIR") != null) {
                trustAnchorsDir = System.getenv("X509_CERT_DIR");
            }
            if (params.getTrustAnchorsDir() != null) {
                trustAnchorsDir = params.getTrustAnchorsDir();
            }
            this.directorySanityChecks(trustAnchorsDir, "Invalid trust anchors location");
            CertificateValidatorBuilder builder = new CertificateValidatorBuilder();
            this.certChainValidator = builder.trustAnchorsDir(trustAnchorsDir).storeUpdateListener(this.storeUpdateListener).lazyAnchorsLoading(true).validationErrorListener(this.certChainValidationErrorListener).build();
        }
    }

    private VOMSACValidator initVOMSValidator(ProxyInitParams params) {
        if (this.vomsValidator != null) {
            return this.vomsValidator;
        }
        String vomsdir = "/etc/grid-security/vomsdir";
        if (System.getenv("X509_VOMS_DIR") != null) {
            vomsdir = System.getenv("X509_VOMS_DIR");
        }
        if (params.getVomsdir() != null) {
            vomsdir = params.getVomsdir();
        }
        this.directorySanityChecks(vomsdir, "Invalid vomsdir location");
        DefaultVOMSTrustStore trustStore = new DefaultVOMSTrustStore(Arrays.asList(vomsdir), this.vomsTrustStoreListener);
        this.vomsValidator = VOMSValidators.newValidator((VOMSTrustStore)trustStore, (X509CertChainValidatorExt)this.certChainValidator, (ValidationResultListener)this.validationResultListener);
        return this.vomsValidator;
    }

    private void verifyACs(ProxyInitParams params, List<AttributeCertificate> acs) {
        VOMSACValidator acValidator = this.initVOMSValidator(params);
        acValidator.validateACs(acs);
    }

    private ProxyType extendedProxyTypeAsProxyType(ExtendedProxyType pt) {
        switch (pt) {
            case DRAFT_RFC: {
                return ProxyType.DRAFT_RFC;
            }
            case LEGACY: {
                return ProxyType.LEGACY;
            }
            case RFC3820: {
                return ProxyType.RFC3820;
            }
        }
        return null;
    }

    private void ensureProxyTypeIsCompatibleWithIssuingCredential(ProxyCertificateOptions options, X509Credential issuingCredential, List<String> proxyCreationWarnings) {
        if (ProxyUtils.isProxy((X509Certificate[])issuingCredential.getCertificateChain())) {
            ProxyType issuingProxyType = this.extendedProxyTypeAsProxyType(ProxyHelper.getProxyType((X509Certificate)issuingCredential.getCertificateChain()[0]));
            if (!issuingProxyType.equals((Object)options.getType())) {
                proxyCreationWarnings.add("forced " + issuingProxyType.name() + " proxy type to be compatible with the type of the issuing proxy.");
                options.setType(issuingProxyType);
            }
            try {
                boolean issuingProxyIsLimited = ProxyHelper.isLimited((X509Certificate)issuingCredential.getCertificateChain()[0]);
                if (issuingProxyIsLimited && !options.isLimited()) {
                    proxyCreationWarnings.add("forced the creation of a limited proxy to be compatible with the type of the issuing proxy.");
                    this.limitProxy(options);
                }
            }
            catch (IOException e) {
                throw new VOMSError(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void checkMixedProxyChain(X509Credential issuingCredential) {
        if (ProxyUtils.isProxy((X509Certificate[])issuingCredential.getCertificateChain())) {
            try {
                ProxyChainInfo ci = new ProxyChainInfo(issuingCredential.getCertificateChain());
                if (ci.getProxyType().equals((Object)ProxyChainType.MIXED)) {
                    throw new VOMSError("Cannot generate a proxy certificate starting from a mixed type proxy chain.");
                }
            }
            catch (CertificateException e) {
                throw new VOMSError(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void ensureProxyLifetimeIsConsistentWithIssuingCredential(ProxyCertificateOptions options, X509Credential issuingCredential, List<String> proxyCreationWarnings) {
        Calendar cal = Calendar.getInstance();
        Date proxyStartTime = cal.getTime();
        cal.add(13, options.getLifetime());
        Date proxyEndTime = cal.getTime();
        Date issuingCredentialEndTime = issuingCredential.getCertificate().getNotAfter();
        options.setValidityBounds(proxyStartTime, proxyEndTime);
        if (proxyEndTime.after(issuingCredentialEndTime)) {
            proxyCreationWarnings.add("proxy lifetime limited to issuing credential lifetime.");
            options.setValidityBounds(proxyStartTime, issuingCredentialEndTime);
        }
    }

    private void limitProxy(ProxyCertificateOptions proxyOptions) {
        proxyOptions.setLimited(true);
        if (proxyOptions.getType().equals((Object)ProxyType.RFC3820) || proxyOptions.getType().equals((Object)ProxyType.DRAFT_RFC)) {
            proxyOptions.setPolicy(new ProxyPolicy("1.3.6.1.4.1.3536.1.1.1.9"));
        }
    }

    private void createProxy(ProxyInitParams params, X509Credential credential, List<AttributeCertificate> acs) {
        ArrayList<String> proxyCreationWarnings = new ArrayList<String>();
        String proxyFilePath = VOMSProxyPathBuilder.buildProxyPath();
        String envProxyPath = System.getenv("X509_USER_PROXY");
        if (envProxyPath != null) {
            proxyFilePath = envProxyPath;
        }
        if (params.getGeneratedProxyFile() != null) {
            proxyFilePath = params.getGeneratedProxyFile();
        }
        ProxyCertificateOptions proxyOptions = new ProxyCertificateOptions(credential.getCertificateChain());
        proxyOptions.setProxyPathLimit(params.getPathLenConstraint());
        proxyOptions.setLimited(params.isLimited());
        proxyOptions.setLifetime(params.getProxyLifetimeInSeconds());
        proxyOptions.setType(params.getProxyType());
        proxyOptions.setKeyLength(params.getKeySize());
        if (params.isEnforcingChainIntegrity()) {
            this.checkMixedProxyChain(credential);
            this.ensureProxyTypeIsCompatibleWithIssuingCredential(proxyOptions, credential, proxyCreationWarnings);
            this.ensureProxyLifetimeIsConsistentWithIssuingCredential(proxyOptions, credential, proxyCreationWarnings);
        }
        if (params.isLimited()) {
            this.limitProxy(proxyOptions);
        }
        if (acs != null && !acs.isEmpty()) {
            try {
                proxyOptions.setAttributeCertificates(acs.toArray(new AttributeCertificate[acs.size()]));
            }
            catch (IOException e) {
                throw new VOMSError(e.getMessage(), (Throwable)e);
            }
        }
        try {
            ProxyCertificate proxy = ProxyGenerator.generate((ProxyCertificateOptions)proxyOptions, (PrivateKey)credential.getKey());
            CredentialsUtils.saveProxyCredentials((String)proxyFilePath, (X509Credential)proxy.getCredential());
            this.proxyCreationListener.proxyCreated(proxyFilePath, proxy, proxyCreationWarnings);
        }
        catch (Throwable t) {
            throw new VOMSError("Error creating proxy certificate: " + t.getMessage(), t);
        }
    }

    protected List<String> sortFQANsIfRequested(ProxyInitParams params, List<String> unsortedFQANs) {
        if (params.getFqanOrder() != null && !params.getFqanOrder().isEmpty()) {
            LinkedHashSet<String> fqans = new LinkedHashSet<String>();
            for (String fqan : params.getFqanOrder()) {
                if (VOMSFQANNamingScheme.isGroup((String)fqan)) {
                    fqans.add(fqan);
                }
                if (!VOMSFQANNamingScheme.isQualifiedRole((String)fqan) || !unsortedFQANs.contains(fqan)) continue;
                fqans.add(fqan);
            }
            fqans.addAll(unsortedFQANs);
            return new ArrayList<String>(fqans);
        }
        return unsortedFQANs;
    }

    protected VOMSESLookupStrategy getVOMSESLookupStrategyFromParams(ProxyInitParams params) {
        if (params.getVomsesLocations() != null && !params.getVomsesLocations().isEmpty()) {
            return new BaseVOMSESLookupStrategy(params.getVomsesLocations());
        }
        return new DefaultVOMSESLookupStrategy();
    }

    protected List<AttributeCertificate> getAttributeCertificates(ProxyInitParams params, X509Credential cred, VOMSServerInfoStore serverInfoStore) {
        List<String> vomsCommands = params.getVomsCommands();
        if (vomsCommands == null || vomsCommands.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, List<String>> vomsCommandsMap = this.commandsParser.parseCommands(params.getVomsCommands());
        ArrayList<AttributeCertificate> acs = new ArrayList<AttributeCertificate>();
        for (String vo : vomsCommandsMap.keySet()) {
            List<String> fqans = vomsCommandsMap.get(vo);
            DefaultVOMSACRequest request = new DefaultVOMSACRequest.Builder(vo).fqans(this.sortFQANsIfRequested(params, fqans)).targets(params.getTargets()).lifetime(params.getAcLifetimeInSeconds()).build();
            DefaultVOMSACService acService = new DefaultVOMSACService.Builder(this.certChainValidator).requestListener(this.requestListener).serverInfoStore(serverInfoStore).vomsesLookupStrategy(this.getVOMSESLookupStrategyFromParams(params)).protocolListener(this.protocolListener).connectTimeout((int)TimeUnit.SECONDS.toMillis(params.getTimeoutInSeconds())).readTimeout((int)TimeUnit.SECONDS.toMillis(params.getTimeoutInSeconds())).skipHostnameChecks(params.isSkipHostnameChecks()).build();
            AttributeCertificate ac = acService.getVOMSAttributeCertificate(cred, (VOMSACRequest)request);
            if (ac == null) continue;
            acs.add(ac);
        }
        if (!vomsCommandsMap.keySet().isEmpty() && acs.isEmpty()) {
            throw new VOMSError("User's request for VOMS attributes could not be fulfilled.");
        }
        return acs;
    }

    private LoadCredentialsStrategy strategyFromParams(ProxyInitParams params) {
        if (params.isNoRegen()) {
            return new LoadProxyCredential(this.loadCredentialsEventListener, params.getCertFile());
        }
        if (params.getCertFile() != null && params.getKeyFile() == null) {
            return new LoadUserCredential(this.loadCredentialsEventListener, params.getCertFile());
        }
        if (params.getCertFile() != null && params.getKeyFile() != null) {
            return new LoadUserCredential(this.loadCredentialsEventListener, params.getCertFile(), params.getKeyFile());
        }
        return new DefaultLoadCredentialsStrategy(System.getProperty("user.home"), "java.io.tmpdir", this.loadCredentialsEventListener);
    }

    private X509Credential lookupCredential(ProxyInitParams params) {
        PasswordFinder pf = null;
        pf = params.isReadPasswordFromStdin() ? PasswordFinders.getNoPromptInputStreamPasswordFinder(System.in, System.out) : PasswordFinders.getDefault();
        LoadCredentialsStrategy loadCredStrategy = this.strategyFromParams(params);
        return loadCredStrategy.loadCredentials(pf);
    }
}

