/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import sun.swing.plaf.synth.SynthIcon;

public class SynthToolBarUI
extends BasicToolBarUI
implements PropertyChangeListener,
SynthUI {
    private Icon handleIcon = null;
    private Rectangle contentRect = new Rectangle();
    private SynthStyle style;
    private SynthStyle contentStyle;
    private SynthStyle dragWindowStyle;

    public static ComponentUI createUI(JComponent c) {
        return new SynthToolBarUI();
    }

    @Override
    protected void installDefaults() {
        this.toolBar.setLayout(this.createLayout());
        this.updateStyle(this.toolBar);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.toolBar.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.toolBar.removePropertyChangeListener(this);
    }

    private void updateStyle(JToolBar c) {
        SynthContext context = this.getContext(c, Region.TOOL_BAR_CONTENT, null, 1);
        this.contentStyle = SynthLookAndFeel.updateStyle(context, this);
        context.dispose();
        context = this.getContext(c, Region.TOOL_BAR_DRAG_WINDOW, null, 1);
        this.dragWindowStyle = SynthLookAndFeel.updateStyle(context, this);
        context.dispose();
        context = this.getContext(c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (oldStyle != this.style) {
            this.handleIcon = this.style.getIcon(context, "ToolBar.handleIcon");
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context.dispose();
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this.toolBar, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        this.handleIcon = null;
        context = this.getContext(this.toolBar, Region.TOOL_BAR_CONTENT, this.contentStyle, 1);
        this.contentStyle.uninstallDefaults(context);
        context.dispose();
        this.contentStyle = null;
        context = this.getContext(this.toolBar, Region.TOOL_BAR_DRAG_WINDOW, this.dragWindowStyle, 1);
        this.dragWindowStyle.uninstallDefaults(context);
        context.dispose();
        this.dragWindowStyle = null;
        this.toolBar.setLayout(null);
    }

    @Override
    protected void installComponents() {
    }

    @Override
    protected void uninstallComponents() {
    }

    protected LayoutManager createLayout() {
        return new SynthToolBarLayoutManager();
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, SynthLookAndFeel.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(c, this.style, state);
    }

    private SynthContext getContext(JComponent c, Region region, SynthStyle style) {
        return SynthContext.getContext(c, region, style, this.getComponentState(c, region));
    }

    private SynthContext getContext(JComponent c, Region region, SynthStyle style, int state) {
        return SynthContext.getContext(c, region, style, state);
    }

    private int getComponentState(JComponent c, Region region) {
        return SynthLookAndFeel.getComponentState(c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintToolBarBackground(context, g, 0, 0, c.getWidth(), c.getHeight(), this.toolBar.getOrientation());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintToolBarBorder(context, g, x, y, w, h, this.toolBar.getOrientation());
    }

    @Override
    protected void setBorderToNonRollover(Component c) {
    }

    @Override
    protected void setBorderToRollover(Component c) {
    }

    @Override
    protected void setBorderToNormal(Component c) {
    }

    protected void paint(SynthContext context, Graphics g) {
        if (this.handleIcon != null && this.toolBar.isFloatable()) {
            int startX = this.toolBar.getComponentOrientation().isLeftToRight() ? 0 : this.toolBar.getWidth() - SynthIcon.getIconWidth(this.handleIcon, context);
            SynthIcon.paintIcon(this.handleIcon, context, g, startX, 0, SynthIcon.getIconWidth(this.handleIcon, context), SynthIcon.getIconHeight(this.handleIcon, context));
        }
        SynthContext subcontext = this.getContext(this.toolBar, Region.TOOL_BAR_CONTENT, this.contentStyle);
        this.paintContent(subcontext, g, this.contentRect);
        subcontext.dispose();
    }

    protected void paintContent(SynthContext context, Graphics g, Rectangle bounds) {
        SynthLookAndFeel.updateSubregion(context, g, bounds);
        context.getPainter().paintToolBarContentBackground(context, g, bounds.x, bounds.y, bounds.width, bounds.height, this.toolBar.getOrientation());
        context.getPainter().paintToolBarContentBorder(context, g, bounds.x, bounds.y, bounds.width, bounds.height, this.toolBar.getOrientation());
    }

    @Override
    protected void paintDragWindow(Graphics g) {
        int w = this.dragWindow.getWidth();
        int h = this.dragWindow.getHeight();
        SynthContext context = this.getContext(this.toolBar, Region.TOOL_BAR_DRAG_WINDOW, this.dragWindowStyle);
        SynthLookAndFeel.updateSubregion(context, g, new Rectangle(0, 0, w, h));
        context.getPainter().paintToolBarDragWindowBackground(context, g, 0, 0, w, h, this.dragWindow.getOrientation());
        context.getPainter().paintToolBarDragWindowBorder(context, g, 0, 0, w, h, this.dragWindow.getOrientation());
        context.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JToolBar)e.getSource());
        }
    }

    class SynthToolBarLayoutManager
    implements LayoutManager {
        SynthToolBarLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            JToolBar tb = (JToolBar)parent;
            Insets insets = tb.getInsets();
            Dimension dim = new Dimension();
            SynthContext context = SynthToolBarUI.this.getContext(tb);
            if (tb.getOrientation() == 0) {
                dim.width = tb.isFloatable() ? SynthIcon.getIconWidth(SynthToolBarUI.this.handleIcon, context) : 0;
                for (int i = 0; i < tb.getComponentCount(); ++i) {
                    Component component = tb.getComponent(i);
                    if (!component.isVisible()) continue;
                    Dimension compDim = component.getMinimumSize();
                    dim.width += compDim.width;
                    dim.height = Math.max(dim.height, compDim.height);
                }
            } else {
                dim.height = tb.isFloatable() ? SynthIcon.getIconHeight(SynthToolBarUI.this.handleIcon, context) : 0;
                for (int i = 0; i < tb.getComponentCount(); ++i) {
                    Component component = tb.getComponent(i);
                    if (!component.isVisible()) continue;
                    Dimension compDim = component.getMinimumSize();
                    dim.width = Math.max(dim.width, compDim.width);
                    dim.height += compDim.height;
                }
            }
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            context.dispose();
            return dim;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            JToolBar tb = (JToolBar)parent;
            Insets insets = tb.getInsets();
            Dimension dim = new Dimension();
            SynthContext context = SynthToolBarUI.this.getContext(tb);
            if (tb.getOrientation() == 0) {
                dim.width = tb.isFloatable() ? SynthIcon.getIconWidth(SynthToolBarUI.this.handleIcon, context) : 0;
                for (int i = 0; i < tb.getComponentCount(); ++i) {
                    Component component = tb.getComponent(i);
                    if (!component.isVisible()) continue;
                    Dimension compDim = component.getPreferredSize();
                    dim.width += compDim.width;
                    dim.height = Math.max(dim.height, compDim.height);
                }
            } else {
                dim.height = tb.isFloatable() ? SynthIcon.getIconHeight(SynthToolBarUI.this.handleIcon, context) : 0;
                for (int i = 0; i < tb.getComponentCount(); ++i) {
                    Component component = tb.getComponent(i);
                    if (!component.isVisible()) continue;
                    Dimension compDim = component.getPreferredSize();
                    dim.width = Math.max(dim.width, compDim.width);
                    dim.height += compDim.height;
                }
            }
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            context.dispose();
            return dim;
        }

        @Override
        public void layoutContainer(Container parent) {
            JToolBar tb = (JToolBar)parent;
            Insets insets = tb.getInsets();
            boolean ltr = tb.getComponentOrientation().isLeftToRight();
            SynthContext context = SynthToolBarUI.this.getContext(tb);
            int glueCount = 0;
            for (int i = 0; i < tb.getComponentCount(); ++i) {
                if (!this.isGlue(tb.getComponent(i))) continue;
                ++glueCount;
            }
            if (tb.getOrientation() == 0) {
                int handleWidth = tb.isFloatable() ? SynthIcon.getIconWidth(SynthToolBarUI.this.handleIcon, context) : 0;
                ((SynthToolBarUI)SynthToolBarUI.this).contentRect.x = ltr ? handleWidth : 0;
                ((SynthToolBarUI)SynthToolBarUI.this).contentRect.y = 0;
                ((SynthToolBarUI)SynthToolBarUI.this).contentRect.width = tb.getWidth() - handleWidth;
                ((SynthToolBarUI)SynthToolBarUI.this).contentRect.height = tb.getHeight();
                int x = ltr ? handleWidth + insets.left : tb.getWidth() - handleWidth - insets.right;
                int baseY = insets.top;
                int baseH = tb.getHeight() - insets.top - insets.bottom;
                int extraSpacePerGlue = 0;
                if (glueCount > 0) {
                    int minWidth = this.minimumLayoutSize((Container)parent).width;
                    extraSpacePerGlue = (tb.getWidth() - minWidth) / glueCount;
                    if (extraSpacePerGlue < 0) {
                        extraSpacePerGlue = 0;
                    }
                }
                for (int i = 0; i < tb.getComponentCount(); ++i) {
                    int h;
                    int y;
                    Component c = tb.getComponent(i);
                    if (!c.isVisible()) continue;
                    Dimension d = c.getPreferredSize();
                    if (d.height >= baseH || c instanceof JSeparator) {
                        y = baseY;
                        h = baseH;
                    } else {
                        y = baseY + baseH / 2 - d.height / 2;
                        h = d.height;
                    }
                    if (this.isGlue(c)) {
                        d.width += extraSpacePerGlue;
                    }
                    c.setBounds(ltr ? x : x - d.width, y, d.width, h);
                    x = ltr ? x + d.width : x - d.width;
                }
            } else {
                int handleHeight = tb.isFloatable() ? SynthIcon.getIconHeight(SynthToolBarUI.this.handleIcon, context) : 0;
                ((SynthToolBarUI)SynthToolBarUI.this).contentRect.x = 0;
                ((SynthToolBarUI)SynthToolBarUI.this).contentRect.y = handleHeight;
                ((SynthToolBarUI)SynthToolBarUI.this).contentRect.width = tb.getWidth();
                ((SynthToolBarUI)SynthToolBarUI.this).contentRect.height = tb.getHeight() - handleHeight;
                int baseX = insets.left;
                int baseW = tb.getWidth() - insets.left - insets.right;
                int y = handleHeight + insets.top;
                int extraSpacePerGlue = 0;
                if (glueCount > 0) {
                    int minHeight = this.minimumLayoutSize((Container)parent).height;
                    extraSpacePerGlue = (tb.getHeight() - minHeight) / glueCount;
                    if (extraSpacePerGlue < 0) {
                        extraSpacePerGlue = 0;
                    }
                }
                for (int i = 0; i < tb.getComponentCount(); ++i) {
                    int w;
                    int x;
                    Component c = tb.getComponent(i);
                    if (!c.isVisible()) continue;
                    Dimension d = c.getPreferredSize();
                    if (d.width >= baseW || c instanceof JSeparator) {
                        x = baseX;
                        w = baseW;
                    } else {
                        x = baseX + baseW / 2 - d.width / 2;
                        w = d.width;
                    }
                    if (this.isGlue(c)) {
                        d.height += extraSpacePerGlue;
                    }
                    c.setBounds(x, y, w, d.height);
                    y += d.height;
                }
            }
            context.dispose();
        }

        private boolean isGlue(Component c) {
            if (c.isVisible() && c instanceof Box.Filler) {
                Box.Filler f = (Box.Filler)c;
                Dimension min = f.getMinimumSize();
                Dimension pref = f.getPreferredSize();
                return min.width == 0 && min.height == 0 && pref.width == 0 && pref.height == 0;
            }
            return false;
        }
    }
}

