/*
 * Decompiled with CFR 0.152.
 */
package sun.security.smartcardio;

import java.security.AccessController;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardPermission;
import sun.security.action.GetPropertyAction;
import sun.security.smartcardio.ChannelImpl;
import sun.security.smartcardio.PCSC;
import sun.security.smartcardio.PCSCException;
import sun.security.smartcardio.TerminalImpl;

final class CardImpl
extends Card {
    private final TerminalImpl terminal;
    final long cardId;
    private final ATR atr;
    final int protocol;
    private final ChannelImpl basicChannel;
    private volatile State state;
    private volatile Thread exclusiveThread;
    private static final boolean isWindows;
    private static byte[] commandOpenChannel;
    private static final boolean invertReset;

    CardImpl(TerminalImpl terminal, String protocol) throws PCSCException {
        int connectProtocol;
        this.terminal = terminal;
        int sharingMode = 2;
        if (protocol.equals("*")) {
            connectProtocol = 3;
        } else if (protocol.equalsIgnoreCase("T=0")) {
            connectProtocol = 1;
        } else if (protocol.equalsIgnoreCase("T=1")) {
            connectProtocol = 2;
        } else if (protocol.equalsIgnoreCase("direct")) {
            connectProtocol = isWindows ? 0 : 4;
            sharingMode = 3;
        } else {
            throw new IllegalArgumentException("Unsupported protocol " + protocol);
        }
        this.cardId = PCSC.SCardConnect(terminal.contextId, terminal.name, sharingMode, connectProtocol);
        byte[] status = new byte[2];
        byte[] atrBytes = PCSC.SCardStatus(this.cardId, status);
        this.atr = new ATR(atrBytes);
        this.protocol = status[1] & 0xFF;
        this.basicChannel = new ChannelImpl(this, 0);
        this.state = State.OK;
    }

    void checkState() {
        State s = this.state;
        if (s == State.DISCONNECTED) {
            throw new IllegalStateException("Card has been disconnected");
        }
        if (s == State.REMOVED) {
            throw new IllegalStateException("Card has been removed");
        }
    }

    boolean isValid() {
        if (this.state != State.OK) {
            return false;
        }
        try {
            PCSC.SCardStatus(this.cardId, new byte[2]);
            return true;
        }
        catch (PCSCException e) {
            this.state = State.REMOVED;
            return false;
        }
    }

    private void checkSecurity(String action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new CardPermission(this.terminal.name, action));
        }
    }

    void handleError(PCSCException e) {
        if (e.code == -2146434967) {
            this.state = State.REMOVED;
        }
    }

    @Override
    public ATR getATR() {
        return this.atr;
    }

    @Override
    public String getProtocol() {
        switch (this.protocol) {
            case 1: {
                return "T=0";
            }
            case 2: {
                return "T=1";
            }
        }
        return "Unknown protocol " + this.protocol;
    }

    @Override
    public CardChannel getBasicChannel() {
        this.checkSecurity("getBasicChannel");
        this.checkState();
        return this.basicChannel;
    }

    private static int getSW(byte[] b) {
        if (b.length < 2) {
            return -1;
        }
        int sw1 = b[b.length - 2] & 0xFF;
        int sw2 = b[b.length - 1] & 0xFF;
        return sw1 << 8 | sw2;
    }

    @Override
    public CardChannel openLogicalChannel() throws CardException {
        this.checkSecurity("openLogicalChannel");
        this.checkState();
        this.checkExclusive();
        try {
            byte[] response = PCSC.SCardTransmit(this.cardId, this.protocol, commandOpenChannel, 0, commandOpenChannel.length);
            if (response.length != 3 || CardImpl.getSW(response) != 36864) {
                throw new CardException("openLogicalChannel() failed, card response: " + PCSC.toString(response));
            }
            return new ChannelImpl(this, response[0]);
        }
        catch (PCSCException e) {
            this.handleError(e);
            throw new CardException("openLogicalChannel() failed", e);
        }
    }

    void checkExclusive() throws CardException {
        Thread t = this.exclusiveThread;
        if (t == null) {
            return;
        }
        if (t != Thread.currentThread()) {
            throw new CardException("Exclusive access established by another Thread");
        }
    }

    @Override
    public synchronized void beginExclusive() throws CardException {
        this.checkSecurity("exclusive");
        this.checkState();
        if (this.exclusiveThread != null) {
            throw new CardException("Exclusive access has already been assigned to Thread " + this.exclusiveThread.getName());
        }
        try {
            PCSC.SCardBeginTransaction(this.cardId);
        }
        catch (PCSCException e) {
            this.handleError(e);
            throw new CardException("beginExclusive() failed", e);
        }
        this.exclusiveThread = Thread.currentThread();
    }

    @Override
    public synchronized void endExclusive() throws CardException {
        this.checkState();
        if (this.exclusiveThread != Thread.currentThread()) {
            throw new IllegalStateException("Exclusive access not assigned to current Thread");
        }
        try {
            PCSC.SCardEndTransaction(this.cardId, 0);
        }
        catch (PCSCException e) {
            this.handleError(e);
            throw new CardException("endExclusive() failed", e);
        }
        finally {
            this.exclusiveThread = null;
        }
    }

    @Override
    public byte[] transmitControlCommand(int controlCode, byte[] command) throws CardException {
        this.checkSecurity("transmitControl");
        this.checkState();
        this.checkExclusive();
        if (command == null) {
            throw new NullPointerException();
        }
        try {
            byte[] r = PCSC.SCardControl(this.cardId, controlCode, command);
            return r;
        }
        catch (PCSCException e) {
            this.handleError(e);
            throw new CardException("transmitControlCommand() failed", e);
        }
    }

    @Override
    public void disconnect(boolean reset) throws CardException {
        if (reset) {
            this.checkSecurity("reset");
        }
        if (this.state != State.OK) {
            return;
        }
        this.checkExclusive();
        if (invertReset) {
            reset = !reset;
        }
        try {
            PCSC.SCardDisconnect(this.cardId, reset ? 1 : 0);
        }
        catch (PCSCException e) {
            throw new CardException("disconnect() failed", e);
        }
        finally {
            this.state = State.DISCONNECTED;
            this.exclusiveThread = null;
        }
    }

    public String toString() {
        return "PC/SC card in " + this.terminal.getName() + ", protocol " + this.getProtocol() + ", state " + (Object)((Object)this.state);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.state == State.OK) {
                PCSC.SCardDisconnect(this.cardId, 0);
            }
        }
        finally {
            super.finalize();
        }
    }

    static {
        String osName = AccessController.doPrivileged(() -> System.getProperty("os.name"));
        isWindows = osName.startsWith("Windows");
        commandOpenChannel = new byte[]{0, 112, 0, 0, 1};
        invertReset = Boolean.parseBoolean(AccessController.doPrivileged(new GetPropertyAction("sun.security.smartcardio.invertCardReset", "false")));
    }

    private static enum State {
        OK,
        REMOVED,
        DISCONNECTED;

    }
}

