/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterState;
import javax.print.attribute.standard.PrinterStateReason;
import javax.print.attribute.standard.PrinterStateReasons;
import javax.print.attribute.standard.QueuedJobCount;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.Severity;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintServiceAttributeListener;
import sun.print.AttributeUpdater;
import sun.print.PSPrinterJob;
import sun.print.ServiceNotifier;
import sun.print.SunPrinterJobService;
import sun.print.UnixPrintJob;
import sun.print.UnixPrintServiceLookup;
import sun.security.action.GetPropertyAction;

public class UnixPrintService
implements PrintService,
AttributeUpdater,
SunPrinterJobService {
    private static String encoding = "ISO8859_1";
    private static DocFlavor textByteFlavor;
    private static DocFlavor[] supportedDocFlavors;
    private static final DocFlavor[] supportedDocFlavorsInit;
    private static final DocFlavor[] supportedHostDocFlavors;
    String[] lpcStatusCom = new String[]{"", "| grep -E '^[ 0-9a-zA-Z_-]*@' | awk '{print $2, $3}'"};
    String[] lpcQueueCom = new String[]{"", "| grep -E '^[ 0-9a-zA-Z_-]*@' | awk '{print $4}'"};
    private static final Class[] serviceAttrCats;
    private static final Class[] otherAttrCats;
    private static int MAXCOPIES;
    private static final MediaSizeName[] mediaSizes;
    private String printer;
    private PrinterName name;
    private boolean isInvalid;
    private transient PrintServiceAttributeSet lastSet;
    private transient ServiceNotifier notifier = null;
    private static MediaPrintableArea[] mpas;

    UnixPrintService(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null printer name");
        }
        this.printer = name;
        this.isInvalid = false;
    }

    public void invalidateService() {
        this.isInvalid = true;
    }

    @Override
    public String getName() {
        return this.printer;
    }

    private PrinterName getPrinterName() {
        if (this.name == null) {
            this.name = new PrinterName(this.printer, null);
        }
        return this.name;
    }

    private PrinterIsAcceptingJobs getPrinterIsAcceptingJobsSysV() {
        String command = "/usr/bin/lpstat -a " + this.printer;
        String[] results = UnixPrintServiceLookup.execCmd(command);
        if (results != null && results.length > 0) {
            if (results[0].startsWith(this.printer + " accepting requests")) {
                return PrinterIsAcceptingJobs.ACCEPTING_JOBS;
            }
            if (results[0].startsWith(this.printer)) {
                int index = this.printer.length();
                String str = results[0];
                if (str.length() > index && str.charAt(index) == '@' && str.indexOf(" accepting requests", index) > 0 && str.indexOf(" not accepting requests", index) == -1) {
                    return PrinterIsAcceptingJobs.ACCEPTING_JOBS;
                }
            }
        }
        return PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS;
    }

    private PrinterIsAcceptingJobs getPrinterIsAcceptingJobsBSD() {
        String command;
        String[] results;
        if (UnixPrintServiceLookup.cmdIndex == -1) {
            UnixPrintServiceLookup.cmdIndex = UnixPrintServiceLookup.getBSDCommandIndex();
        }
        if ((results = UnixPrintServiceLookup.execCmd(command = "/usr/sbin/lpc status " + this.printer + this.lpcStatusCom[UnixPrintServiceLookup.cmdIndex])) != null && results.length > 0 && (UnixPrintServiceLookup.cmdIndex == 1 ? results[0].startsWith("enabled enabled") : results[1].trim().startsWith("queuing is enabled") && results[2].trim().startsWith("printing is enabled") || results.length >= 4 && results[2].trim().startsWith("queuing is enabled") && results[3].trim().startsWith("printing is enabled"))) {
            return PrinterIsAcceptingJobs.ACCEPTING_JOBS;
        }
        return PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS;
    }

    protected static String[] filterPrinterNamesAIX(String[] posPrinters) {
        ArrayList<String> printers = new ArrayList<String>();
        for (int i = 0; i < posPrinters.length; ++i) {
            String[] splitPart;
            if (posPrinters[i].startsWith("---") || posPrinters[i].startsWith("Queue") || posPrinters[i].equals("") || (splitPart = posPrinters[i].split(" ")).length < 1 || splitPart[0].trim().endsWith(":")) continue;
            printers.add(posPrinters[i]);
        }
        return printers.toArray(new String[printers.size()]);
    }

    private PrinterIsAcceptingJobs getPrinterIsAcceptingJobsAIX() {
        String command = "/usr/bin/lpstat -a" + this.printer;
        String[] results = UnixPrintServiceLookup.execCmd(command);
        if ((results = UnixPrintService.filterPrinterNamesAIX(results)) != null && results.length > 0) {
            for (int i = 0; i < results.length; ++i) {
                if (!results[i].contains("READY") && !results[i].contains("RUNNING")) continue;
                return PrinterIsAcceptingJobs.ACCEPTING_JOBS;
            }
        }
        return PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS;
    }

    private PrinterIsAcceptingJobs getPrinterIsAcceptingJobs() {
        if (UnixPrintServiceLookup.isSysV()) {
            return this.getPrinterIsAcceptingJobsSysV();
        }
        if (UnixPrintServiceLookup.isBSD()) {
            return this.getPrinterIsAcceptingJobsBSD();
        }
        if (UnixPrintServiceLookup.isAIX()) {
            return this.getPrinterIsAcceptingJobsAIX();
        }
        return PrinterIsAcceptingJobs.ACCEPTING_JOBS;
    }

    private PrinterState getPrinterState() {
        if (this.isInvalid) {
            return PrinterState.STOPPED;
        }
        return null;
    }

    private PrinterStateReasons getPrinterStateReasons() {
        if (this.isInvalid) {
            PrinterStateReasons psr = new PrinterStateReasons();
            psr.put(PrinterStateReason.SHUTDOWN, Severity.ERROR);
            return psr;
        }
        return null;
    }

    private QueuedJobCount getQueuedJobCountSysV() {
        String command = "/usr/bin/lpstat -R " + this.printer;
        String[] results = UnixPrintServiceLookup.execCmd(command);
        int qlen = results == null ? 0 : results.length;
        return new QueuedJobCount(qlen);
    }

    private QueuedJobCount getQueuedJobCountBSD() {
        if (UnixPrintServiceLookup.cmdIndex == -1) {
            UnixPrintServiceLookup.cmdIndex = UnixPrintServiceLookup.getBSDCommandIndex();
        }
        int qlen = 0;
        String command = "/usr/sbin/lpc status " + this.printer + this.lpcQueueCom[UnixPrintServiceLookup.cmdIndex];
        String[] results = UnixPrintServiceLookup.execCmd(command);
        if (results != null && results.length > 0) {
            String queued;
            if (UnixPrintServiceLookup.cmdIndex == 1) {
                queued = results[0];
            } else {
                queued = results[3].trim();
                if (queued.startsWith("no")) {
                    return new QueuedJobCount(0);
                }
                queued = queued.substring(0, queued.indexOf(32));
            }
            try {
                qlen = Integer.parseInt(queued);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new QueuedJobCount(qlen);
    }

    private QueuedJobCount getQueuedJobCountAIX() {
        String command = "/usr/bin/lpstat -a" + this.printer;
        String[] results = UnixPrintServiceLookup.execCmd(command);
        results = UnixPrintService.filterPrinterNamesAIX(results);
        int qlen = 0;
        if (results != null && results.length > 0) {
            for (int i = 0; i < results.length; ++i) {
                if (!results[i].contains("QUEUED")) continue;
                ++qlen;
            }
        }
        return new QueuedJobCount(qlen);
    }

    private QueuedJobCount getQueuedJobCount() {
        if (UnixPrintServiceLookup.isSysV()) {
            return this.getQueuedJobCountSysV();
        }
        if (UnixPrintServiceLookup.isBSD()) {
            return this.getQueuedJobCountBSD();
        }
        if (UnixPrintServiceLookup.isAIX()) {
            return this.getQueuedJobCountAIX();
        }
        return new QueuedJobCount(0);
    }

    private PrintServiceAttributeSet getSysVServiceAttributes() {
        HashPrintServiceAttributeSet attrs = new HashPrintServiceAttributeSet();
        attrs.add(this.getQueuedJobCountSysV());
        attrs.add(this.getPrinterIsAcceptingJobsSysV());
        return attrs;
    }

    private PrintServiceAttributeSet getBSDServiceAttributes() {
        HashPrintServiceAttributeSet attrs = new HashPrintServiceAttributeSet();
        attrs.add(this.getQueuedJobCountBSD());
        attrs.add(this.getPrinterIsAcceptingJobsBSD());
        return attrs;
    }

    private PrintServiceAttributeSet getAIXServiceAttributes() {
        HashPrintServiceAttributeSet attrs = new HashPrintServiceAttributeSet();
        attrs.add(this.getQueuedJobCountAIX());
        attrs.add(this.getPrinterIsAcceptingJobsAIX());
        return attrs;
    }

    private boolean isSupportedCopies(Copies copies) {
        int numCopies = copies.getValue();
        return numCopies > 0 && numCopies < MAXCOPIES;
    }

    private boolean isSupportedMedia(MediaSizeName msn) {
        for (int i = 0; i < mediaSizes.length; ++i) {
            if (!msn.equals(mediaSizes[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public DocPrintJob createPrintJob() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPrintJobAccess();
        }
        return new UnixPrintJob(this);
    }

    private PrintServiceAttributeSet getDynamicAttributes() {
        if (UnixPrintServiceLookup.isSysV()) {
            return this.getSysVServiceAttributes();
        }
        if (UnixPrintServiceLookup.isAIX()) {
            return this.getAIXServiceAttributes();
        }
        return this.getBSDServiceAttributes();
    }

    @Override
    public PrintServiceAttributeSet getUpdatedAttributes() {
        PrintServiceAttributeSet currSet = this.getDynamicAttributes();
        if (this.lastSet == null) {
            this.lastSet = currSet;
            return AttributeSetUtilities.unmodifiableView(currSet);
        }
        HashPrintServiceAttributeSet updates = new HashPrintServiceAttributeSet();
        Attribute[] attrs = currSet.toArray();
        for (int i = 0; i < attrs.length; ++i) {
            Attribute attr = attrs[i];
            if (this.lastSet.containsValue(attr)) continue;
            updates.add(attr);
        }
        this.lastSet = currSet;
        return AttributeSetUtilities.unmodifiableView(updates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeNotifier() {
        UnixPrintService unixPrintService = this;
        synchronized (unixPrintService) {
            if (this.notifier != null) {
                this.notifier.wake();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrintServiceAttributeListener(PrintServiceAttributeListener listener) {
        UnixPrintService unixPrintService = this;
        synchronized (unixPrintService) {
            if (listener == null) {
                return;
            }
            if (this.notifier == null) {
                this.notifier = new ServiceNotifier(this);
            }
            this.notifier.addListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrintServiceAttributeListener(PrintServiceAttributeListener listener) {
        UnixPrintService unixPrintService = this;
        synchronized (unixPrintService) {
            if (listener == null || this.notifier == null) {
                return;
            }
            this.notifier.removeListener(listener);
            if (this.notifier.isEmpty()) {
                this.notifier.stopNotifier();
                this.notifier = null;
            }
        }
    }

    @Override
    public <T extends PrintServiceAttribute> T getAttribute(Class<T> category) {
        if (category == null) {
            throw new NullPointerException("category");
        }
        if (!PrintServiceAttribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException("Not a PrintServiceAttribute");
        }
        if (category == PrinterName.class) {
            return (T)this.getPrinterName();
        }
        if (category == PrinterState.class) {
            return (T)this.getPrinterState();
        }
        if (category == PrinterStateReasons.class) {
            return (T)this.getPrinterStateReasons();
        }
        if (category == QueuedJobCount.class) {
            return (T)this.getQueuedJobCount();
        }
        if (category == PrinterIsAcceptingJobs.class) {
            return (T)this.getPrinterIsAcceptingJobs();
        }
        return null;
    }

    @Override
    public PrintServiceAttributeSet getAttributes() {
        PrinterStateReasons prnStateReasons;
        HashPrintServiceAttributeSet attrs = new HashPrintServiceAttributeSet();
        attrs.add(this.getPrinterName());
        attrs.add(this.getPrinterIsAcceptingJobs());
        PrinterState prnState = this.getPrinterState();
        if (prnState != null) {
            attrs.add(prnState);
        }
        if ((prnStateReasons = this.getPrinterStateReasons()) != null) {
            attrs.add(prnStateReasons);
        }
        attrs.add(this.getQueuedJobCount());
        return AttributeSetUtilities.unmodifiableView(attrs);
    }

    private void initSupportedDocFlavors() {
        String hostEnc = DocFlavor.hostEncoding.toLowerCase(Locale.ENGLISH);
        if (!(hostEnc.equals("utf-8") || hostEnc.equals("utf-16") || hostEnc.equals("utf-16be") || hostEnc.equals("utf-16le") || hostEnc.equals("us-ascii"))) {
            int len = supportedDocFlavorsInit.length;
            DocFlavor[] flavors = new DocFlavor[len + supportedHostDocFlavors.length];
            System.arraycopy(supportedHostDocFlavors, 0, flavors, len, supportedHostDocFlavors.length);
            System.arraycopy(supportedDocFlavorsInit, 0, flavors, 0, len);
            supportedDocFlavors = flavors;
        } else {
            supportedDocFlavors = supportedDocFlavorsInit;
        }
    }

    @Override
    public DocFlavor[] getSupportedDocFlavors() {
        if (supportedDocFlavors == null) {
            this.initSupportedDocFlavors();
        }
        int len = supportedDocFlavors.length;
        DocFlavor[] flavors = new DocFlavor[len];
        System.arraycopy(supportedDocFlavors, 0, flavors, 0, len);
        return flavors;
    }

    @Override
    public boolean isDocFlavorSupported(DocFlavor flavor) {
        if (supportedDocFlavors == null) {
            this.initSupportedDocFlavors();
        }
        for (int f = 0; f < supportedDocFlavors.length; ++f) {
            if (!flavor.equals(supportedDocFlavors[f])) continue;
            return true;
        }
        return false;
    }

    public Class[] getSupportedAttributeCategories() {
        int totalCats = otherAttrCats.length;
        Class[] cats = new Class[totalCats];
        System.arraycopy(otherAttrCats, 0, cats, 0, otherAttrCats.length);
        return cats;
    }

    @Override
    public boolean isAttributeCategorySupported(Class<? extends Attribute> category) {
        if (category == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException(category + " is not an Attribute");
        }
        for (int i = 0; i < otherAttrCats.length; ++i) {
            if (category != otherAttrCats[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getDefaultAttributeValue(Class<? extends Attribute> category) {
        if (category == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException(category + " is not an Attribute");
        }
        if (!this.isAttributeCategorySupported(category)) {
            return null;
        }
        if (category == Copies.class) {
            return new Copies(1);
        }
        if (category == Chromaticity.class) {
            return Chromaticity.COLOR;
        }
        if (category == Destination.class) {
            try {
                return new Destination(new File("out.ps").toURI());
            }
            catch (SecurityException se) {
                try {
                    return new Destination(new URI("file:out.ps"));
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
        }
        if (category == Fidelity.class) {
            return Fidelity.FIDELITY_FALSE;
        }
        if (category == JobName.class) {
            return new JobName("Java Printing", null);
        }
        if (category == JobSheets.class) {
            return JobSheets.STANDARD;
        }
        if (category == Media.class) {
            String defaultCountry = Locale.getDefault().getCountry();
            if (defaultCountry != null && (defaultCountry.equals("") || defaultCountry.equals(Locale.US.getCountry()) || defaultCountry.equals(Locale.CANADA.getCountry()))) {
                return MediaSizeName.NA_LETTER;
            }
            return MediaSizeName.ISO_A4;
        }
        if (category == MediaPrintableArea.class) {
            float ih;
            float iw;
            String defaultCountry = Locale.getDefault().getCountry();
            if (defaultCountry != null && (defaultCountry.equals("") || defaultCountry.equals(Locale.US.getCountry()) || defaultCountry.equals(Locale.CANADA.getCountry()))) {
                iw = MediaSize.NA.LETTER.getX(25400) - 0.5f;
                ih = MediaSize.NA.LETTER.getY(25400) - 0.5f;
            } else {
                iw = MediaSize.ISO.A4.getX(25400) - 0.5f;
                ih = MediaSize.ISO.A4.getY(25400) - 0.5f;
            }
            return new MediaPrintableArea(0.25f, 0.25f, iw, ih, 25400);
        }
        if (category == OrientationRequested.class) {
            return OrientationRequested.PORTRAIT;
        }
        if (category == PageRanges.class) {
            return new PageRanges(1, Integer.MAX_VALUE);
        }
        if (category == RequestingUserName.class) {
            String userName = "";
            try {
                userName = System.getProperty("user.name", "");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return new RequestingUserName(userName, null);
        }
        if (category == SheetCollate.class) {
            return SheetCollate.UNCOLLATED;
        }
        if (category == Sides.class) {
            return Sides.ONE_SIDED;
        }
        return null;
    }

    private boolean isAutoSense(DocFlavor flavor) {
        return flavor.equals(DocFlavor.BYTE_ARRAY.AUTOSENSE) || flavor.equals(DocFlavor.INPUT_STREAM.AUTOSENSE) || flavor.equals(DocFlavor.URL.AUTOSENSE);
    }

    @Override
    public Object getSupportedAttributeValues(Class<? extends Attribute> category, DocFlavor flavor, AttributeSet attributes) {
        if (category == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException(category + " does not implement Attribute");
        }
        if (flavor != null) {
            if (!this.isDocFlavorSupported(flavor)) {
                throw new IllegalArgumentException(flavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(flavor)) {
                return null;
            }
        }
        if (!this.isAttributeCategorySupported(category)) {
            return null;
        }
        if (category == Chromaticity.class) {
            if (flavor == null || this.isServiceFormattedFlavor(flavor)) {
                Chromaticity[] arr = new Chromaticity[]{Chromaticity.COLOR};
                return arr;
            }
            return null;
        }
        if (category == Destination.class) {
            try {
                return new Destination(new File("out.ps").toURI());
            }
            catch (SecurityException se) {
                try {
                    return new Destination(new URI("file:out.ps"));
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
        }
        if (category == JobName.class) {
            return new JobName("Java Printing", null);
        }
        if (category == JobSheets.class) {
            JobSheets[] arr = new JobSheets[]{JobSheets.NONE, JobSheets.STANDARD};
            return arr;
        }
        if (category == RequestingUserName.class) {
            String userName = "";
            try {
                userName = System.getProperty("user.name", "");
            }
            catch (SecurityException e) {
                // empty catch block
            }
            return new RequestingUserName(userName, null);
        }
        if (category == OrientationRequested.class) {
            if (flavor == null || this.isServiceFormattedFlavor(flavor)) {
                OrientationRequested[] arr = new OrientationRequested[]{OrientationRequested.PORTRAIT, OrientationRequested.LANDSCAPE, OrientationRequested.REVERSE_LANDSCAPE};
                return arr;
            }
            return null;
        }
        if (category == Copies.class || category == CopiesSupported.class) {
            if (flavor == null || !flavor.equals(DocFlavor.INPUT_STREAM.POSTSCRIPT) && !flavor.equals(DocFlavor.URL.POSTSCRIPT) && !flavor.equals(DocFlavor.BYTE_ARRAY.POSTSCRIPT)) {
                return new CopiesSupported(1, MAXCOPIES);
            }
            return null;
        }
        if (category == Media.class) {
            Media[] arr = new Media[mediaSizes.length];
            System.arraycopy(mediaSizes, 0, arr, 0, mediaSizes.length);
            return arr;
        }
        if (category == Fidelity.class) {
            Fidelity[] arr = new Fidelity[]{Fidelity.FIDELITY_FALSE, Fidelity.FIDELITY_TRUE};
            return arr;
        }
        if (category == MediaPrintableArea.class) {
            if (attributes == null) {
                return this.getAllPrintableAreas();
            }
            MediaSize mediaSize = (MediaSize)attributes.get(MediaSize.class);
            Media media = (Media)attributes.get(Media.class);
            MediaPrintableArea[] arr = new MediaPrintableArea[1];
            if (mediaSize == null) {
                if (media instanceof MediaSizeName) {
                    MediaSizeName msn = (MediaSizeName)media;
                    mediaSize = MediaSize.getMediaSizeForName(msn);
                    if (mediaSize == null) {
                        media = (Media)this.getDefaultAttributeValue(Media.class);
                        if (media instanceof MediaSizeName) {
                            msn = (MediaSizeName)media;
                            mediaSize = MediaSize.getMediaSizeForName(msn);
                        }
                        if (mediaSize == null) {
                            arr[0] = new MediaPrintableArea(0.25f, 0.25f, 8.0f, 10.5f, 25400);
                            return arr;
                        }
                    }
                } else {
                    return this.getAllPrintableAreas();
                }
            }
            assert (mediaSize != null);
            arr[0] = new MediaPrintableArea(0.25f, 0.25f, mediaSize.getX(25400) - 0.5f, mediaSize.getY(25400) - 0.5f, 25400);
            return arr;
        }
        if (category == PageRanges.class) {
            if (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                PageRanges[] arr = new PageRanges[]{new PageRanges(1, Integer.MAX_VALUE)};
                return arr;
            }
            return null;
        }
        if (category == SheetCollate.class) {
            if (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                SheetCollate[] arr = new SheetCollate[]{SheetCollate.UNCOLLATED, SheetCollate.COLLATED};
                return arr;
            }
            return null;
        }
        if (category == Sides.class) {
            if (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                Sides[] arr = new Sides[]{Sides.ONE_SIDED, Sides.TWO_SIDED_LONG_EDGE, Sides.TWO_SIDED_SHORT_EDGE};
                return arr;
            }
            return null;
        }
        return null;
    }

    private MediaPrintableArea[] getAllPrintableAreas() {
        if (mpas == null) {
            Media[] media = (Media[])this.getSupportedAttributeValues(Media.class, null, null);
            mpas = new MediaPrintableArea[media.length];
            for (int i = 0; i < mpas.length; ++i) {
                if (!(media[i] instanceof MediaSizeName)) continue;
                MediaSizeName msn = (MediaSizeName)media[i];
                MediaSize mediaSize = MediaSize.getMediaSizeForName(msn);
                UnixPrintService.mpas[i] = mediaSize == null ? (MediaPrintableArea)this.getDefaultAttributeValue(MediaPrintableArea.class) : new MediaPrintableArea(0.25f, 0.25f, mediaSize.getX(25400) - 0.5f, mediaSize.getY(25400) - 0.5f, 25400);
            }
        }
        MediaPrintableArea[] mpasCopy = new MediaPrintableArea[mpas.length];
        System.arraycopy(mpas, 0, mpasCopy, 0, mpas.length);
        return mpasCopy;
    }

    private boolean isServiceFormattedFlavor(DocFlavor flavor) {
        return flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || flavor.equals(DocFlavor.BYTE_ARRAY.GIF) || flavor.equals(DocFlavor.INPUT_STREAM.GIF) || flavor.equals(DocFlavor.URL.GIF) || flavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || flavor.equals(DocFlavor.INPUT_STREAM.JPEG) || flavor.equals(DocFlavor.URL.JPEG) || flavor.equals(DocFlavor.BYTE_ARRAY.PNG) || flavor.equals(DocFlavor.INPUT_STREAM.PNG) || flavor.equals(DocFlavor.URL.PNG);
    }

    @Override
    public boolean isAttributeValueSupported(Attribute attr, DocFlavor flavor, AttributeSet attributes) {
        Class<? extends Attribute> category;
        if (attr == null) {
            throw new NullPointerException("null attribute");
        }
        if (flavor != null) {
            if (!this.isDocFlavorSupported(flavor)) {
                throw new IllegalArgumentException(flavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(flavor)) {
                return false;
            }
        }
        if (!this.isAttributeCategorySupported(category = attr.getCategory())) {
            return false;
        }
        if (attr.getCategory() == Chromaticity.class) {
            if (flavor == null || this.isServiceFormattedFlavor(flavor)) {
                return attr == Chromaticity.COLOR;
            }
            return false;
        }
        if (attr.getCategory() == Copies.class) {
            return (flavor == null || !flavor.equals(DocFlavor.INPUT_STREAM.POSTSCRIPT) && !flavor.equals(DocFlavor.URL.POSTSCRIPT) && !flavor.equals(DocFlavor.BYTE_ARRAY.POSTSCRIPT)) && this.isSupportedCopies((Copies)attr);
        }
        if (attr.getCategory() == Destination.class) {
            URI uri = ((Destination)attr).getURI();
            return "file".equals(uri.getScheme()) && !uri.getSchemeSpecificPart().equals("");
        }
        if (attr.getCategory() == Media.class) {
            if (attr instanceof MediaSizeName) {
                return this.isSupportedMedia((MediaSizeName)attr);
            }
            return false;
        }
        return !(attr.getCategory() == OrientationRequested.class ? attr == OrientationRequested.REVERSE_PORTRAIT || flavor != null && !this.isServiceFormattedFlavor(flavor) : (attr.getCategory() == PageRanges.class ? flavor != null && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) : (attr.getCategory() == SheetCollate.class ? flavor != null && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) : attr.getCategory() == Sides.class && flavor != null && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE))));
    }

    @Override
    public AttributeSet getUnsupportedAttributes(DocFlavor flavor, AttributeSet attributes) {
        if (flavor != null && !this.isDocFlavorSupported(flavor)) {
            throw new IllegalArgumentException("flavor " + flavor + "is not supported");
        }
        if (attributes == null) {
            return null;
        }
        HashAttributeSet unsupp = new HashAttributeSet();
        Attribute[] attrs = attributes.toArray();
        for (int i = 0; i < attrs.length; ++i) {
            try {
                Attribute attr = attrs[i];
                if (!this.isAttributeCategorySupported(attr.getCategory())) {
                    unsupp.add(attr);
                    continue;
                }
                if (this.isAttributeValueSupported(attr, flavor, attributes)) continue;
                unsupp.add(attr);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (unsupp.isEmpty()) {
            return null;
        }
        return unsupp;
    }

    @Override
    public ServiceUIFactory getServiceUIFactory() {
        return null;
    }

    public String toString() {
        return "Unix Printer : " + this.getName();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof UnixPrintService && ((UnixPrintService)obj).getName().equals(this.getName());
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + this.getName().hashCode();
    }

    @Override
    public boolean usesClass(Class c) {
        return c == PSPrinterJob.class;
    }

    static {
        supportedDocFlavors = null;
        supportedDocFlavorsInit = new DocFlavor[]{DocFlavor.BYTE_ARRAY.POSTSCRIPT, DocFlavor.INPUT_STREAM.POSTSCRIPT, DocFlavor.URL.POSTSCRIPT, DocFlavor.BYTE_ARRAY.GIF, DocFlavor.INPUT_STREAM.GIF, DocFlavor.URL.GIF, DocFlavor.BYTE_ARRAY.JPEG, DocFlavor.INPUT_STREAM.JPEG, DocFlavor.URL.JPEG, DocFlavor.BYTE_ARRAY.PNG, DocFlavor.INPUT_STREAM.PNG, DocFlavor.URL.PNG, DocFlavor.CHAR_ARRAY.TEXT_PLAIN, DocFlavor.READER.TEXT_PLAIN, DocFlavor.STRING.TEXT_PLAIN, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_8, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_16, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_16BE, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_16LE, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_US_ASCII, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_8, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_16, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_16BE, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_16LE, DocFlavor.INPUT_STREAM.TEXT_PLAIN_US_ASCII, DocFlavor.URL.TEXT_PLAIN_UTF_8, DocFlavor.URL.TEXT_PLAIN_UTF_16, DocFlavor.URL.TEXT_PLAIN_UTF_16BE, DocFlavor.URL.TEXT_PLAIN_UTF_16LE, DocFlavor.URL.TEXT_PLAIN_US_ASCII, DocFlavor.SERVICE_FORMATTED.PAGEABLE, DocFlavor.SERVICE_FORMATTED.PRINTABLE, DocFlavor.BYTE_ARRAY.AUTOSENSE, DocFlavor.URL.AUTOSENSE, DocFlavor.INPUT_STREAM.AUTOSENSE};
        supportedHostDocFlavors = new DocFlavor[]{DocFlavor.BYTE_ARRAY.TEXT_PLAIN_HOST, DocFlavor.INPUT_STREAM.TEXT_PLAIN_HOST, DocFlavor.URL.TEXT_PLAIN_HOST};
        encoding = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
        serviceAttrCats = new Class[]{PrinterName.class, PrinterIsAcceptingJobs.class, QueuedJobCount.class};
        otherAttrCats = new Class[]{Chromaticity.class, Copies.class, Destination.class, Fidelity.class, JobName.class, JobSheets.class, Media.class, MediaPrintableArea.class, OrientationRequested.class, PageRanges.class, RequestingUserName.class, SheetCollate.class, Sides.class};
        MAXCOPIES = 1000;
        mediaSizes = new MediaSizeName[]{MediaSizeName.NA_LETTER, MediaSizeName.TABLOID, MediaSizeName.LEDGER, MediaSizeName.NA_LEGAL, MediaSizeName.EXECUTIVE, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5};
        mpas = null;
    }
}

