/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.DiagnosticCommandMBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import sun.management.DiagnosticCommandArgumentInfo;
import sun.management.DiagnosticCommandInfo;
import sun.management.NotificationEmitterSupport;
import sun.management.VMManagement;

class DiagnosticCommandImpl
extends NotificationEmitterSupport
implements DiagnosticCommandMBean {
    private final VMManagement jvm;
    private volatile Map<String, Wrapper> wrappers = null;
    private static final String strClassName = "".getClass().getName();
    private static final String strArrayClassName = String[].class.getName();
    private final boolean isSupported;
    private static final String notifName = "javax.management.Notification";
    private static final String[] diagFramNotifTypes = new String[]{"jmx.mbean.info.changed"};
    private MBeanNotificationInfo[] notifInfo = null;
    private static long seqNumber = 0L;

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException(attribute);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException(attribute.getName());
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        return new AttributeList();
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return new AttributeList();
    }

    DiagnosticCommandImpl(VMManagement jvm) {
        this.jvm = jvm;
        this.isSupported = jvm.isRemoteDiagnosticCommandsSupported();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        HashMap<String, Wrapper> wrappersmap;
        TreeSet<MBeanOperationInfo> operations = new TreeSet<MBeanOperationInfo>(new OperationInfoComparator());
        if (!this.isSupported) {
            wrappersmap = Collections.EMPTY_MAP;
        } else {
            try {
                String[] command = this.getDiagnosticCommands();
                DiagnosticCommandInfo[] info = this.getDiagnosticCommandInfo(command);
                MBeanParameterInfo[] stringArgInfo = new MBeanParameterInfo[]{new MBeanParameterInfo("arguments", strArrayClassName, "Array of Diagnostic Commands Arguments and Options")};
                wrappersmap = new HashMap<String, Wrapper>();
                for (int i = 0; i < command.length; ++i) {
                    String name = DiagnosticCommandImpl.transform(command[i]);
                    try {
                        Wrapper w = new Wrapper(name, command[i], info[i]);
                        wrappersmap.put(name, w);
                        operations.add(new MBeanOperationInfo(w.name, w.info.getDescription(), w.info.getArgumentsInfo() == null || w.info.getArgumentsInfo().isEmpty() ? null : stringArgInfo, strClassName, 2, this.commandDescriptor(w)));
                        continue;
                    }
                    catch (InstantiationException instantiationException) {
                        // empty catch block
                    }
                }
            }
            catch (IllegalArgumentException | UnsupportedOperationException e) {
                wrappersmap = Collections.EMPTY_MAP;
            }
        }
        this.wrappers = Collections.unmodifiableMap(wrappersmap);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("immutableInfo", "false");
        map.put("interfaceClassName", "com.sun.management.DiagnosticCommandMBean");
        map.put("mxbean", "false");
        ImmutableDescriptor desc = new ImmutableDescriptor(map);
        return new MBeanInfo(this.getClass().getName(), "Diagnostic Commands", null, null, operations.toArray(new MBeanOperationInfo[operations.size()]), this.getNotificationInfo(), desc);
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Wrapper w;
        if (!this.isSupported) {
            throw new UnsupportedOperationException();
        }
        if (this.wrappers == null) {
            this.getMBeanInfo();
        }
        if ((w = this.wrappers.get(actionName)) != null) {
            if (!(!w.info.getArgumentsInfo().isEmpty() || params != null && params.length != 0 || signature != null && signature.length != 0)) {
                return w.execute(null);
            }
            if (params != null && params.length == 1 && signature != null && signature.length == 1 && signature[0] != null && signature[0].compareTo(strArrayClassName) == 0) {
                return w.execute((String[])params[0]);
            }
        }
        throw new ReflectionException(new NoSuchMethodException(actionName));
    }

    private static String transform(String name) {
        StringBuilder sb = new StringBuilder();
        boolean toLower = true;
        boolean toUpper = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '.' || c == '_') {
                toLower = false;
                toUpper = true;
                continue;
            }
            if (toUpper) {
                toUpper = false;
                sb.append(Character.toUpperCase(c));
                continue;
            }
            if (toLower) {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private Descriptor commandDescriptor(Wrapper w) throws IllegalArgumentException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dcmd.name", w.info.getName());
        map.put("dcmd.description", w.info.getDescription());
        map.put("dcmd.vmImpact", w.info.getImpact());
        map.put("dcmd.permissionClass", w.info.getPermissionClass());
        map.put("dcmd.permissionName", w.info.getPermissionName());
        map.put("dcmd.permissionAction", w.info.getPermissionAction());
        map.put("dcmd.enabled", w.info.isEnabled());
        StringBuilder sb = new StringBuilder();
        sb.append("help ");
        sb.append(w.info.getName());
        map.put("dcmd.help", this.executeDiagnosticCommand(sb.toString()));
        if (w.info.getArgumentsInfo() != null && !w.info.getArgumentsInfo().isEmpty()) {
            HashMap<String, ImmutableDescriptor> allargmap = new HashMap<String, ImmutableDescriptor>();
            for (DiagnosticCommandArgumentInfo arginfo : w.info.getArgumentsInfo()) {
                HashMap<String, Object> argmap = new HashMap<String, Object>();
                argmap.put("dcmd.arg.name", arginfo.getName());
                argmap.put("dcmd.arg.type", arginfo.getType());
                argmap.put("dcmd.arg.description", arginfo.getDescription());
                argmap.put("dcmd.arg.isMandatory", arginfo.isMandatory());
                argmap.put("dcmd.arg.isMultiple", arginfo.isMultiple());
                boolean isOption = arginfo.isOption();
                argmap.put("dcmd.arg.isOption", isOption);
                if (!isOption) {
                    argmap.put("dcmd.arg.position", arginfo.getPosition());
                } else {
                    argmap.put("dcmd.arg.position", -1);
                }
                allargmap.put(arginfo.getName(), new ImmutableDescriptor(argmap));
            }
            map.put("dcmd.arguments", new ImmutableDescriptor(allargmap));
        }
        return new ImmutableDescriptor(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        DiagnosticCommandImpl diagnosticCommandImpl = this;
        synchronized (diagnosticCommandImpl) {
            if (this.notifInfo == null) {
                this.notifInfo = new MBeanNotificationInfo[1];
                this.notifInfo[0] = new MBeanNotificationInfo(diagFramNotifTypes, notifName, "Diagnostic Framework Notification");
            }
        }
        return this.notifInfo;
    }

    private static long getNextSeqNumber() {
        return ++seqNumber;
    }

    private void createDiagnosticFrameworkNotification() {
        if (!this.hasListeners()) {
            return;
        }
        ObjectName on = null;
        try {
            on = ObjectName.getInstance("com.sun.management:type=DiagnosticCommand");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        Notification notif = new Notification("jmx.mbean.info.changed", on, DiagnosticCommandImpl.getNextSeqNumber());
        notif.setUserData(this.getMBeanInfo());
        this.sendNotification(notif);
    }

    @Override
    public synchronized void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        boolean before = this.hasListeners();
        super.addNotificationListener(listener, filter, handback);
        boolean after = this.hasListeners();
        if (!before && after) {
            this.setNotificationEnabled(true);
        }
    }

    @Override
    public synchronized void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        boolean before = this.hasListeners();
        super.removeNotificationListener(listener);
        boolean after = this.hasListeners();
        if (before && !after) {
            this.setNotificationEnabled(false);
        }
    }

    @Override
    public synchronized void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        boolean before = this.hasListeners();
        super.removeNotificationListener(listener, filter, handback);
        boolean after = this.hasListeners();
        if (before && !after) {
            this.setNotificationEnabled(false);
        }
    }

    private native void setNotificationEnabled(boolean var1);

    private native String[] getDiagnosticCommands();

    private native DiagnosticCommandInfo[] getDiagnosticCommandInfo(String[] var1);

    private native String executeDiagnosticCommand(String var1);

    private static class OperationInfoComparator
    implements Comparator<MBeanOperationInfo> {
        private OperationInfoComparator() {
        }

        @Override
        public int compare(MBeanOperationInfo o1, MBeanOperationInfo o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private class Wrapper {
        String name;
        String cmd;
        DiagnosticCommandInfo info;
        Permission permission;

        Wrapper(String name, String cmd, DiagnosticCommandInfo info) throws InstantiationException {
            this.name = name;
            this.cmd = cmd;
            this.info = info;
            this.permission = null;
            Exception cause = null;
            if (info.getPermissionClass() != null) {
                try {
                    Constructor<?> constructor;
                    Class<?> c = Class.forName(info.getPermissionClass());
                    if (info.getPermissionAction() == null) {
                        try {
                            constructor = c.getConstructor(String.class);
                            this.permission = (Permission)constructor.newInstance(info.getPermissionName());
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                            cause = ex;
                        }
                    }
                    if (this.permission == null) {
                        try {
                            constructor = c.getConstructor(String.class, String.class);
                            this.permission = (Permission)constructor.newInstance(info.getPermissionName(), info.getPermissionAction());
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                            cause = ex;
                        }
                    }
                }
                catch (ClassNotFoundException c) {
                    // empty catch block
                }
                if (this.permission == null) {
                    InstantiationException iex = new InstantiationException("Unable to instantiate required permission");
                    iex.initCause(cause);
                }
            }
        }

        public String execute(String[] args) {
            SecurityManager sm;
            if (this.permission != null && (sm = System.getSecurityManager()) != null) {
                sm.checkPermission(this.permission);
            }
            if (args == null) {
                return DiagnosticCommandImpl.this.executeDiagnosticCommand(this.cmd);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.cmd);
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) {
                    throw new IllegalArgumentException("Invalid null argument");
                }
                sb.append(" ");
                sb.append(args[i]);
            }
            return DiagnosticCommandImpl.this.executeDiagnosticCommand(sb.toString());
        }
    }
}

