/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Timer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.opensaml.saml.saml2.metadata.provider.AbstractReloadingMetadataProvider;
import org.opensaml.saml.saml2.metadata.provider.MetadataProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPMetadataProvider
extends AbstractReloadingMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(HTTPMetadataProvider.class);
    private HttpClient httpClient;
    private URI metadataURI;
    private String cachedMetadataETag;
    private String cachedMetadataLastModified;
    private AuthScope authScope;

    @Deprecated
    public HTTPMetadataProvider(String metadataURL, int requestTimeout) throws MetadataProviderException {
        try {
            this.metadataURI = new URI(metadataURL);
        }
        catch (URISyntaxException e) {
            throw new MetadataProviderException("Illegal URL syntax", (Exception)e);
        }
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setSoTimeout(requestTimeout);
        this.httpClient = new HttpClient(clientParams);
        this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(requestTimeout);
        this.authScope = new AuthScope(this.metadataURI.getHost(), this.metadataURI.getPort());
    }

    public HTTPMetadataProvider(Timer backgroundTaskTimer, HttpClient client, String metadataURL) throws MetadataProviderException {
        super(backgroundTaskTimer);
        if (client == null) {
            throw new MetadataProviderException("HTTP client may not be null");
        }
        this.httpClient = client;
        try {
            this.metadataURI = new URI(metadataURL);
        }
        catch (URISyntaxException e) {
            throw new MetadataProviderException("Illegal URL syntax", (Exception)e);
        }
        this.authScope = new AuthScope(this.metadataURI.getHost(), this.metadataURI.getPort());
    }

    public String getMetadataURI() {
        return this.metadataURI.toASCIIString();
    }

    public void setBasicCredentials(String username, String password) {
        if (username == null && password == null) {
            this.httpClient.getState().setCredentials(null, null);
        } else {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
            this.httpClient.getState().setCredentials(this.authScope, (Credentials)credentials);
        }
    }

    public int getRequestTimeout() {
        return this.httpClient.getParams().getSoTimeout();
    }

    public void setSocketFactory(ProtocolSocketFactory newSocketFactory) {
        this.log.debug("Using the custom socket factory {} to connect to the HTTP server", (Object)newSocketFactory.getClass().getName());
        Protocol protocol = new Protocol(this.metadataURI.getScheme(), newSocketFactory, this.metadataURI.getPort());
        this.httpClient.getHostConfiguration().setHost(this.metadataURI.getHost(), this.metadataURI.getPort(), protocol);
    }

    public int getMaxCacheDuration() {
        return (int)this.getMaxRefreshDelay();
    }

    public void setMaxCacheDuration(int newDuration) {
        this.setMaxRefreshDelay(newDuration * 1000);
    }

    public boolean maintainExpiredMetadata() {
        return !this.requireValidMetadata();
    }

    public void setMaintainExpiredMetadata(boolean maintain) {
        this.setRequireValidMetadata(!maintain);
    }

    @Override
    protected String getMetadataIdentifier() {
        return this.metadataURI.toString();
    }

    @Override
    protected byte[] fetchMetadata() throws MetadataProviderException {
        GetMethod getMethod = this.buildGetMethod();
        try {
            this.log.debug("Attempting to fetch metadata document from '{}'", (Object)this.metadataURI);
            this.httpClient.executeMethod((HttpMethod)getMethod);
            int httpStatus = getMethod.getStatusCode();
            if (httpStatus == 304) {
                this.log.debug("Metadata document from '{}' has not changed since last retrieval", (Object)this.getMetadataURI());
                return null;
            }
            if (getMethod.getStatusCode() != 200) {
                String errMsg = "Non-ok status code " + getMethod.getStatusCode() + " returned from remote metadata source " + this.metadataURI;
                this.log.error(errMsg);
                throw new MetadataProviderException(errMsg);
            }
            this.processConditionalRetrievalHeaders(getMethod);
            byte[] rawMetadata = this.getMetadataBytesFromResponse(getMethod);
            this.log.debug("Successfully fetched {}bytes of metadata from {}", (Object)rawMetadata.length, (Object)this.getMetadataURI());
            return rawMetadata;
        }
        catch (IOException e) {
            String errMsg = "Error retrieving metadata from " + this.metadataURI;
            this.log.error(errMsg, (Throwable)e);
            throw new MetadataProviderException(errMsg, (Exception)e);
        }
    }

    protected GetMethod buildGetMethod() {
        GetMethod getMethod = new GetMethod(this.getMetadataURI());
        getMethod.setRequestHeader("Accept-Encoding", "gzip,deflate");
        if (this.cachedMetadataETag != null) {
            getMethod.setRequestHeader("If-None-Match", this.cachedMetadataETag);
        }
        if (this.cachedMetadataLastModified != null) {
            getMethod.setRequestHeader("If-Modified-Since", this.cachedMetadataLastModified);
        }
        if (this.httpClient.getState().getCredentials(this.authScope) != null) {
            this.log.debug("Using BASIC authentication when retrieving metadata from '{}", (Object)this.metadataURI);
            getMethod.setDoAuthentication(true);
        }
        return getMethod;
    }

    protected void processConditionalRetrievalHeaders(GetMethod getMethod) {
        Header httpHeader = getMethod.getResponseHeader("ETag");
        if (httpHeader != null) {
            this.cachedMetadataETag = httpHeader.getValue();
        }
        if ((httpHeader = getMethod.getResponseHeader("Last-Modified")) != null) {
            this.cachedMetadataLastModified = httpHeader.getValue();
        }
    }

    protected byte[] getMetadataBytesFromResponse(GetMethod getMethod) throws MetadataProviderException {
        this.log.debug("Attempting to extract metadata from response to request for metadata from '{}'", (Object)this.getMetadataURI());
        try {
            InputStream ins = getMethod.getResponseBodyAsStream();
            Header httpHeader = getMethod.getResponseHeader("Content-Encoding");
            if (httpHeader != null) {
                String contentEncoding = httpHeader.getValue();
                if ("deflate".equalsIgnoreCase(contentEncoding)) {
                    this.log.debug("Metadata document from '{}' was deflate compressed, decompressing it", (Object)this.metadataURI);
                    ins = new InflaterInputStream(ins);
                }
                if ("gzip".equalsIgnoreCase(contentEncoding)) {
                    this.log.debug("Metadata document from '{}' was GZip compressed, decompressing it", (Object)this.metadataURI);
                    ins = new GZIPInputStream(ins);
                }
            }
            return this.inputstreamToByteArray(ins);
        }
        catch (IOException e) {
            this.log.error("Unable to read response", (Throwable)e);
            throw new MetadataProviderException("Unable to read response", (Exception)e);
        }
    }
}

