/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.collection.LazySet;
import org.joda.time.DateTime;
import org.opensaml.core.xml.Namespace;
import org.opensaml.core.xml.NamespaceManager;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.util.IDIndex;
import org.opensaml.saml.saml2.common.Extensions;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.provider.BaseMetadataProvider;
import org.opensaml.saml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.saml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.saml.saml2.metadata.provider.ObservableMetadataProvider;
import org.opensaml.xmlsec.signature.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ChainingMetadataProvider
extends BaseMetadataProvider
implements ObservableMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(ChainingMetadataProvider.class);
    private List<ObservableMetadataProvider.Observer> observers = new CopyOnWriteArrayList<ObservableMetadataProvider.Observer>();
    private List<MetadataProvider> providers = Collections.EMPTY_LIST;
    private ReadWriteLock providerLock = new ReentrantReadWriteLock(true);

    public List<MetadataProvider> getProviders() {
        return this.providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProviders(List<MetadataProvider> newProviders) throws MetadataProviderException {
        Lock writeLock = this.providerLock.writeLock();
        writeLock.lock();
        try {
            if (newProviders == null || newProviders.isEmpty()) {
                this.providers.clear();
                return;
            }
            ArrayList<MetadataProvider> checkedProviders = new ArrayList<MetadataProvider>();
            for (MetadataProvider provider : newProviders) {
                this.doAddMetadataProvider(provider, checkedProviders);
            }
            this.providers = Collections.unmodifiableList(checkedProviders);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetadataProvider(MetadataProvider newProvider) throws MetadataProviderException {
        Lock writeLock = this.providerLock.writeLock();
        writeLock.lock();
        try {
            ArrayList<MetadataProvider> checkedProviders = new ArrayList<MetadataProvider>(this.providers);
            this.doAddMetadataProvider(newProvider, checkedProviders);
            this.providers = Collections.unmodifiableList(checkedProviders);
        }
        finally {
            writeLock.unlock();
        }
    }

    protected void doAddMetadataProvider(MetadataProvider provider, List<MetadataProvider> providerList) {
        if (provider != null) {
            provider.setRequireValidMetadata(this.requireValidMetadata());
            if (provider instanceof ObservableMetadataProvider) {
                ((ObservableMetadataProvider)provider).getObservers().add(new ContainedProviderObserver());
            }
            providerList.add(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetadataProvider(MetadataProvider provider) {
        Lock writeLock = this.providerLock.writeLock();
        writeLock.lock();
        try {
            if (this.providers.remove(provider) && provider instanceof ObservableMetadataProvider) {
                ObservableMetadataProvider observableProvider = (ObservableMetadataProvider)provider;
                for (ObservableMetadataProvider.Observer observer : observableProvider.getObservers()) {
                    if (!(observer instanceof ContainedProviderObserver)) continue;
                    observableProvider.getObservers().remove(observer);
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequireValidMetadata(boolean requireValidMetadata) {
        super.setRequireValidMetadata(requireValidMetadata);
        Lock writeLock = this.providerLock.writeLock();
        writeLock.lock();
        try {
            for (MetadataProvider provider : this.providers) {
                provider.setRequireValidMetadata(requireValidMetadata);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public MetadataFilter getMetadataFilter() {
        this.log.warn("Attempt to access unsupported MetadataFilter property on ChainingMetadataProvider");
        return null;
    }

    @Override
    public void setMetadataFilter(MetadataFilter newFilter) throws MetadataProviderException {
        throw new UnsupportedOperationException("Metadata filters are not supported on ChainingMetadataProviders");
    }

    public XMLObject getMetadata() throws MetadataProviderException {
        return new ChainingEntitiesDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntitiesDescriptor getEntitiesDescriptor(String name) throws MetadataProviderException {
        Lock readLock = this.providerLock.readLock();
        readLock.lock();
        EntitiesDescriptor descriptor = null;
        try {
            for (MetadataProvider provider : this.providers) {
                this.log.debug("Checking child metadata provider for entities descriptor with name: {}", (Object)name);
                try {
                    descriptor = provider.getEntitiesDescriptor(name);
                    if (descriptor == null) continue;
                    break;
                }
                catch (MetadataProviderException e) {
                    this.log.warn("Error retrieving metadata from provider of type {}, proceeding to next provider", (Object)provider.getClass().getName(), (Object)e);
                }
            }
        }
        finally {
            readLock.unlock();
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityDescriptor getEntityDescriptor(String entityID) throws MetadataProviderException {
        Lock readLock = this.providerLock.readLock();
        readLock.lock();
        EntityDescriptor descriptor = null;
        try {
            for (MetadataProvider provider : this.providers) {
                this.log.debug("Checking child metadata provider for entity descriptor with entity ID: {}", (Object)entityID);
                try {
                    descriptor = provider.getEntityDescriptor(entityID);
                    if (descriptor == null) continue;
                    break;
                }
                catch (MetadataProviderException e) {
                    this.log.warn("Error retrieving metadata from provider of type {}, proceeding to next provider", (Object)provider.getClass().getName(), (Object)e);
                }
            }
        }
        finally {
            readLock.unlock();
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RoleDescriptor> getRole(String entityID, QName roleName) throws MetadataProviderException {
        Lock readLock = this.providerLock.readLock();
        readLock.lock();
        List roleDescriptors = null;
        try {
            for (MetadataProvider provider : this.providers) {
                this.log.debug("Checking child metadata provider for entity descriptor with entity ID: {}", (Object)entityID);
                try {
                    roleDescriptors = provider.getRole(entityID, roleName);
                    if (roleDescriptors == null || roleDescriptors.isEmpty()) continue;
                    break;
                }
                catch (MetadataProviderException e) {
                    this.log.warn("Error retrieving metadata from provider of type {}, proceeding to next provider", (Object)provider.getClass().getName(), (Object)e);
                }
            }
        }
        finally {
            readLock.unlock();
        }
        return roleDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoleDescriptor getRole(String entityID, QName roleName, String supportedProtocol) throws MetadataProviderException {
        Lock readLock = this.providerLock.readLock();
        readLock.lock();
        RoleDescriptor roleDescriptor = null;
        try {
            for (MetadataProvider provider : this.providers) {
                this.log.debug("Checking child metadata provider for entity descriptor with entity ID: {}", (Object)entityID);
                try {
                    roleDescriptor = provider.getRole(entityID, roleName, supportedProtocol);
                    if (roleDescriptor == null) continue;
                    break;
                }
                catch (MetadataProviderException e) {
                    this.log.warn("Error retrieving metadata from provider of type {}, proceeding to next provider", (Object)provider.getClass().getName(), (Object)e);
                }
            }
        }
        finally {
            readLock.unlock();
        }
        return roleDescriptor;
    }

    @Override
    public List<ObservableMetadataProvider.Observer> getObservers() {
        return this.observers;
    }

    protected void emitChangeEvent() {
        if (this.observers == null || this.observers.size() == 0) {
            return;
        }
        ArrayList<ObservableMetadataProvider.Observer> tempObserverList = new ArrayList<ObservableMetadataProvider.Observer>(this.observers);
        for (ObservableMetadataProvider.Observer observer : tempObserverList) {
            if (observer == null) continue;
            observer.onEvent(this);
        }
    }

    private class ChainingEntitiesDescriptor
    implements EntitiesDescriptor {
        private ArrayList<XMLObject> childDescriptors = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChainingEntitiesDescriptor() {
            Lock readLock = ChainingMetadataProvider.this.providerLock.readLock();
            readLock.lock();
            try {
                for (MetadataProvider provider : ChainingMetadataProvider.this.providers) {
                    this.childDescriptors.add(provider.getMetadata());
                }
            }
            catch (MetadataProviderException e) {
                ChainingMetadataProvider.this.log.error("Unable to get metadata from child metadata provider", (Throwable)e);
            }
            finally {
                readLock.unlock();
            }
        }

        public List<EntitiesDescriptor> getEntitiesDescriptors() {
            ArrayList<EntitiesDescriptor> descriptors = new ArrayList<EntitiesDescriptor>();
            for (XMLObject descriptor : this.childDescriptors) {
                if (!(descriptor instanceof EntitiesDescriptor)) continue;
                descriptors.add((EntitiesDescriptor)descriptor);
            }
            return descriptors;
        }

        public List<EntityDescriptor> getEntityDescriptors() {
            ArrayList<EntityDescriptor> descriptors = new ArrayList<EntityDescriptor>();
            for (XMLObject descriptor : this.childDescriptors) {
                if (!(descriptor instanceof EntityDescriptor)) continue;
                descriptors.add((EntityDescriptor)descriptor);
            }
            return descriptors;
        }

        public Extensions getExtensions() {
            return null;
        }

        public String getID() {
            return null;
        }

        public String getName() {
            return null;
        }

        public void setExtensions(Extensions extensions) {
        }

        public void setID(String newID) {
        }

        public void setName(String name) {
        }

        public String getSignatureReferenceID() {
            return null;
        }

        public Signature getSignature() {
            return null;
        }

        public boolean isSigned() {
            return false;
        }

        public void setSignature(Signature newSignature) {
        }

        public void detach() {
        }

        public Element getDOM() {
            return null;
        }

        public QName getElementQName() {
            return EntitiesDescriptor.DEFAULT_ELEMENT_NAME;
        }

        public IDIndex getIDIndex() {
            return null;
        }

        public NamespaceManager getNamespaceManager() {
            return null;
        }

        public Set<Namespace> getNamespaces() {
            return new LazySet();
        }

        public String getNoNamespaceSchemaLocation() {
            return null;
        }

        public List<XMLObject> getOrderedChildren() {
            ArrayList<XMLObject> descriptors = new ArrayList<XMLObject>();
            try {
                for (MetadataProvider provider : ChainingMetadataProvider.this.providers) {
                    descriptors.add(provider.getMetadata());
                }
            }
            catch (MetadataProviderException e) {
                ChainingMetadataProvider.this.log.error("Unable to generate list of child descriptors", (Throwable)e);
            }
            return descriptors;
        }

        public XMLObject getParent() {
            return null;
        }

        public String getSchemaLocation() {
            return null;
        }

        public QName getSchemaType() {
            return EntitiesDescriptor.TYPE_NAME;
        }

        public boolean hasChildren() {
            return !this.getOrderedChildren().isEmpty();
        }

        public boolean hasParent() {
            return false;
        }

        public void releaseChildrenDOM(boolean propagateRelease) {
        }

        public void releaseDOM() {
        }

        public void releaseParentDOM(boolean propagateRelease) {
        }

        public XMLObject resolveID(String id) {
            return null;
        }

        public XMLObject resolveIDFromRoot(String id) {
            return null;
        }

        public void setDOM(Element dom) {
        }

        public void setNoNamespaceSchemaLocation(String location) {
        }

        public void setParent(XMLObject parent) {
        }

        public void setSchemaLocation(String location) {
        }

        public DateTime getValidUntil() {
            return null;
        }

        public boolean isValid() {
            return true;
        }

        public void setValidUntil(DateTime validUntil) {
        }

        public Long getCacheDuration() {
            return null;
        }

        public void setCacheDuration(Long duration) {
        }

        public Boolean isNil() {
            return Boolean.FALSE;
        }

        public XSBooleanValue isNilXSBoolean() {
            return new XSBooleanValue(Boolean.FALSE, false);
        }

        public void setNil(Boolean arg0) {
        }

        public void setNil(XSBooleanValue arg0) {
        }
    }

    private class ContainedProviderObserver
    implements ObservableMetadataProvider.Observer {
        private ContainedProviderObserver() {
        }

        @Override
        public void onEvent(MetadataProvider provider) {
            ChainingMetadataProvider.this.emitChangeEvent();
        }
    }
}

