/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.saml.common.AbstractSignableSAMLObject;
import org.opensaml.saml.saml2.common.Extensions;
import org.opensaml.saml.saml2.metadata.AdditionalMetadataLocation;
import org.opensaml.saml.saml2.metadata.AffiliationDescriptor;
import org.opensaml.saml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml.saml2.metadata.AuthnAuthorityDescriptor;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.PDPDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;

public class EntityDescriptorImpl
extends AbstractSignableSAMLObject
implements EntityDescriptor {
    private String entityID;
    private String id;
    private DateTime validUntil;
    private Long cacheDuration;
    private Extensions extensions;
    private final IndexedXMLObjectChildrenList<RoleDescriptor> roleDescriptors = new IndexedXMLObjectChildrenList((XMLObject)this);
    private AffiliationDescriptor affiliationDescriptor;
    private Organization organization;
    private final XMLObjectChildrenList<ContactPerson> contactPersons = new XMLObjectChildrenList((XMLObject)this);
    private final XMLObjectChildrenList<AdditionalMetadataLocation> additionalMetadata = new XMLObjectChildrenList((XMLObject)this);
    private final AttributeMap unknownAttributes = new AttributeMap((XMLObject)this);

    protected EntityDescriptorImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public String getEntityID() {
        return this.entityID;
    }

    public void setEntityID(String newId) {
        if (newId != null && newId.length() > 1024) {
            throw new IllegalArgumentException("Entity ID can not exceed 1024 characters in length");
        }
        this.entityID = this.prepareForAssignment(this.entityID, newId);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String newID) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newID);
        this.registerOwnID(oldID, this.id);
    }

    public boolean isValid() {
        if (null == this.validUntil) {
            return true;
        }
        DateTime now = new DateTime();
        return now.isBefore((ReadableInstant)this.validUntil);
    }

    public DateTime getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(DateTime newValidUntil) {
        this.validUntil = this.prepareForAssignment(this.validUntil, newValidUntil);
    }

    public Long getCacheDuration() {
        return this.cacheDuration;
    }

    public void setCacheDuration(Long duration) {
        this.cacheDuration = (Long)this.prepareForAssignment(this.cacheDuration, duration);
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Extensions newExtensions) {
        this.extensions = (Extensions)this.prepareForAssignment((XMLObject)this.extensions, (XMLObject)newExtensions);
    }

    public List<RoleDescriptor> getRoleDescriptors() {
        return this.roleDescriptors;
    }

    public List<RoleDescriptor> getRoleDescriptors(QName typeOrName) {
        return this.roleDescriptors.subList(typeOrName);
    }

    public List<RoleDescriptor> getRoleDescriptors(QName type, String supportedProtocol) {
        ArrayList<RoleDescriptor> supportingRoleDescriptors = new ArrayList<RoleDescriptor>();
        for (RoleDescriptor descriptor : this.roleDescriptors.subList(type)) {
            if (!descriptor.isSupportedProtocol(supportedProtocol)) continue;
            supportingRoleDescriptors.add(descriptor);
        }
        return supportingRoleDescriptors;
    }

    public IDPSSODescriptor getIDPSSODescriptor(String supportedProtocol) {
        List<RoleDescriptor> descriptors = this.getRoleDescriptors(IDPSSODescriptor.DEFAULT_ELEMENT_NAME, supportedProtocol);
        if (descriptors.size() > 0) {
            return (IDPSSODescriptor)descriptors.get(0);
        }
        return null;
    }

    public SPSSODescriptor getSPSSODescriptor(String supportedProtocol) {
        List<RoleDescriptor> descriptors = this.getRoleDescriptors(SPSSODescriptor.DEFAULT_ELEMENT_NAME, supportedProtocol);
        if (descriptors.size() > 0) {
            return (SPSSODescriptor)descriptors.get(0);
        }
        return null;
    }

    public AuthnAuthorityDescriptor getAuthnAuthorityDescriptor(String supportedProtocol) {
        List<RoleDescriptor> descriptors = this.getRoleDescriptors(AuthnAuthorityDescriptor.DEFAULT_ELEMENT_NAME, supportedProtocol);
        if (descriptors.size() > 0) {
            return (AuthnAuthorityDescriptor)descriptors.get(0);
        }
        return null;
    }

    public AttributeAuthorityDescriptor getAttributeAuthorityDescriptor(String supportedProtocol) {
        List<RoleDescriptor> descriptors = this.getRoleDescriptors(AttributeAuthorityDescriptor.DEFAULT_ELEMENT_NAME, supportedProtocol);
        if (descriptors.size() > 0) {
            return (AttributeAuthorityDescriptor)descriptors.get(0);
        }
        return null;
    }

    public PDPDescriptor getPDPDescriptor(String supportedProtocol) {
        List<RoleDescriptor> descriptors = this.getRoleDescriptors(PDPDescriptor.DEFAULT_ELEMENT_NAME, supportedProtocol);
        if (descriptors.size() > 0) {
            return (PDPDescriptor)descriptors.get(0);
        }
        return null;
    }

    public AffiliationDescriptor getAffiliationDescriptor() {
        return this.affiliationDescriptor;
    }

    public void setAffiliationDescriptor(AffiliationDescriptor descriptor) {
        this.affiliationDescriptor = (AffiliationDescriptor)this.prepareForAssignment((XMLObject)this.affiliationDescriptor, (XMLObject)descriptor);
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization newOrganization) {
        this.organization = (Organization)this.prepareForAssignment((XMLObject)this.organization, (XMLObject)newOrganization);
    }

    public List<ContactPerson> getContactPersons() {
        return this.contactPersons;
    }

    public List<AdditionalMetadataLocation> getAdditionalMetadataLocations() {
        return this.additionalMetadata;
    }

    public AttributeMap getUnknownAttributes() {
        return this.unknownAttributes;
    }

    public String getSignatureReferenceID() {
        return this.id;
    }

    public List<XMLObject> getOrderedChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        if (this.getSignature() != null) {
            children.add(this.getSignature());
        }
        children.add(this.getExtensions());
        children.addAll((Collection<Object>)this.roleDescriptors);
        children.add(this.getAffiliationDescriptor());
        children.add(this.getOrganization());
        children.addAll((Collection<Object>)this.contactPersons);
        children.addAll((Collection<Object>)this.additionalMetadata);
        return Collections.unmodifiableList(children);
    }
}

