/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.security;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.binding.SAMLMessageContext;
import org.opensaml.saml.common.binding.security.BaseSAMLSimpleSignatureSecurityPolicyRule;
import org.opensaml.security.credential.Credential;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCriterion;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SAML2HTTPPostSimpleSignRule
extends BaseSAMLSimpleSignatureSecurityPolicyRule {
    private Logger log = LoggerFactory.getLogger(SAML2HTTPPostSimpleSignRule.class);
    private ParserPool parser;
    private KeyInfoCredentialResolver keyInfoResolver;

    public SAML2HTTPPostSimpleSignRule(SignatureTrustEngine engine, ParserPool parserPool, KeyInfoCredentialResolver keyInfoCredResolver) {
        super(engine);
        this.parser = parserPool;
        this.keyInfoResolver = keyInfoCredResolver;
    }

    @Override
    protected boolean ruleHandles(HttpServletRequest request, SAMLMessageContext samlMsgCtx) {
        return "POST".equals(request.getMethod());
    }

    @Override
    protected byte[] getSignedContent(HttpServletRequest request) throws SecurityPolicyException {
        StringBuilder builder;
        block8: {
            builder = new StringBuilder();
            try {
                if (request.getParameter("SAMLRequest") != null) {
                    String samlMsg = new String(Base64Support.decode((String)request.getParameter("SAMLRequest")), "UTF-8");
                    builder.append("SAMLRequest=" + samlMsg);
                    break block8;
                }
                if (request.getParameter("SAMLResponse") != null) {
                    String samlMsg = new String(Base64Support.decode((String)request.getParameter("SAMLResponse")), "UTF-8");
                    builder.append("SAMLResponse=" + samlMsg);
                    break block8;
                }
                this.log.warn("Could not extract either a SAMLRequest or a SAMLResponse from the form control data");
                throw new SecurityPolicyException("Extract of SAMLRequest or SAMLResponse from form control data");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (request.getParameter("RelayState") != null) {
            builder.append("&RelayState=" + request.getParameter("RelayState"));
        }
        builder.append("&SigAlg=" + request.getParameter("SigAlg"));
        String constructed = builder.toString();
        if (Strings.isNullOrEmpty((String)constructed)) {
            this.log.warn("Could not construct signed content string from form control data");
            return null;
        }
        this.log.debug("Constructed signed content string for HTTP-Post-SimpleSign {}", (Object)constructed);
        try {
            return constructed.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    @Override
    protected List<Credential> getRequestCredentials(HttpServletRequest request, SAMLMessageContext samlContext) throws SecurityPolicyException {
        String kiBase64 = request.getParameter("KeyInfo");
        if (Strings.isNullOrEmpty((String)kiBase64)) {
            this.log.debug("Form control data did not contain a KeyInfo");
            return null;
        }
        this.log.debug("Found a KeyInfo in form control data, extracting validation credentials");
        Unmarshaller unmarshaller = XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(KeyInfo.DEFAULT_ELEMENT_NAME);
        if (unmarshaller == null) {
            throw new SecurityPolicyException("Could not obtain a KeyInfo unmarshaller");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(Base64Support.decode((String)kiBase64));
        KeyInfo keyInfo = null;
        try {
            Document doc = this.parser.parse((InputStream)is);
            keyInfo = (KeyInfo)unmarshaller.unmarshall(doc.getDocumentElement());
        }
        catch (XMLParserException e) {
            this.log.warn("Error parsing KeyInfo data", (Throwable)e);
            throw new SecurityPolicyException("Error parsing KeyInfo data", (Exception)((Object)e));
        }
        catch (UnmarshallingException e) {
            this.log.warn("Error unmarshalling KeyInfo data", (Throwable)e);
            throw new SecurityPolicyException("Error unmarshalling KeyInfo data", (Exception)((Object)e));
        }
        if (keyInfo == null) {
            this.log.warn("Could not successfully extract KeyInfo object from the form control data");
            return null;
        }
        ArrayList<Credential> credentials = new ArrayList<Credential>();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new KeyInfoCriterion(keyInfo)});
        try {
            for (Credential cred : this.keyInfoResolver.resolve((Object)criteriaSet)) {
                credentials.add(cred);
            }
        }
        catch (ResolverException e) {
            this.log.warn("Error resolving credentials from KeyInfo", (Throwable)e);
            throw new SecurityPolicyException("Error resolving credentials from KeyInfo", (Exception)((Object)e));
        }
        return credentials;
    }
}

