/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.encoding;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.net.HttpServletSupport;
import net.shibboleth.utilities.java.support.net.UriSupport;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.binding.encoding.BaseSAML2MessageEncoder;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.SecurityConfiguration;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.crypto.XMLSigningUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class HTTPRedirectDeflateEncoder
extends BaseSAML2MessageEncoder {
    private final Logger log = LoggerFactory.getLogger(HTTPRedirectDeflateEncoder.class);

    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
    }

    public boolean providesMessageConfidentiality(MessageContext messageContext) throws MessageEncodingException {
        return false;
    }

    public boolean providesMessageIntegrity(MessageContext messageContext) throws MessageEncodingException {
        return false;
    }

    protected void doEncode() throws MessageEncodingException {
        MessageContext messageContext = this.getMessageContext();
        SAMLObject outboundMessage = (SAMLObject)messageContext.getMessage();
        String endpointURL = this.getEndpointURL((MessageContext<SAMLObject>)messageContext).toString();
        this.setResponseDestination(outboundMessage, endpointURL);
        this.removeSignature(outboundMessage);
        String encodedMessage = this.deflateAndBase64Encode(outboundMessage);
        String redirectURL = this.buildRedirectURL((MessageContext<SAMLObject>)messageContext, endpointURL, encodedMessage);
        HttpServletResponse response = this.getHttpServletResponse();
        HttpServletSupport.addNoCacheHeaders((HttpServletResponse)response);
        HttpServletSupport.setUTF8Encoding((HttpServletResponse)response);
        try {
            response.sendRedirect(redirectURL);
        }
        catch (IOException e) {
            throw new MessageEncodingException("Problem sending HTTP redirect", (Exception)e);
        }
    }

    protected void removeSignature(SAMLObject message) {
        SignableSAMLObject signableMessage;
        if (message instanceof SignableSAMLObject && (signableMessage = (SignableSAMLObject)message).isSigned()) {
            this.log.debug("Removing SAML protocol message signature");
            signableMessage.setSignature(null);
        }
    }

    protected String deflateAndBase64Encode(SAMLObject message) throws MessageEncodingException {
        this.log.debug("Deflating and Base64 encoding SAML message");
        try {
            String messageStr = SerializeSupport.nodeToString((Node)this.marshallMessage((XMLObject)message));
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            Deflater deflater = new Deflater(8, true);
            DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)bytesOut, deflater);
            deflaterStream.write(messageStr.getBytes("UTF-8"));
            deflaterStream.finish();
            return Base64Support.encode((byte[])bytesOut.toByteArray(), (boolean)false);
        }
        catch (IOException e) {
            throw new MessageEncodingException("Unable to DEFLATE and Base64 encode SAML message", (Exception)e);
        }
    }

    protected String buildRedirectURL(MessageContext<SAMLObject> messageContext, String endpoint, String message) throws MessageEncodingException {
        Credential signingCredential;
        URI endpointUrl;
        this.log.debug("Building URL to redirect client to");
        try {
            endpointUrl = new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new MessageEncodingException("Endpoint URL " + endpoint + " is not a valid URL", (Exception)e);
        }
        List queryParams = UriSupport.parseQueryString((String)endpointUrl.getQuery());
        queryParams.clear();
        SAMLObject outboundMessage = (SAMLObject)messageContext.getMessage();
        if (outboundMessage instanceof RequestAbstractType) {
            queryParams.add(new Pair((Object)"SAMLRequest", (Object)message));
        } else if (outboundMessage instanceof StatusResponseType) {
            queryParams.add(new Pair((Object)"SAMLResponse", (Object)message));
        } else {
            throw new MessageEncodingException("SAML message is neither a SAML RequestAbstractType or StatusResponseType");
        }
        String relayState = SAMLBindingSupport.getRelayState(messageContext);
        if (SAMLBindingSupport.checkRelayState((String)relayState)) {
            queryParams.add(new Pair((Object)"RelayState", (Object)relayState));
        }
        if ((signingCredential = this.getContextSigningCredential(messageContext)) != null) {
            String sigAlgURI = this.getSignatureAlgorithmURI(signingCredential, null);
            Pair sigAlg = new Pair((Object)"SigAlg", (Object)sigAlgURI);
            queryParams.add(sigAlg);
            String sigMaterial = UriSupport.buildQuery((List)queryParams);
            queryParams.add(new Pair((Object)"Signature", (Object)this.generateSignature(signingCredential, sigAlgURI, sigMaterial)));
            endpointUrl = UriSupport.setQuery((URI)endpointUrl, (List)queryParams);
        }
        return endpointUrl.toASCIIString();
    }

    protected String getSignatureAlgorithmURI(Credential credential, SecurityConfiguration config) throws MessageEncodingException {
        SecurityConfiguration secConfig = config != null ? config : SecurityConfigurationSupport.getGlobalXMLSecurityConfiguration();
        String signAlgo = secConfig.getSignatureAlgorithmURI(credential);
        if (signAlgo == null) {
            throw new MessageEncodingException("The signing credential's algorithm URI could not be derived");
        }
        return signAlgo;
    }

    protected String generateSignature(Credential signingCredential, String algorithmURI, String queryString) throws MessageEncodingException {
        this.log.debug(String.format("Generating signature with key type '%s', algorithm URI '%s' over query string '%s'", CredentialSupport.extractSigningKey((Credential)signingCredential).getAlgorithm(), algorithmURI, queryString));
        String b64Signature = null;
        try {
            byte[] rawSignature = XMLSigningUtil.signWithURI((Credential)signingCredential, (String)algorithmURI, (byte[])queryString.getBytes("UTF-8"));
            b64Signature = Base64Support.encode((byte[])rawSignature, (boolean)false);
            this.log.debug("Generated digital signature value (base64-encoded) {}", (Object)b64Signature);
        }
        catch (SecurityException e) {
            this.log.error("Error during URL signing process", (Throwable)e);
            throw new MessageEncodingException("Unable to sign URL query string", (Exception)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return b64Signature;
    }
}

