/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.encoding;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.UriSupport;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.messaging.context.BasicMessageMetadataContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.common.context.SamlArtifactContext;
import org.opensaml.saml.config.SAMLConfigurationSupport;
import org.opensaml.saml.saml2.binding.artifact.AbstractSAML2Artifact;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactBuilder;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.opensaml.saml.saml2.binding.encoding.BaseSAML2MessageEncoder;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPArtifactEncoder
extends BaseSAML2MessageEncoder {
    private final Logger log = LoggerFactory.getLogger(HTTPArtifactEncoder.class);
    private boolean postEncoding = false;
    private VelocityEngine velocityEngine;
    private String velocityTemplateId;
    private SAMLArtifactMap artifactMap;
    private byte[] defaultArtifactType = SAML2ArtifactType0004.TYPE_CODE;

    public HTTPArtifactEncoder(VelocityEngine engine, String template, SAMLArtifactMap map) {
    }

    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact";
    }

    public boolean isPostEncoding() {
        return this.postEncoding;
    }

    public void setPostEncoding(boolean post) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.postEncoding = post;
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine newVelocityEngine) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.velocityEngine = newVelocityEngine;
    }

    public String getVelocityTemplateId() {
        return this.velocityTemplateId;
    }

    public void setVelocityTemplateId(String newVelocityTemplateId) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.velocityTemplateId = newVelocityTemplateId;
    }

    public SAMLArtifactMap getArtifactMap() {
        return this.artifactMap;
    }

    public void setArtifactMap(SAMLArtifactMap newArtifactMap) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.artifactMap = newArtifactMap;
    }

    public boolean providesMessageConfidentiality(MessageContext messageContext) throws MessageEncodingException {
        return false;
    }

    public boolean providesMessageIntegrity(MessageContext messageContext) throws MessageEncodingException {
        return false;
    }

    protected void doDestroy() {
        this.velocityEngine = null;
        this.velocityTemplateId = null;
        this.artifactMap = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.artifactMap == null) {
            throw new ComponentInitializationException("SAML artifact map must be supplied");
        }
        if (this.isPostEncoding()) {
            if (this.velocityEngine == null) {
                throw new ComponentInitializationException("VelocityEngine must be supplied");
            }
            if (this.velocityTemplateId == null) {
                throw new ComponentInitializationException("Velocity template id must be supplied");
            }
        }
    }

    protected void doEncode() throws MessageEncodingException {
        HttpServletResponse response = this.getHttpServletResponse();
        response.setCharacterEncoding("UTF-8");
        if (this.postEncoding) {
            this.postEncode();
        } else {
            this.getEncode();
        }
    }

    protected void postEncode() throws MessageEncodingException {
        this.log.debug("Performing HTTP POST SAML 2 artifact encoding");
        MessageContext messageContext = this.getMessageContext();
        this.log.debug("Creating velocity context");
        VelocityContext context = new VelocityContext();
        Encoder esapiEncoder = ESAPI.encoder();
        String endpointURL = this.getEndpointURL((MessageContext<SAMLObject>)messageContext).toString();
        String encodedEndpointURL = esapiEncoder.encodeForHTMLAttribute(endpointURL);
        this.log.debug("Setting action parameter to: '{}', encoded as '{}'", (Object)endpointURL, (Object)encodedEndpointURL);
        context.put("action", (Object)encodedEndpointURL);
        context.put("SAMLArt", (Object)this.buildArtifact((MessageContext<SAMLObject>)messageContext).base64Encode());
        String relayState = SAMLBindingSupport.getRelayState((MessageContext)messageContext);
        if (SAMLBindingSupport.checkRelayState((String)relayState)) {
            String encodedRelayState = esapiEncoder.encodeForHTMLAttribute(relayState);
            this.log.debug("Setting RelayState parameter to: '{}', encoded as '{}'", (Object)relayState, (Object)encodedRelayState);
            context.put("RelayState", (Object)encodedRelayState);
        }
        try {
            this.log.debug("Invoking velocity template");
            HttpServletResponse response = this.getHttpServletResponse();
            OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)response.getOutputStream());
            this.velocityEngine.mergeTemplate(this.velocityTemplateId, "UTF-8", (Context)context, (Writer)outWriter);
        }
        catch (Exception e) {
            this.log.error("Error invoking velocity template to create POST form", (Throwable)e);
            throw new MessageEncodingException("Error creating output document", e);
        }
    }

    protected void getEncode() throws MessageEncodingException {
        this.log.debug("Performing HTTP GET SAML 2 artifact encoding");
        MessageContext messageContext = this.getMessageContext();
        URI endpointUri = this.getEndpointURL((MessageContext<SAMLObject>)messageContext);
        List params = UriSupport.parseQueryString((String)endpointUri.getQuery());
        AbstractSAML2Artifact artifact = this.buildArtifact((MessageContext<SAMLObject>)messageContext);
        if (artifact == null) {
            this.log.error("Unable to build artifact for message to relying party");
            throw new MessageEncodingException("Unable to builder artifact for message to relying party");
        }
        params.add(new Pair((Object)"SAMLart", (Object)artifact.base64Encode()));
        String relayState = SAMLBindingSupport.getRelayState((MessageContext)messageContext);
        if (SAMLBindingSupport.checkRelayState((String)relayState)) {
            params.add(new Pair((Object)"RelayState", (Object)relayState));
        }
        HttpServletResponse response = this.getHttpServletResponse();
        try {
            response.sendRedirect(endpointUri.toASCIIString());
        }
        catch (IOException e) {
            throw new MessageEncodingException("Problem sending HTTP redirect", (Exception)e);
        }
    }

    protected AbstractSAML2Artifact buildArtifact(MessageContext<SAMLObject> messageContext) throws MessageEncodingException {
        SAML2ArtifactBuilder artifactBuilder;
        byte[] artifactType = this.getSamlArtifactType(messageContext);
        if (artifactType != null) {
            artifactBuilder = SAMLConfigurationSupport.getSAML2ArtifactBuilderFactory().getArtifactBuilder(artifactType);
        } else {
            artifactBuilder = SAMLConfigurationSupport.getSAML2ArtifactBuilderFactory().getArtifactBuilder(this.defaultArtifactType);
            this.storeSamlArtifactType(messageContext, this.defaultArtifactType);
        }
        AbstractSAML2Artifact artifact = artifactBuilder.buildArtifact(messageContext);
        if (artifact == null) {
            this.log.error("Unable to build artifact for message to relying party");
            throw new MessageEncodingException("Unable to builder artifact for message to relying party");
        }
        String encodedArtifact = artifact.base64Encode();
        try {
            this.artifactMap.put(encodedArtifact, this.getInboundMessageIssuer(messageContext), this.getOutboundMessageIssuer(messageContext), (SAMLObject)messageContext.getMessage());
        }
        catch (MarshallingException e) {
            this.log.error("Unable to marshall assertion to be represented as an artifact", (Throwable)e);
            throw new MessageEncodingException("Unable to marshall assertion to be represented as an artifact", (Exception)((Object)e));
        }
        return artifact;
    }

    private String getOutboundMessageIssuer(MessageContext<SAMLObject> messageContext) {
        BasicMessageMetadataContext basicContext = (BasicMessageMetadataContext)messageContext.getSubcontext(BasicMessageMetadataContext.class, false);
        Constraint.isNotNull((Object)basicContext, (String)"Message context did not contain a BasicMessageMetadataContext");
        return basicContext.getMessageIssuer();
    }

    private String getInboundMessageIssuer(MessageContext<SAMLObject> messageContext) {
        return null;
    }

    private void storeSamlArtifactType(MessageContext<SAMLObject> messageContext, byte[] artifactType) {
        ((SamlArtifactContext)messageContext.getSubcontext(SamlArtifactContext.class, true)).setArtifactType(artifactType);
    }

    private byte[] getSamlArtifactType(MessageContext<SAMLObject> messageContext) {
        return ((SamlArtifactContext)messageContext.getSubcontext(SamlArtifactContext.class, true)).getArtifactType();
    }
}

